/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.members.endpoints;

import com.adobe.cq.social.members.api.CommunityMemberGroup;
import com.adobe.cq.social.members.api.MembersUtils;
import com.adobe.cq.social.members.endpoints.CommunityMemberGroupProfileOperationExtension;
import com.adobe.cq.social.members.endpoints.CommunityMemberGroupProfileOperations;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.ClientUtilityFactory;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.jcr.JcrUtil;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.value.StringValue;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractCommunityMemberGroupProfileOperationService<T extends OperationExtension, U extends Operation>
extends AbstractOperationService<T, U, CommunityMemberGroup>
implements CommunityMemberGroupProfileOperations {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommunityMemberGroupProfileOperationService.class);
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;
    @Reference
    private SlingRepository repository;
    @Reference
    private ResourceResolverFactory rrf;
    protected ComponentContext context;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private XSSAPI xss;
    @Reference
    private SocialUtils socialUtils;
    @Reference
    private ClientUtilityFactory clientUtilFactory;
    @Reference
    private MembersUtils membersUtils;
    private final String PROFILE_PATH = "./profile/";

    @Override
    public SocialComponent getSocialComponentForGroup(Resource group, SlingHttpServletRequest request) {
        return this.getSocialComponentForGroup(group, this.getClientUtils(request));
    }

    public SocialComponent getSocialComponentForGroup(Resource group, ClientUtilities clientUtilities) {
        return this.membersUtils.getCommunityGroupProfile(group.getName().equals("profile") ? group : group.getChild("profile"), clientUtilities, "social/members/components/hbs/groupprofile");
    }

    private SocialComponent getSocialComponent(Resource group, ClientUtilities clientUtilities) {
        String groupId;
        try {
            groupId = group.adaptTo(Node.class).getProperty("rep:authorizableId").getString();
        }
        catch (RepositoryException e) {
            LOG.debug("failed to get groupId from resource {}", (Object)group.getName(), (Object)e);
            groupId = group.getName();
        }
        return this.membersUtils.getCommunityGroup(groupId, group.getResourceResolver(), clientUtilities, "social/members/components/hbs/groups/group");
    }

    protected ClientUtilities getClientUtils(SlingHttpServletRequest request) {
        return this.clientUtilFactory.getClientUtilities(this.xss, request, this.socialUtils);
    }

    @Override
    public Resource update(SlingHttpServletRequest request) throws OperationException {
        this.ensurePropertyExists(request, "groupId");
        RequestParameterMap requestParameterMap = request.getRequestParameterMap();
        Session session = request.getResource().getResourceResolver().adaptTo(Session.class);
        Map<String, Object> requestParams = this.getRequestParams(requestParameterMap);
        Resource resource = this.update(request.getResource(), requestParams, this.getClientUtils(request));
        this.checkMembers(resource, requestParameterMap, session);
        return resource;
    }

    private void ensurePropertyExists(SlingHttpServletRequest request, String property) throws OperationException {
        this.ensurePropertyExists(request.getRequestParameterMap(), property);
    }

    private void ensurePropertyExists(RequestParameterMap map, String property) throws OperationException {
        if (!map.containsKey(property)) {
            throw new OperationException("Undefined " + property + " from the request.", 400);
        }
    }

    private void checkMembers(Resource resource, RequestParameterMap requestParameterMap, Session session) throws OperationException {
        try {
            String groupId = requestParameterMap.getValue("groupId").getString();
            UserManager userManager = resource.adaptTo(UserManager.class);
            ResourceResolver resolver = resource.getResourceResolver();
            Group group = (Group)userManager.getAuthorizable(groupId);
            ArrayList<String> memberId = new ArrayList<String>();
            if (requestParameterMap.containsKey("memberId")) {
                memberId.addAll(Arrays.asList(this.toStringArray(requestParameterMap.getValues("memberId"))));
            }
            Iterator<Authorizable> members = group.getDeclaredMembers();
            ArrayList<String> membersList = new ArrayList<String>();
            while (members.hasNext()) {
                Authorizable member = members.next();
                membersList.add(member.getID());
                if (memberId.contains(member.getID()) || !this.isValidGroupMember(resolver, member)) continue;
                this.performMemberOperations(group, member, this.getRemoveMemberOperation());
            }
            for (String member : memberId) {
                Authorizable authorizable;
                if (membersList.contains(member) || (authorizable = userManager.getAuthorizable(member)) == null) continue;
                this.performMemberOperations(group, authorizable, this.getAddMemberOperation());
            }
            session.save();
        }
        catch (RepositoryException e) {
            this.cleanupFailure(session);
            throw new OperationException(e.getMessage(), e, 500);
        }
    }

    private boolean isValidGroupMember(ResourceResolver resolver, Authorizable member) {
        Resource authResource = null;
        try {
            authResource = resolver.getResource(member.getPath());
        }
        catch (RepositoryException e) {
            LOG.debug("Failed to get child group resource. UserId - {}.", (Object)resolver.getUserID());
        }
        return this.membersUtils.isValidGroupMember(authResource);
    }

    private void performMemberOperations(Group group, Authorizable member, U operation) {
        String groupId = "";
        String memberId = "";
        try {
            groupId = group.getID();
            memberId = member.getID();
            if (operation.equals(CommunityMemberGroupProfileOperationExtension.MemberGroupOperation.REMOVE_MEMBER)) {
                group.removeMember(member);
            } else if (operation.equals(CommunityMemberGroupProfileOperationExtension.MemberGroupOperation.ADD_MEMBER)) {
                group.addMember(member);
            } else {
                LOG.debug(String.format("Failed to perform unknown member operation for %s and %s", groupId, memberId));
            }
        }
        catch (RepositoryException e) {
            LOG.debug(String.format("Failed to perform member operation for %s and %s", groupId, memberId));
        }
    }

    @Override
    public Resource update(Resource resource, Map<String, Object> requestParams, ClientUtilities clientUtils) throws OperationException {
        String groupId = (String)requestParams.get("groupId");
        String givenName = (String)requestParams.get("givenName");
        String aboutMe = (String)requestParams.get("aboutMe");
        if (StringUtils.isEmpty((String)groupId)) {
            throw new OperationException("Missing groupId from the request.", 400);
        }
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        if (session != null) {
            try {
                UserManager userManager = resource.adaptTo(UserManager.class);
                Group group = (Group)userManager.getAuthorizable(groupId);
                if (!StringUtils.isEmpty((String)givenName)) {
                    group.setProperty("./profile/givenName", new StringValue(givenName));
                }
                if (!StringUtils.isEmpty((String)aboutMe)) {
                    group.setProperty("./profile/aboutMe", new StringValue(aboutMe));
                }
                return resource.getResourceResolver().getResource(group.getPath());
            }
            catch (RepositoryException e) {
                this.cleanupFailure(session);
                throw new OperationException(e.getMessage(), e, 500);
            }
        }
        throw new OperationException("Session is null", 500);
    }

    @Override
    public Resource addMember(SlingHttpServletRequest request) throws OperationException {
        this.ensurePropertyExists(request, "groupId");
        this.ensurePropertyExists(request, "memberId");
        Map<String, Object> requestParams = this.getRequestParams(request.getRequestParameterMap());
        return this.addMember(request.getResource(), requestParams, this.getClientUtils(request));
    }

    @Override
    public Resource addMember(Resource resource, Map<String, Object> requestParams, ClientUtilities clientUtils) throws OperationException {
        return this.addOrRemoveMember(resource, requestParams, this.getAddMemberOperation());
    }

    @Override
    public Resource removeMember(SlingHttpServletRequest request) throws OperationException {
        this.ensurePropertyExists(request, "groupId");
        this.ensurePropertyExists(request, "memberId");
        Map<String, Object> requestParams = this.getRequestParams(request.getRequestParameterMap());
        return this.removeMember(request.getResource(), requestParams, this.getClientUtils(request));
    }

    @Override
    public Resource removeMember(Resource resource, Map<String, Object> requestParams, ClientUtilities clientUtils) throws OperationException {
        return this.addOrRemoveMember(resource, requestParams, this.getRemoveMemberOperation());
    }

    public Resource addOrRemoveMember(Resource resource, Map<String, Object> requestParams, U operation) throws OperationException {
        String groupId = (String)requestParams.get("groupId");
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        if (session != null) {
            try {
                String[] stringArray;
                UserManager userManager = resource.adaptTo(UserManager.class);
                Group group = (Group)userManager.getAuthorizable(groupId);
                if (group == null) {
                    String error = "Failed to get authorizable for " + groupId;
                    LOG.error(error);
                    throw new OperationException(error, 404);
                }
                if (!this.membersUtils.isValidMember(group)) {
                    String error = "No permission to modify " + groupId;
                    LOG.error(error);
                    throw new OperationException(error, 406);
                }
                if (requestParams.get("memberId") instanceof String) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)requestParams.get("memberId");
                } else {
                    stringArray = (String[])requestParams.get("memberId");
                }
                String[] members = stringArray;
                for (int i = 0; i < members.length; ++i) {
                    this.addOrRemoveMember(group, members[i], operation, session);
                }
                session.save();
                return resource.getResourceResolver().getResource(group.getPath());
            }
            catch (RepositoryException e) {
                this.cleanupFailure(session);
                throw new OperationException(e.getMessage(), e, 500);
            }
        }
        throw new OperationException("Session is null", 500);
    }

    private void addOrRemoveMember(Group group, String memberId, U operation, Session session) throws OperationException {
        block8: {
            try {
                UserManager userManager = AccessControlUtil.getUserManager(session);
                if (group == null || StringUtils.isEmpty((String)memberId)) break block8;
                Authorizable authorizable = userManager.getAuthorizable(memberId);
                if (authorizable == null) {
                    String error = "Failed to get authorizable for " + memberId;
                    LOG.debug(error);
                    throw new OperationException(error, 404);
                }
                if (this.membersUtils.isValidMember(authorizable)) {
                    boolean success = false;
                    if (operation.equals(this.getAddMemberOperation()) && !group.isMember(authorizable)) {
                        success = group.addMember(authorizable);
                    } else if (operation.equals(this.getRemoveMemberOperation()) && group.isMember(authorizable)) {
                        success = group.removeMember(authorizable);
                    }
                    if (!success) {
                        String error = String.format(operation.equals(this.getAddMemberOperation()) ? "Failed to add %s to %s" : "Failed to remove %s from %s", memberId, group.getID());
                        LOG.error(error);
                        throw new OperationException(error, 501);
                    }
                    break block8;
                }
                String error = "No permission to get authorizable for " + memberId;
                LOG.error(error);
                throw new OperationException(error, 406);
            }
            catch (RepositoryException e) {
                String error = operation.equals(this.getAddMemberOperation()) ? "Failed to add member to Group" : "Failed to remove member from Group";
                LOG.error(error, (Throwable)e);
                throw new OperationException(error, 500);
            }
        }
    }

    @Override
    public Resource create(SlingHttpServletRequest request) throws OperationException {
        this.ensurePropertyExists(request, "groupId");
        RequestParameterMap requestParameterMap = request.getRequestParameterMap();
        Session session = request.getResource().getResourceResolver().adaptTo(Session.class);
        Map<String, Object> requestParams = this.getRequestParams(requestParameterMap);
        Resource resource = this.createGroup(request.getResource(), requestParams, this.getClientUtils(request));
        this.checkMembers(resource, requestParameterMap, session);
        return resource;
    }

    private Map<String, Object> getRequestParams(RequestParameterMap params) throws OperationException {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        Iterator i$ = params.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            RequestParameter[] values = params.getValues(key = (String)i$.next());
            requestParams.put(key, values.length > 1 ? this.toStringArray(params.getValues(key)) : params.getValue(key).getString());
        }
        return requestParams;
    }

    @Override
    public Resource createGroup(Resource resource, Map<String, Object> requestParams, ClientUtilities clientUtils) throws OperationException {
        final String groupId = (String)requestParams.get("groupId");
        String givenName = (String)requestParams.get("givenName");
        String aboutMe = (String)requestParams.get("aboutMe");
        if (StringUtils.isEmpty((String)groupId)) {
            throw new OperationException("Missing groupId from the request.", 400);
        }
        try {
            ResourceResolver resolver = resource.getResourceResolver();
            U createOperation = this.getCreateOperation();
            Session session = resolver.adaptTo(Session.class);
            this.performBeforeActions(createOperation, session, resource, requestParams);
            UserManager userManager = AccessControlUtil.getUserManager(session);
            Group group = userManager.createGroup(new Principal(){

                @Override
                public String getName() {
                    return groupId;
                }
            }, "/home/groups/community");
            group.setProperty("./profile/givenName", JcrUtil.createValue(StringUtils.isEmpty((String)givenName) ? groupId : givenName, session));
            if (!StringUtils.isEmpty((String)aboutMe)) {
                group.setProperty("./profile/aboutMe", JcrUtil.createValue(aboutMe, session));
            }
            CommunityMemberGroup memberGroup = (CommunityMemberGroup)this.getSocialComponent(resolver.getResource(group.getPath()), clientUtils);
            this.performAfterActions(createOperation, session, memberGroup, requestParams);
            return resolver.getResource(group.getPath());
        }
        catch (RepositoryException e) {
            LOG.error("failed to create new group {}", (Object)givenName, (Object)e);
            throw new OperationException("Failed to create new Group", 500);
        }
    }

    private String[] toStringArray(RequestParameter[] values) {
        String[] stringValues = null;
        if (values != null && values.length > 0) {
            stringValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                stringValues[i] = values[i].getString();
            }
        }
        return stringValues;
    }

    protected void cleanupFailure(Session session) {
        try {
            session.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.error("Failed to refresh the session", (Throwable)e);
        }
    }

    protected abstract U getCreateOperation();

    protected abstract U getAddMemberOperation();

    protected abstract U getRemoveMemberOperation();

    protected abstract U getUpdateOperation();

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindXss(XSSAPI xSSAPI) {
        this.xss = xSSAPI;
    }

    protected void unbindXss(XSSAPI xSSAPI) {
        if (this.xss == xSSAPI) {
            this.xss = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        this.clientUtilFactory = clientUtilityFactory;
    }

    protected void unbindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        if (this.clientUtilFactory == clientUtilityFactory) {
            this.clientUtilFactory = null;
        }
    }

    protected void bindMembersUtils(MembersUtils membersUtils) {
        this.membersUtils = membersUtils;
    }

    protected void unbindMembersUtils(MembersUtils membersUtils) {
        if (this.membersUtils == membersUtils) {
            this.membersUtils = null;
        }
    }
}

