/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.moderation.dashboard.api;

import com.adobe.cq.social.moderation.dashboard.api.FilterGroupSocialComponentFactory;
import com.adobe.cq.social.moderation.dashboard.impl.ModerationDashboardImpl;
import com.adobe.cq.social.moderation.dashboard.impl.ModerationDashboardQueryInfo;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseQueryRequestInfo;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

@Component(metatype=true, label="AEM Communities Moderation Dashboard", description="This component provides a dashboard for moderators to use.", immediate=true)
@Service
public class ModerationDashboardSocialComponentFactory
extends AbstractSocialComponentFactory {
    @Reference
    private SocialComponentFactoryManager scfm;

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        return new ModerationDashboardImpl(resource, this.getClientUtilities(resource.getResourceResolver()), this.getResourceTypeFilters());
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        return new ModerationDashboardImpl(resource, this.getClientUtilities(request), this.getQueryRequestInfo(request), this.getResourceTypeFilters());
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryRequestInfo) {
        return new ModerationDashboardImpl(resource, clientUtils, queryRequestInfo, this.getResourceTypeFilters());
    }

    private Map<String, List<String>> getResourceTypeFilters() {
        FilterGroupSocialComponentFactory filterGroupFactory = (FilterGroupSocialComponentFactory)this.scfm.getSocialComponentFactory("social/moderation/filters");
        return filterGroupFactory.getResourceTypeFilters();
    }

    @Override
    public String getSupportedResourceType() {
        return "social/moderation/dashboard";
    }

    @Override
    protected QueryRequestInfo getQueryRequestInfo(SlingHttpServletRequest request) {
        if (request != null) {
            return new ModerationDashboardQueryInfo(request);
        }
        return BaseQueryRequestInfo.DEFAULT_QUERY_REQUEST;
    }

    protected void bindScfm(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.scfm = socialComponentFactoryManager;
    }

    protected void unbindScfm(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.scfm == socialComponentFactoryManager) {
            this.scfm = null;
        }
    }
}

