/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.moderation.dashboard.api;

import com.adobe.cq.social.moderation.dashboard.impl.UserDetailsImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.user.api.UserProfile;
import com.adobe.cq.social.user.api.UserProfileComponentFactory;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

@Component(metatype=true, label="AEM Communities User Details", description="This component provides the details and activity stream of a given user.", immediate=true)
@Service
public class UserDetailsSocialComponentFactory
extends UserProfileComponentFactory {
    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        ClientUtilities clientUtils = this.getClientUtilities(resolver);
        Resource userResource = this.getUserResource(resolver, clientUtils);
        UserProfile profile = (UserProfile)super.getSocialComponent(userResource);
        return new UserDetailsImpl(userResource, clientUtils, profile);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        ResourceResolver resolver = resource.getResourceResolver();
        ClientUtilities clientUtils = this.getClientUtilities(request);
        Resource userResource = this.getUserResource(resolver, clientUtils);
        UserProfile profile = (UserProfile)super.getSocialComponent(userResource, request);
        return new UserDetailsImpl(userResource, clientUtils, profile);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo requestInfo) {
        ResourceResolver resolver = resource.getResourceResolver();
        Resource userResource = this.getUserResource(resolver, clientUtils);
        UserProfile profile = (UserProfile)super.getSocialComponent(userResource, clientUtils, requestInfo);
        return new UserDetailsImpl(userResource, clientUtils, profile);
    }

    @Override
    public String getSupportedResourceType() {
        return "social/moderation/userdetails";
    }

    private Resource getUserResource(ResourceResolver resolver, ClientUtilities clientUtils) {
        SlingHttpServletRequest request = clientUtils.getRequest();
        String userID = request.getRequestPathInfo().getSuffix();
        if (userID == null) {
            userID = clientUtils.getAuthorizedUserId();
        }
        return clientUtils.getUser(userID, resolver).getResource();
    }
}

