/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.qna.client.api;

import com.adobe.cq.social.forum.client.api.Forum;
import com.adobe.cq.social.qna.client.api.QnaPost;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.SocialEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.event.Event;

public class QnaEvent
extends SocialEvent<QnaActions> {
    public static final String QNA_TOPIC = "qna";
    private static final String QUESTION_PATH = "QUESTION_PATH";
    private static final String ANSWER_PATH = "ANSWER_PATH";
    private static final String QNA_FORUM_PATH = "QNA_FORUM_PATH";
    private static final long serialVersionUID = 1L;

    private QnaEvent(String path, String userId, QnaActions action, Map<String, Object> additionalData) {
        super(QNA_TOPIC, path, userId, action, additionalData);
    }

    private QnaEvent(Event event) {
        super(event);
    }

    private static QnaEvent buildQuestionEvent(QnaPost post, String userId, QnaActions action) {
        HashMap<String, Object> addData = new HashMap<String, Object>(2);
        addData.put(OBJECT, new SocialEvent.BaseEventObject(QnaEvent.getDisplayName(post, action), post.getResource().getPath(), "article"));
        addData.put(TARGET, new SocialEvent.BaseEventObject(QnaEvent.getDisplayName(post.getParentComponent(), action), post.getSourceComponentId(), "collection"));
        return new QnaEvent(post.getResource().getPath(), userId, action, addData);
    }

    public static QnaEvent answerUnselected(QnaPost post, String userId) {
        return QnaEvent.buildQuestionEvent(post, userId, QnaActions.ANSWER_UNSELECTED);
    }

    public static QnaEvent answerSelected(QnaPost post, String userId) {
        return QnaEvent.buildQuestionEvent(post, userId, QnaActions.ANSWER_SELECTED);
    }

    public static QnaEvent questionCreated(QnaPost post, String userId) {
        return QnaEvent.buildQuestionEvent(post, userId, QnaActions.QUESTION_CREATED);
    }

    public static QnaEvent questionEdited(QnaPost post, String userId) {
        return QnaEvent.buildQuestionEvent(post, userId, QnaActions.QUESTION_EDITED);
    }

    public static QnaEvent questionDeleted(QnaPost post, String userId) {
        return QnaEvent.buildQuestionEvent(post, userId, QnaActions.QUESTION_DELETED);
    }

    public static QnaEvent answerCreated(QnaPost post, String userId) {
        return QnaEvent.buildAnswerEvent(post, userId, QnaActions.ANSWER_CREATED);
    }

    public static QnaEvent answerDeleted(QnaPost post, String userId) {
        return QnaEvent.buildAnswerEvent(post, userId, QnaActions.ANSWER_DELETED);
    }

    public static QnaEvent answerEdited(QnaPost post, String userId) {
        return QnaEvent.buildAnswerEvent(post, userId, QnaActions.ANSWER_EDITED);
    }

    private static QnaEvent buildAnswerEvent(QnaPost post, String userId, QnaActions action) {
        HashMap<String, Object> addData = new HashMap<String, Object>(2);
        if (post.isTopic()) {
            addData.put(OBJECT, new SocialEvent.BaseEventObject(QnaEvent.getDisplayName(post, action), post.getResource().getPath(), "article"));
            addData.put(TARGET, new SocialEvent.BaseEventObject(QnaEvent.getDisplayName(post.getSourceComponent(), action), post.getSourceComponentId(), "collection"));
        } else {
            addData.put(TARGET, new SocialEvent.BaseEventObject(QnaEvent.getDisplayName(post.getParentComponent(), action), post.getParentId(), "article"));
            addData.put(OBJECT, new SocialEvent.BaseEventObject(QnaEvent.getDisplayName(post, action), post.getResource().getPath(), "comment"));
        }
        return new QnaEvent(post.getResource().getPath(), userId, action, addData);
    }

    private static String getDisplayName(SocialComponent post, QnaActions action) {
        if (post instanceof QnaPost) {
            String name;
            String string = name = action.getVerb().equals("delete") ? "" : ((QnaPost)post).getSubject();
            if (name != null) {
                return name;
            }
            return ((QnaPost)post).isTopic() ? "a question" : "an answer";
        }
        if (post instanceof Forum) {
            return ((Forum)post).getTitle();
        }
        return null;
    }

    public static enum QnaActions implements SocialEvent.SocialActions
    {
        QUESTION_CREATED,
        QUESTION_EDITED,
        QUESTION_DELETED,
        ANSWER_SELECTED,
        ANSWER_UNSELECTED,
        ANSWER_CREATED,
        ANSWER_EDITED,
        ANSWER_DELETED;

        private static final List<String> QNA_ACTIONS;

        public static List<String> getAvailableActions() {
            return QNA_ACTIONS;
        }

        @Override
        public String getVerb() {
            switch (this) {
                case QUESTION_CREATED: {
                    return "post";
                }
                case QUESTION_EDITED: {
                    return "update";
                }
                case QUESTION_DELETED: {
                    return "delete";
                }
                case ANSWER_SELECTED: {
                    return "select";
                }
                case ANSWER_UNSELECTED: {
                    return "unselect";
                }
                case ANSWER_CREATED: {
                    return "add";
                }
                case ANSWER_EDITED: {
                    return "update";
                }
                case ANSWER_DELETED: {
                    return "delete";
                }
            }
            throw new IllegalArgumentException();
        }

        static {
            QNA_ACTIONS = new ArrayList<String>();
            for (QnaActions action : QnaActions.values()) {
                QNA_ACTIONS.add("qna." + action.getVerb());
            }
        }
    }
}

