/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.reporting.analytics.api;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.reporting.analytics.services.AnalyticsReportManagementService;
import com.adobe.cq.social.reporting.dv.api.AbstractDVLineChartComponent;
import com.adobe.cq.social.reporting.dv.model.api.LineChartModel;
import com.adobe.cq.social.scf.ClientUtilities;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalyticsTrendReportComponent
extends AbstractDVLineChartComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAnalyticsTrendReportComponent.class);
    protected AnalyticsReportManagementService analyticsReportService;
    protected CommunityContext ctx;
    protected boolean isQuery = false;

    public AbstractAnalyticsTrendReportComponent(Resource resource, ClientUtilities clientUtils, AnalyticsReportManagementService analyticsReportService, boolean isQuery) {
        super(resource, clientUtils);
        this.analyticsReportService = analyticsReportService;
        this.isQuery = isQuery;
    }

    protected void querySiteCatalyst() {
        if (!this.isAnalyticsInitialized()) {
            return;
        }
        try {
            JSONObject reportDescription = this.prepareReport();
            if (reportDescription != null) {
                JSONObject result = this.analyticsReportService.runAnalyticsReport(this.resource.getResourceResolver(), this.ctx, "social/commons/components/analyticsbase", reportDescription);
                this.responseObject = this.parseResponse(result);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Failure occurred while running analytics trend report: {}", (Throwable)e);
        }
    }

    public boolean isAnalyticsInitialized() {
        return this.isQuery && this.analyticsReportService.isAnalyticsConfigured(this.resource.getResourceResolver(), this.ctx, "social/commons/components/analyticsbase");
    }

    protected abstract LineChartModel parseResponse(JSONObject var1) throws JSONException;

    protected abstract JSONObject prepareReport() throws JSONException;

    public static String getParameterValue(Map<String, String[]> map, String key) {
        if (map == null) {
            return null;
        }
        String[] values = map.get(key);
        return values == null ? null : values[0];
    }
}

