/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.review.client.api;

import com.adobe.cq.social.commons.comments.api.AbstractComment;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.review.client.api.ReviewException;
import com.adobe.cq.social.review.client.api.ReviewSocialComponent;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.tally.client.api.VotingSocialComponent;
import com.day.cq.wcm.api.designer.Style;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractReview<C extends CommentCollectionConfiguration>
extends AbstractComment<C>
implements ReviewSocialComponent<C> {
    protected final Resource resource;
    protected final ResourceResolver resolver;
    protected final Map<String, String> ratingPaths;
    private List<String> allowedRatings;
    private Style style;
    private static final Logger log = LoggerFactory.getLogger(AbstractReview.class);

    public AbstractReview(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager listProviderManager) throws RepositoryException {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), listProviderManager);
    }

    public AbstractReview(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager listProviderManager) throws RepositoryException {
        super(resource, clientUtils, queryInfo, listProviderManager);
        this.resource = resource;
        this.resolver = resource.getResourceResolver();
        this.ratingPaths = this.getRatingPaths();
    }

    protected Map<String, String> getRatingPaths() {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        ValueMap values = this.resource.adaptTo(ValueMap.class);
        String[] responsePaths = values.get("ratings", new String[0]);
        for (int i = 0; i < responsePaths.length - 1; i += 2) {
            results.put(responsePaths[i], responsePaths[i + 1]);
        }
        return results;
    }

    @Override
    public Map<String, Long> getRatingResponses() throws ReviewException {
        LinkedHashMap<String, Long> results = new LinkedHashMap<String, Long>();
        for (Map.Entry<String, String> entry : this.ratingPaths.entrySet()) {
            if (!this.getAllowedRatings().contains(entry.getKey())) continue;
            String ratingPath = entry.getValue();
            Resource r = this.resolver.resolve(ratingPath);
            Long value = this.getValueFromResponseResource(r);
            results.put(entry.getKey(), value);
        }
        for (String name : this.getAllowedRatings()) {
            if (results.containsKey(name)) continue;
            results.put(name, null);
        }
        return results;
    }

    private Long getValueFromResponseResource(Resource resource) throws ReviewException {
        if (ResourceUtil.isNonExistingResource(resource)) {
            log.error("Response resource {} doesn not exist.", (Object)resource.getPath());
            return null;
        }
        try {
            ValueMap properties = resource.adaptTo(ValueMap.class);
            String responseValue = (String)((Object)properties.get("response", String.class));
            if ("#neutral#".equals(responseValue) || responseValue == null) {
                return null;
            }
            responseValue = responseValue.substring(0, responseValue.indexOf(46));
            return Long.parseLong(responseValue);
        }
        catch (NumberFormatException e) {
            throw this.logAndThrow(e);
        }
    }

    protected List<String> getAllowedRatings() {
        String[] ratings;
        Resource reviewCollection;
        if (this.allowedRatings != null) {
            return this.allowedRatings;
        }
        SocialComponent sourceComponent = this.getSourceComponent();
        if (sourceComponent != null) {
            reviewCollection = sourceComponent.getResource();
        } else {
            String slingIncludedPath = this.getSourceComponentId();
            if (StringUtils.isEmpty((CharSequence)slingIncludedPath)) {
                log.error("Could not determine root component for review: {}", (Object)this.getId().toString());
                return this.allowedRatings;
            }
            reviewCollection = new NonExistingResource(this.resolver, slingIncludedPath);
        }
        ValueMap values = reviewCollection.adaptTo(ValueMap.class);
        if (!ResourceUtil.isNonExistingResource(reviewCollection) && values != null) {
            ratings = values.get("allowedRatings", new String[]{"Overall"});
            this.allowedRatings = Arrays.asList(ratings);
        } else {
            values = this.clientUtils.getDesignProperties(reviewCollection, "social/reviews/components/hbs/reviews");
            if (values == null) {
                log.warn("Allowed ratings property is not set for Review {}, using default", (Object)this.resource.getPath());
                this.allowedRatings = Arrays.asList("Overall");
            } else {
                ratings = values.get("allowedRatings", new String[]{"Overall"});
                this.allowedRatings = Arrays.asList(ratings);
            }
        }
        return this.allowedRatings;
    }

    @Override
    public boolean isCompositeRating() {
        if (this.getAllowedRatings() == null) {
            return false;
        }
        return this.getAllowedRatings().size() != 1;
    }

    @Override
    public VotingSocialComponent getVoting() {
        SocialComponentFactory scf;
        SocialComponentFactoryManager scfMgr;
        Resource voteResource = this.resolver.resolve(this.resource.getPath() + "/" + "voting");
        if (ResourceUtil.isNonExistingResource(voteResource)) {
            voteResource = new SyntheticResource(this.resolver, voteResource.getPath(), "social/tally/components/hbs/voting");
        }
        if ((scfMgr = this.clientUtils.getSocialComponentFactoryManager()) != null && (scf = scfMgr.getSocialComponentFactory(voteResource)) != null) {
            return (VotingSocialComponent)scf.getSocialComponent(voteResource);
        }
        return null;
    }

    private ReviewException logAndThrow(Exception e) {
        log.error("Exception encounterred when trying to read response from node", (Throwable)e);
        return new ReviewException("Exception encounterred when trying to read response from node", e);
    }
}

