/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf;

public class CollectionPagination {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_EMBED_LEVEL = 0;
    public static final CollectionPagination DEFAULT_PAGINATION = new CollectionPagination(0);
    public static final CollectionPagination EMBEDDED_LEVEL_PAGINATION = new CollectionPagination(0, 10, -1);
    private final int offset;
    private final int size;
    private final int embedLevel;
    private final String selectedIndex;
    private final int pageSizeConfig;

    public CollectionPagination(int offset, int size, int embedLevel, String selectedIndex) {
        this.offset = offset;
        this.size = size;
        this.embedLevel = embedLevel;
        this.selectedIndex = selectedIndex;
        this.pageSizeConfig = 10;
    }

    public CollectionPagination(int offset, int size, int embedLevel, String selectedIndex, int pageSizeConfig) {
        this.offset = offset;
        this.size = size;
        this.embedLevel = embedLevel;
        this.selectedIndex = selectedIndex;
        this.pageSizeConfig = pageSizeConfig;
    }

    public CollectionPagination(int offset, int size, int embedLevel) {
        this(offset, size, embedLevel, null);
    }

    public CollectionPagination(int offset, int size) {
        this(offset, size, 0, null);
    }

    public CollectionPagination(int offset) {
        this(offset, 10, 0, null);
    }

    public CollectionPagination(CollectionPagination copyFrom) {
        this.offset = copyFrom.getOffset();
        this.size = copyFrom.getSize();
        this.selectedIndex = copyFrom.getSelectedIndex();
        this.embedLevel = copyFrom.getEmbedLevel();
        this.pageSizeConfig = copyFrom.getPageSizeConfig();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public String getSelectedIndex() {
        return this.selectedIndex;
    }

    public int getEmbedLevel() {
        return this.embedLevel;
    }

    public int getPageSizeConfig() {
        return this.pageSizeConfig;
    }
}

