/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.SocialCollectionComponent;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.wcm.api.Page;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;

public class PageInfo {
    private final String urlPattern;
    private long totalItems = -1L;
    private final CollectionPagination pagination;
    private final String params;
    private final String basePageURL;
    private final SocialCollectionComponent component;
    private final Resource includedResource;

    public PageInfo(SocialCollectionComponent component, ClientUtilities clientUtils, CollectionPagination pagination) {
        this(component, clientUtils, pagination, null);
    }

    private String getRefererPath(ClientUtilities clientUtils, String path) {
        String refererPath = clientUtils.getRequest().getHeader("referer");
        if (refererPath != null) {
            String refererLanguage = StringUtils.substringAfterLast((String)LanguageUtil.getLanguageRoot(refererPath), (String)"/");
            String commentPostPageLanguage = StringUtils.substringAfterLast((String)LanguageUtil.getLanguageRoot(path), (String)"/");
            if (refererLanguage != null && commentPostPageLanguage != null && !refererLanguage.equals(commentPostPageLanguage)) {
                String leftPath = StringUtils.substringBeforeLast((String)LanguageUtil.getLanguageRoot(path), (String)"/");
                String rightPath = StringUtils.substringAfterLast((String)path, (String)"/");
                if (leftPath != null && rightPath != null) {
                    StringBuilder refererLanguagePath = new StringBuilder();
                    refererLanguagePath.append(leftPath).append("/");
                    refererLanguagePath.append(refererLanguage).append("/");
                    refererLanguagePath.append(rightPath);
                    return refererLanguagePath.toString();
                }
            }
        }
        return path;
    }

    public PageInfo(SocialCollectionComponent component, ClientUtilities clientUtils, CollectionPagination pagination, String params) {
        this.pagination = pagination;
        Page page = clientUtils.getContainingPage(component.getId().toString());
        this.basePageURL = page != null && !StringUtils.isEmpty((CharSequence)pagination.getSelectedIndex()) ? clientUtils.externalLink(this.getRefererPath(clientUtils, page.getPath()) + ".index." + pagination.getSelectedIndex(), false) : (page != null ? clientUtils.externalLink(this.getRefererPath(clientUtils, page.getPath()), false) : null);
        this.urlPattern = clientUtils.externalLink(component.getId() + ".social", false) + "." + "${startIndex}." + Long.valueOf(this.getPageSize()).toString() + "." + clientUtils.getRequestExtension();
        this.params = params;
        this.component = component;
        this.includedResource = clientUtils.getIncludedResource();
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public long getSelectedPage() {
        Double pagesSeen = Math.ceil((long)this.pagination.getOffset() / Math.abs(this.getPageSize()));
        if (this.pagination.getSize() == 0) {
            return pagesSeen.longValue();
        }
        return Double.valueOf(pagesSeen + 1.0).longValue();
    }

    public long getTotalPages() {
        return Double.valueOf(Math.ceil((double)this.getTotalItems() * 1.0 / (double)Math.abs(this.getPageSize()))).longValue();
    }

    public long getPageSize() {
        return this.pagination.getSize() > 0 ? (long)this.pagination.getSize() : (long)this.pagination.getPageSizeConfig();
    }

    public long getCurrentIndex() {
        return this.pagination.getOffset();
    }

    public String getNextPageURL() {
        String nextPage = StringUtils.replace((String)this.getURLPattern(), (String)"${startIndex}", (String)Long.valueOf(this.getNextOffset()).toString());
        if (this.params != null) {
            nextPage = nextPage + "?" + this.params;
        }
        return nextPage;
    }

    public String getPreviousPageURL() {
        String nextPage = StringUtils.replace((String)this.getURLPattern(), (String)"${startIndex}", (String)Long.valueOf(this.getPreviousOffset()).toString());
        if (this.params != null) {
            nextPage = nextPage + "?" + this.params;
        }
        return nextPage;
    }

    public String getNextSuffix() {
        return this.getNextOffset() + "." + this.getPageSize();
    }

    public String getPreviousSuffix() {
        return this.getPreviousOffset() + "." + this.getPageSize();
    }

    public String getSelectedIndex() {
        return this.pagination.getSelectedIndex();
    }

    public String getBasePageURL() {
        return this.basePageURL;
    }

    public String getIncludedPath() {
        if (this.includedResource != null) {
            return this.includedResource.getPath();
        }
        return null;
    }

    private long getTotalItems() {
        if (this.totalItems < 0L) {
            this.totalItems = this.component.getTotalSize();
        }
        return this.totalItems;
    }

    private long getNextOffset() {
        return this.getTotalItems() < (long)(Math.abs(this.pagination.getSize()) + this.pagination.getOffset()) ? this.getTotalItems() : (long)(Math.abs(this.pagination.getSize()) + this.pagination.getOffset());
    }

    private long getPreviousOffset() {
        return 0 >= this.pagination.getOffset() - Math.abs(this.pagination.getSize()) ? 0L : (long)(this.pagination.getOffset() - Math.abs(this.pagination.getSize()));
    }
}

