/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf.core;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.ClientUtilityFactory;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseQueryRequestInfo;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.xss.XSSAPI;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractSocialComponentFactory
implements SocialComponentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSocialComponentFactory.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private XSSAPI xss;
    @Reference
    private SocialUtils socialUtils;
    @Property(name="priority", intValue={0})
    protected int priority;
    @Reference
    ClientUtilityFactory clientUtilFactory;

    protected ClientUtilities getClientUtilities(SlingHttpServletRequest request) {
        return this.clientUtilFactory.getClientUtilities(this.xss, request, this.socialUtils);
    }

    protected ClientUtilities getClientUtilities(ResourceResolver resourceResolver) {
        return this.clientUtilFactory.getClientUtilities(this.xss, resourceResolver, this.socialUtils);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected XSSAPI getXssService() {
        return this.xss;
    }

    protected SocialUtils getSocialUtils() {
        return this.socialUtils;
    }

    protected void activate(ComponentContext context) {
        this.priority = OsgiUtil.toInteger(context.getProperties().get("priority"), 0);
    }

    protected QueryRequestInfo getQueryRequestInfo(SlingHttpServletRequest request) {
        if (request != null) {
            return new BaseQueryRequestInfo(request);
        }
        return BaseQueryRequestInfo.DEFAULT_QUERY_REQUEST;
    }

    protected void bindXss(XSSAPI xSSAPI) {
        this.xss = xSSAPI;
    }

    protected void unbindXss(XSSAPI xSSAPI) {
        if (this.xss == xSSAPI) {
            this.xss = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        this.clientUtilFactory = clientUtilityFactory;
    }

    protected void unbindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        if (this.clientUtilFactory == clientUtilityFactory) {
            this.clientUtilFactory = null;
        }
    }
}

