/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf.core;

import com.adobe.cq.social.badging.api.BadgingService;
import com.adobe.cq.social.badging.api.UserBadge;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.User;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scoring.api.ScoringService;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.core.SocialResourceUtils;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUser
extends BaseSocialComponent
implements User {
    static final String DEFAULT_AVATAR_PATH = "/etc/designs/default/images/social/avatar.png";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUser.class);
    private static final String PN_NUMBER_OF_POSTS = "numberOfPosts";
    private static final String FORUM_PATH = "forum";
    private static final String HTML_EXT = ".html";
    private static final String PROFILE_PATH = "profile";
    private UserProperties userProps;
    private Authorizable user;
    private String name;
    private String avatarPath;
    private String userId;
    private String largeAvatarPath;
    private ScoringService scoring;
    private String profileUrl;
    private BadgingService badging;
    private boolean initialized = false;
    private final UserPropertiesManager upm;

    @Deprecated
    public AbstractUser(Resource resource, ClientUtilities clientUtils, UserPropertiesManager upm, @Nullable ScoringService scoring) {
        this(resource, clientUtils, upm);
        this.scoring = scoring;
    }

    public AbstractUser(Resource resource, ClientUtilities clientUtils, UserPropertiesManager upm, @Nullable ScoringService scoring, @Nullable BadgingService badging) {
        this(resource, clientUtils, upm);
        this.scoring = scoring;
        this.badging = badging;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            this.userProps = this.getUserProperties(this.resource, this.upm);
        }
        catch (RepositoryException e) {
            LOG.warn("Unable to get user properties from resource ", (Throwable)e);
        }
        if (null == this.userProps) {
            LOG.debug("Unable to get user properties from resource {}.  Setting up Anonymous User.", (Object)this.resource.getPath());
            this.setUpDefaults();
        } else {
            UserManager userManager;
            String avatarpath;
            String largeAvatarpath = avatarpath = this.clientUtils.externalLink(DEFAULT_AVATAR_PATH);
            this.name = "Anonymous";
            this.userId = this.userProps.getAuthorizableID();
            if (this.userId != null && this.userId.length() > 0) {
                avatarpath = this.clientUtils.getSocialUtils().getAvatar(this.userProps, avatarpath);
                largeAvatarpath = this.clientUtils.getSocialUtils().getAvatar(this.userProps, largeAvatarpath, SocialUtils.AVATAR_SIZE.FOURTY_EIGHT);
                try {
                    this.name = this.userProps.getDisplayName();
                }
                catch (RepositoryException e) {
                    LOG.error("Unable to get username for {}", (Object)this.userId, (Object)e);
                }
            }
            if ((userManager = this.resource.adaptTo(UserManager.class)) != null) {
                try {
                    this.user = userManager.getAuthorizable(this.userId);
                }
                catch (RepositoryException e) {
                    LOG.warn("Unable to get jackrabbit user from userId {}", (Object)this.userId, (Object)e);
                }
            } else {
                LOG.warn("Unable to adapt resource [{}] to UserManager", (Object)this.resource.getPath());
            }
            this.avatarPath = avatarpath;
            this.largeAvatarPath = largeAvatarpath;
        }
    }

    public AbstractUser(Resource resource, ClientUtilities clientUtils, UserPropertiesManager upm) {
        super(resource, clientUtils);
        this.upm = upm;
        this.init();
    }

    private void setUpDefaults() {
        this.userId = "anonymous";
        this.avatarPath = DEFAULT_AVATAR_PATH;
        this.largeAvatarPath = DEFAULT_AVATAR_PATH;
        this.name = "Unknown";
    }

    @CheckForNull
    private UserProperties getUserProperties(Resource resource, UserPropertiesManager upm) throws RepositoryException {
        String resourcePath = resource.getPath();
        if (StringUtils.contains((CharSequence)resourcePath, (CharSequence)"/social/authors/")) {
            String userId = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
            return this.clientUtils.getUserProperties(userId, PROFILE_PATH);
        }
        return null;
    }

    @Override
    public String getName() {
        this.init();
        return this.name;
    }

    @Override
    public String getAvatarUrl() {
        this.init();
        if (this.clientUtils == null) {
            return this.avatarPath;
        }
        if (StringUtils.startsWith((CharSequence)this.avatarPath, (CharSequence)SocialResourceUtils.GRAVATAR_PREFIX)) {
            return this.avatarPath;
        }
        return this.clientUtils.externalLink(this.avatarPath, false);
    }

    @Override
    public String getLargeAvatarUrl() {
        this.init();
        if (this.clientUtils == null) {
            return this.largeAvatarPath;
        }
        if (StringUtils.startsWith((CharSequence)this.largeAvatarPath, (CharSequence)SocialResourceUtils.GRAVATAR_PREFIX)) {
            return this.largeAvatarPath;
        }
        return this.clientUtils.externalLink(this.largeAvatarPath, false);
    }

    @Override
    public String getAuthorizableId() {
        this.init();
        return this.userId;
    }

    @Override
    public String getPath() {
        this.init();
        String path = null;
        if (this.user != null) {
            try {
                path = this.user.getPath();
            }
            catch (RepositoryException e) {
                LOG.error("Unable to get the user's path.", (Throwable)e);
            }
        }
        return path;
    }

    @Override
    public String getUserId() {
        this.init();
        return this.userId;
    }

    @Override
    public String getProfileUrl() {
        this.init();
        if (this.profileUrl == null) {
            String result = "";
            if (this.clientUtils.getRequest() != null) {
                String socialProfilePage = this.clientUtils.getSocialProfilePath();
                if (this.userProps != null && !StringUtils.isEmpty((CharSequence)socialProfilePage)) {
                    String profilePath;
                    Resource resource = this.clientUtils.getRequest().getResource();
                    if (socialProfilePage.startsWith("/")) {
                        profilePath = socialProfilePage + HTML_EXT;
                    } else {
                        CommunityContext communityContext;
                        String contentPath = this.clientUtils.getSocialUtils().UGCToResourcePath(resource);
                        if (!StringUtils.equals((CharSequence)contentPath, (CharSequence)resource.getPath())) {
                            contentPath = this.clientUtils.getSocialUtils().getPagePath(contentPath);
                            Resource content = resource.getResourceResolver().getResource(contentPath);
                            if (content != null) {
                                resource = content;
                            }
                        }
                        profilePath = (communityContext = resource.adaptTo(CommunityContext.class)) != null && communityContext.getSiteId() != null ? communityContext.getSitePagePath() + "/" + socialProfilePage + HTML_EXT : resource.getPath() + "/" + socialProfilePage + HTML_EXT;
                    }
                    try {
                        String url = profilePath + this.userProps.getNode().getPath();
                        result = this.clientUtils.externalLink(url, false);
                    }
                    catch (RepositoryException e) {
                        LOG.error("Error retrieving profile url for " + this.userProps.getAuthorizableID(), (Throwable)e);
                        result = null;
                    }
                }
                this.profileUrl = result;
            }
        }
        return this.profileUrl;
    }

    @Override
    public String getFriendlyUrl() {
        return this.getProfileUrl();
    }

    @Override
    @Deprecated
    public Long getNumberOfPosts() {
        Resource profileResource;
        this.init();
        if (this.userProps == null) {
            return 0L;
        }
        try {
            profileResource = this.userProps.getResource(FORUM_PATH);
        }
        catch (RepositoryException e) {
            LOG.error("Error retrieving post count for " + this.userProps.getAuthorizableID(), (Throwable)e);
            return 0L;
        }
        if (null != profileResource) {
            ValueMap props = ResourceUtil.getValueMap(profileResource);
            return props.get(PN_NUMBER_OF_POSTS, 0L);
        }
        return 0L;
    }

    @Override
    public List<User.Badge> getBadges() {
        Page badgeMapContainingPage;
        this.init();
        ArrayList<User.Badge> badges = new ArrayList<User.Badge>();
        if (this.badging == null) {
            LOG.debug("No reference to BadgingService");
            return badges;
        }
        SlingHttpServletRequest request = this.clientUtils.getRequest();
        if (request == null) {
            LOG.debug("AbstractUser object has no request object.");
            return badges;
        }
        Resource compResource = this.clientUtils.getRequest().getResource();
        if (compResource == null) {
            LOG.debug("Request has no resource");
            return badges;
        }
        ValueMap compVM = compResource.getValueMap();
        if (compVM == null) {
            LOG.debug("Component has no ValueMap {}", (Object)compResource.getPath());
            return badges;
        }
        if (!compVM.get("allowBadges", false).booleanValue()) {
            String csRoot = (String)((Object)compVM.get("social:rootCommentSystem", String.class));
            if (csRoot == null) {
                return badges;
            }
            if ((compResource = compResource.getResourceResolver().getResource(csRoot)) == null) {
                return badges;
            }
            compVM = compResource.getValueMap();
            if (!compVM.get("allowBadges", false).booleanValue()) {
                return badges;
            }
        }
        if ((badgeMapContainingPage = this.clientUtils.getContainingPage("")) == null) {
            LOG.debug("Component has not containing Page {}", (Object)compResource.getPath());
            return badges;
        }
        Resource pageResource = compVM.get("filterBadgesByComponent", false) != false ? compResource.getResourceResolver().getResource(badgeMapContainingPage.getPath()) : null;
        try {
            List<UserBadge> userBadges = this.badging.getBadges(compResource.getResourceResolver(), this.userId, pageResource, null, "ALL");
            for (final UserBadge badge : userBadges) {
                String title;
                final String badgeImagePath = badge.getImagePath();
                Page badgePage = this.clientUtils.getContainingPage(badgeImagePath);
                if (badgePage != null) {
                    title = badgePage.getTitle();
                } else {
                    LOG.debug("Badge image {} is not in a Page thus no Title.", (Object)badgeImagePath);
                    title = "";
                }
                badges.add(new User.Badge(){

                    @Override
                    public String getTitle() {
                        return title;
                    }

                    @Override
                    public String getImageUrl() {
                        return AbstractUser.this.clientUtils.externalLink(badgeImagePath, false);
                    }

                    @Override
                    public boolean getIsAssigned() {
                        return badge.isAssigned();
                    }
                });
            }
        }
        catch (RepositoryException e) {
            LOG.error("Error looking up user badges", (Throwable)e);
        }
        return badges;
    }

    @Override
    public Boolean getDisabled() {
        this.init();
        if (this.user != null && this.user instanceof org.apache.jackrabbit.api.security.user.User) {
            try {
                return ((org.apache.jackrabbit.api.security.user.User)this.user).isDisabled();
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getDisabledReason() {
        this.init();
        if (this.user != null && this.user instanceof org.apache.jackrabbit.api.security.user.User) {
            try {
                return ((org.apache.jackrabbit.api.security.user.User)this.user).getDisabledReason();
            }
            catch (RepositoryException e) {
                return null;
            }
        }
        return null;
    }

    protected UserProperties getUserProperties() {
        this.init();
        return this.userProps;
    }
}

