/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf.core;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.JsonException;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.DefaultResourceID;
import com.adobe.cq.social.scf.core.ResourceID;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, isGetterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class BaseSocialComponent
implements SocialComponent {
    private static ObjectMapper objectMapper;
    private static Charset UTF8_CHARSET;
    protected final Resource resource;
    protected final ResourceID id;
    protected final Properties properties;
    protected ClientUtilities clientUtils;
    protected final List<String> ignoredProperties = new ArrayList<String>(Arrays.asList("cq:.*", "ip", "email", "userAgent", "sling:.*"));
    protected List<Pattern> ignoredPropertiesPatterns;
    private final List<String> whiteList = Arrays.asList("cq:tags");

    public BaseSocialComponent(Resource resource, ClientUtilities clientUtils) {
        this.resource = resource;
        this.id = new DefaultResourceID(resource);
        this.properties = new LazyProperties();
        this.clientUtils = clientUtils;
    }

    public static String buildJSONString(Map<String, Object> data, boolean tidy) throws JsonException {
        try {
            JsonFactory f = new JsonFactory();
            f.setCharacterEscapes((CharacterEscapes)new EscapeCloseScriptBlocks());
            ByteArrayOutputStream bastream = new ByteArrayOutputStream();
            JsonGenerator jgen = f.createGenerator((OutputStream)bastream, JsonEncoding.UTF8);
            if (tidy) {
                objectMapper.writerWithDefaultPrettyPrinter().writeValue(jgen, data);
            } else {
                objectMapper.writeValue(jgen, data);
            }
            return new String(bastream.toByteArray(), UTF8_CHARSET);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("Error converting map to JSON", e);
        }
        catch (IOException e) {
            throw new JsonException("Error converting map to JSON", e);
        }
    }

    @Override
    public ResourceID getId() {
        return this.id;
    }

    @Override
    public String getResourceType() {
        return this.resource.getResourceType();
    }

    @Override
    public String getUrl() {
        return this.externalizeURL(this.resource.getPath());
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    private void initIgnoredPropertiesList() {
        this.ignoredPropertiesPatterns = new ArrayList<Pattern>(this.getIgnoredProperties().size());
        for (String ignoredKey : this.getIgnoredProperties()) {
            this.ignoredPropertiesPatterns.add(Pattern.compile(ignoredKey));
        }
    }

    protected boolean isKeyIgnored(String key) {
        for (Pattern ignoredKey : this.ignoredPropertiesPatterns) {
            if (!ignoredKey.matcher(key).matches() || this.whiteList.contains(key)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    @Override
    @JsonIgnore
    public String toJSONString(boolean tidy) throws JsonException {
        try {
            JsonFactory f = new JsonFactory();
            f.setCharacterEscapes((CharacterEscapes)new EscapeCloseScriptBlocks());
            ByteArrayOutputStream bastream = new ByteArrayOutputStream();
            JsonGenerator jgen = f.createGenerator((OutputStream)bastream, JsonEncoding.UTF8);
            if (tidy) {
                objectMapper.writerWithDefaultPrettyPrinter().writeValue(jgen, (Object)this);
            } else {
                objectMapper.writeValue(jgen, (Object)this);
            }
            return new String(bastream.toByteArray(), UTF8_CHARSET);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("Error converting " + this.id + " to JSON", e);
        }
        catch (IOException e) {
            throw new JsonException("Error converting " + this.id + " to JSON", e);
        }
    }

    @Override
    @JsonIgnore
    public Resource getResource() {
        return this.resource;
    }

    protected String externalizeURL(String path) {
        if (this.clientUtils == null) {
            return path;
        }
        return this.clientUtils.externalLink(path);
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getAsMap() {
        return (Map)objectMapper.convertValue((Object)this, Map.class);
    }

    @Override
    public SocialComponent getParentComponent() {
        return null;
    }

    @Override
    public SocialComponent getSourceComponent() {
        return this;
    }

    @Override
    public String getFriendlyUrl() {
        Page page;
        SocialUtils socialUtils = this.clientUtils.getSocialUtils();
        if (socialUtils != null && (page = socialUtils.getContainingPage(this.resource)) != null) {
            return this.clientUtils.externalLink(page.getPath(), false) + ".html";
        }
        return null;
    }

    static {
        UTF8_CHARSET = Charset.forName("UTF-8");
        objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true).configure(SerializationFeature.WRAP_EXCEPTIONS, false);
    }

    private static class EscapeCloseScriptBlocks
    extends CharacterEscapes {
        private final int[] escapes;

        public EscapeCloseScriptBlocks() {
            int[] baseEscapes = EscapeCloseScriptBlocks.standardAsciiEscapesForJSON();
            baseEscapes[60] = -1;
            baseEscapes[62] = -1;
            this.escapes = baseEscapes;
        }

        public int[] getEscapeCodesForAscii() {
            return this.escapes;
        }

        public SerializableString getEscapeSequence(int arg0) {
            return null;
        }
    }

    private class LazyProperties
    extends Properties {
        boolean needPropertyValues = true;

        private LazyProperties() {
        }

        private synchronized void initPropertyVaues() {
            if (!this.needPropertyValues) {
                return;
            }
            this.needPropertyValues = false;
            BaseSocialComponent thiz = BaseSocialComponent.this;
            ValueMap propMap = thiz.resource.adaptTo(ValueMap.class);
            if (propMap != null) {
                BaseSocialComponent.this.initIgnoredPropertiesList();
                for (String key : propMap.keySet()) {
                    if (thiz.isKeyIgnored(key)) continue;
                    Object value = propMap.get(key);
                    if (value == null) {
                        this.setProperty(key, "");
                        continue;
                    }
                    if (value.getClass().isArray()) {
                        this.put(key, value);
                        continue;
                    }
                    this.setProperty(key, value.toString());
                }
            }
        }

        @Override
        public synchronized Object setProperty(String key, String value) {
            this.initPropertyVaues();
            return super.setProperty(key, value);
        }

        @Override
        public synchronized void load(Reader reader) throws IOException {
            this.initPropertyVaues();
            super.load(reader);
        }

        @Override
        public synchronized void load(InputStream inStream) throws IOException {
            this.initPropertyVaues();
            super.load(inStream);
        }

        @Override
        public void save(OutputStream out, String comments) {
            this.initPropertyVaues();
            super.save(out, comments);
        }

        @Override
        public void store(Writer writer, String comments) throws IOException {
            this.initPropertyVaues();
            super.store(writer, comments);
        }

        @Override
        public void store(OutputStream out, String comments) throws IOException {
            this.initPropertyVaues();
            super.store(out, comments);
        }

        @Override
        public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
            this.initPropertyVaues();
            super.loadFromXML(in);
        }

        @Override
        public void storeToXML(OutputStream os, String comment) throws IOException {
            this.initPropertyVaues();
            super.storeToXML(os, comment);
        }

        @Override
        public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
            this.initPropertyVaues();
            super.storeToXML(os, comment, encoding);
        }

        @Override
        public String getProperty(String key) {
            this.initPropertyVaues();
            return super.getProperty(key);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            this.initPropertyVaues();
            return super.getProperty(key, defaultValue);
        }

        @Override
        public Enumeration<?> propertyNames() {
            this.initPropertyVaues();
            return super.propertyNames();
        }

        @Override
        public Set<String> stringPropertyNames() {
            this.initPropertyVaues();
            return super.stringPropertyNames();
        }

        @Override
        public void list(PrintStream out) {
            this.initPropertyVaues();
            super.list(out);
        }

        @Override
        public void list(PrintWriter out) {
            this.initPropertyVaues();
            super.list(out);
        }

        @Override
        public synchronized int size() {
            this.initPropertyVaues();
            return super.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            this.initPropertyVaues();
            return super.isEmpty();
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            this.initPropertyVaues();
            return super.keys();
        }

        @Override
        public synchronized Enumeration<Object> elements() {
            this.initPropertyVaues();
            return super.elements();
        }

        @Override
        public synchronized boolean contains(Object value) {
            this.initPropertyVaues();
            return super.contains(value);
        }

        @Override
        public boolean containsValue(Object value) {
            this.initPropertyVaues();
            return super.containsValue(value);
        }

        @Override
        public synchronized boolean containsKey(Object key) {
            this.initPropertyVaues();
            return super.containsKey(key);
        }

        @Override
        public synchronized Object get(Object key) {
            this.initPropertyVaues();
            return super.get(key);
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            this.initPropertyVaues();
            return super.put(key, value);
        }

        @Override
        public synchronized Object remove(Object key) {
            this.initPropertyVaues();
            return super.remove(key);
        }

        @Override
        public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
            this.initPropertyVaues();
            super.putAll(t);
        }

        @Override
        public synchronized void clear() {
            this.initPropertyVaues();
            super.clear();
        }

        @Override
        public synchronized Object clone() {
            this.initPropertyVaues();
            return super.clone();
        }

        @Override
        public synchronized String toString() {
            this.initPropertyVaues();
            return super.toString();
        }

        @Override
        public Set<Object> keySet() {
            this.initPropertyVaues();
            return super.keySet();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            this.initPropertyVaues();
            return super.entrySet();
        }

        @Override
        public Collection<Object> values() {
            this.initPropertyVaues();
            return super.values();
        }

        @Override
        public synchronized boolean equals(Object o) {
            this.initPropertyVaues();
            return super.equals(o);
        }

        @Override
        public synchronized int hashCode() {
            this.initPropertyVaues();
            return super.hashCode();
        }
    }
}

