/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf.core.operations;

import com.adobe.cq.social.commons.annotation.Endpoint;
import com.adobe.cq.social.commons.annotation.Parameters;
import com.adobe.cq.social.scf.JsonException;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialOperationInfo;
import com.adobe.cq.social.scf.SocialOperationResult;
import com.adobe.cq.social.ugcbase.core.SocialResourceUtils;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingRequestPaths;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.servlets.post.JSONResponse;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractSocialOperation
implements PostOperation,
SocialOperationInfo {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSocialOperation.class);

    @Override
    public final void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        try {
            Resource resource = request.getResource();
            if (ResourceUtil.isNonExistingResource(resource)) {
                RequestPathInfo pathInfo = request.getRequestPathInfo();
                String newPath = StringUtils.removeEnd((String)resource.getPath(), (String)("." + pathInfo.getExtension()));
                newPath = StringUtils.removeEnd((String)newPath, (String)pathInfo.getSelectorString());
                String[] selectors = pathInfo.getSelectors();
                for (int i = 0; i < selectors.length; ++i) {
                    if (StringUtils.equals((CharSequence)selectors[i], (CharSequence)"social")) continue;
                    newPath = newPath + "." + selectors[i];
                }
                newPath = StringUtils.removeEnd((String)newPath, (String)".");
                resource = request.getResourceResolver().resolve(newPath);
            }
            SocialOperationResult result = StringUtils.equals((CharSequence)request.getResource().getPath(), (CharSequence)resource.getPath()) ? this.performOperation(request) : this.performOperation(new NonExistingResourceWrappingRequest(request, resource));
            this.sendResponse(result, request, response);
        }
        catch (OperationException e) {
            this.sendResponse(e, request, response);
        }
        catch (Throwable t) {
            LOG.error("Error performing operation: ", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            this.sendResponse(new OperationException(t.getMessage(), 500), request, response);
        }
    }

    @Override
    public final Endpoint getEndpoint() {
        Endpoint endpoint = null;
        Class<?> klass = this.getClass();
        if (klass.isAnnotationPresent(Endpoint.class)) {
            Class<?> element = klass;
            endpoint = element.getAnnotation(Endpoint.class);
        }
        return endpoint;
    }

    @Override
    public final Parameters getRequestParameters() {
        Parameters parameters = null;
        Class<?> klass = this.getClass();
        if (klass.isAnnotationPresent(Parameters.class)) {
            Class<?> element = klass;
            parameters = element.getAnnotation(Parameters.class);
        }
        return parameters;
    }

    protected void sendResponse(OperationException e, SlingHttpServletRequest request, PostResponse response) {
        if (e.getErrorCode() > 499) {
            LOG.error("Error performing operation", (Throwable)e);
        } else {
            LOG.info("Operation exception encountered", (Throwable)e);
        }
        response.setError(e);
        response.setPath(request.getResource().getPath());
        response.setCreateRequest(false);
        response.setStatus(e.getErrorCode(), e.getMessage());
    }

    protected void sendResponse(SocialOperationResult result, SlingHttpServletRequest request, PostResponse response) {
        response.setStatus(result.getHttpStatusCode(), result.getHttpStatusMessage());
        response.setLocation(this.externalizePath(request, result.getPath()));
        response.setPath(request.getResource().getPath());
        if (response instanceof JSONResponse && result.getResource() != null) {
            try {
                ((JSONResponse)response).setProperty("response", new JSONObject(result.getResource().toJSONString(false)));
            }
            catch (JsonException e) {
                LOG.error("Error trying to write JSON response for " + result.getResource().getId(), (Throwable)e);
                response.setStatus(500, e.getMessage());
            }
            catch (JSONException e) {
                LOG.error("Error trying to write JSON response for " + result.getResource().getId(), (Throwable)e);
                response.setStatus(500, e.getMessage());
            }
        }
    }

    protected final String externalizePath(SlingHttpServletRequest request, String path) {
        StringBuffer ret = new StringBuffer();
        ret.append(SlingRequestPaths.getContextPath(request));
        if (!SocialResourceUtils.isCloudUGC(path)) {
            ret.append(request.getResourceResolver().map(path));
        } else {
            ret.append(path);
        }
        String ext = request.getParameter(":displayExtension");
        if (ext != null && ext.length() > 0) {
            if (ext.charAt(0) != '.') {
                ret.append('.');
            }
            ret.append(ext);
        }
        return ret.toString();
    }

    protected String getReferrer(SlingHttpServletRequest request) {
        if (request != null) {
            String value = request.getHeader("referer");
            if (StringUtils.isEmpty((CharSequence)value)) {
                value = request.getParameter("referer");
            }
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                try {
                    URL url = new URL(value);
                    return url.getFile();
                }
                catch (MalformedURLException e) {
                    LOG.error("Failed to get referrer property.", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected abstract SocialOperationResult performOperation(SlingHttpServletRequest var1) throws OperationException;

    class NonExistingResourceWrappingRequest
    extends SlingHttpServletRequestWrapper {
        private final Resource newResource;

        public NonExistingResourceWrappingRequest(SlingHttpServletRequest wrappedRequest, Resource resource) {
            super(wrappedRequest);
            this.newResource = resource;
        }

        @Override
        public Resource getResource() {
            return this.newResource;
        }
    }
}

