/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf.core.resourcetree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ResourceTypeTree<T> {
    private ResourceResolver adminResolver;
    private final Map<String, T> hash;
    private final List<RTree<T>> resourceTypeTrees;

    public ResourceTypeTree(ResourceResolver adminResolver) {
        this.adminResolver = adminResolver;
        this.hash = new HashMap<String, T>(10);
        this.resourceTypeTrees = new ArrayList<RTree<T>>(10);
    }

    public synchronized void setAdminResolver(ResourceResolver adminResolver) {
        this.adminResolver = adminResolver;
    }

    public boolean contains(String resourceType) {
        return this.hash.containsKey(resourceType);
    }

    public synchronized void put(String resourceType, T value) {
        this.hash.put(resourceType, value);
        boolean added = false;
        boolean recheckGrove = false;
        RTree<T> treeAddedTo = null;
        for (RTree<T> tree : this.resourceTypeTrees) {
            try {
                recheckGrove = tree.put(resourceType, value);
                treeAddedTo = tree;
                added = true;
                break;
            }
            catch (IncompatibleResourceTypeException e) {
            }
        }
        if (!added) {
            RTree<T> newTree = new RTree<T>(resourceType, value);
            this.resourceTypeTrees.add(newTree);
        }
        if (recheckGrove) {
            Iterator<RTree<T>> iterator = this.resourceTypeTrees.iterator();
            while (iterator.hasNext()) {
                Resource treeRoot;
                RTree<T> tree;
                tree = iterator.next();
                if (tree == treeAddedTo || !this.adminResolver.isResourceType(treeRoot = this.adminResolver.getResource(tree.getRoot().getResourceType()), treeAddedTo.getRoot().getResourceType())) continue;
                treeAddedTo.getRoot().addChild(tree.getRoot());
                tree.getRoot().setParent(treeAddedTo.getRoot());
                iterator.remove();
            }
        }
    }

    public synchronized void remove(String resourceType) {
        if (this.hash.containsKey(resourceType)) {
            Iterator<RTree<T>> iterator = this.resourceTypeTrees.iterator();
            ArrayList<RTree<T>> newTrees = new ArrayList<RTree<T>>();
            while (iterator.hasNext()) {
                RTree<T> tree = iterator.next();
                newTrees.addAll(tree.remove(resourceType));
                if (!tree.isEmpty()) continue;
                iterator.remove();
            }
            this.resourceTypeTrees.addAll(newTrees);
        }
        this.hash.remove(resourceType);
    }

    public T getClosest(String resourceType) {
        RTree<T> tree;
        if (this.hash.containsKey(resourceType)) {
            return this.hash.get(resourceType);
        }
        Map.Entry<String, T> closestParent = null;
        Resource resourceToFind = this.getResourceToFind(resourceType);
        if (resourceToFind == null) {
            return null;
        }
        Iterator<RTree<T>> i$ = this.resourceTypeTrees.iterator();
        while (i$.hasNext() && (closestParent = (tree = i$.next()).findClosestParent(resourceToFind)) == null) {
        }
        return closestParent == null ? null : (T)closestParent.getValue();
    }

    private Resource getResourceToFind(String resourceType) {
        String libsPath;
        Resource libsResource;
        Resource resource = this.adminResolver.getResource(resourceType);
        if (resource == null) {
            return resource;
        }
        if (resource.getResourceSuperType() == null && StringUtils.startsWith((CharSequence)resource.getPath(), (CharSequence)"/apps/") && (libsResource = this.adminResolver.getResource(libsPath = "/libs/" + StringUtils.removeStart((String)resource.getPath(), (String)"/apps/"))) != null) {
            return libsResource;
        }
        return resource;
    }

    public T get(String resourceType) {
        return this.hash.get(resourceType);
    }

    public List<Map.Entry<String, T>> getChildren(String resourceType) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Collection<Map.Entry<String, T>> getParents(String resourceType) {
        Object closestParent = null;
        Resource resourceToFind = this.getResourceToFind(resourceType);
        if (resourceToFind == null) {
            return null;
        }
        for (RTree<T> tree : this.resourceTypeTrees) {
            Collection<Map.Entry<String, T>> parents = tree.getParents(resourceToFind);
            if (parents == null) continue;
            return parents;
        }
        return null;
    }

    public void clear() {
        this.hash.clear();
        this.resourceTypeTrees.clear();
    }

    private class RTree<T> {
        private Node<T> root;
        private boolean rootIsRemoved;
        private boolean rootChanged;

        public RTree(String resourceType, T value) {
            this.root = new Node<T>(resourceType, value, null);
        }

        public RTree(Node<T> root) {
            this.root = root;
        }

        public String toString() {
            return this.root == null ? null : this.root.toString();
        }

        public Node<T> getRoot() {
            return this.root;
        }

        public boolean put(String resourceType, T value) throws IncompatibleResourceTypeException {
            if (this.root == null) {
                this.root = new Node<T>(resourceType, value, null);
                this.rootIsRemoved = false;
                return true;
            }
            this.insert(resourceType, value, this.root);
            if (this.rootChanged) {
                this.rootChanged = false;
                return true;
            }
            return false;
        }

        private void insert(String resourceType, T value, Node<T> node) throws IncompatibleResourceTypeException {
            Resource nodeResource = ResourceTypeTree.this.adminResolver.getResource(node.getResourceType());
            if (ResourceTypeTree.this.adminResolver.isResourceType(nodeResource, resourceType)) {
                Node<T> newNode = new Node<T>(resourceType, value, node.getParent());
                Node<T> oldParent = node.getParent();
                node.setParent(newNode);
                newNode.addChild(node);
                if (node == this.root) {
                    this.root = newNode;
                    this.rootChanged = true;
                }
                if (oldParent != null) {
                    oldParent.removeChild(node);
                    ArrayList<Node<T>> siblings = new ArrayList<Node<T>>(oldParent.getChildren());
                    for (Node node2 : siblings) {
                        Resource siblingResource = ResourceTypeTree.this.adminResolver.getResource(node2.getResourceType());
                        if (!ResourceTypeTree.this.adminResolver.isResourceType(siblingResource, resourceType)) continue;
                        node2.setParent(newNode);
                        newNode.addChild(node2);
                        oldParent.removeChild(node2);
                    }
                    oldParent.addChild(newNode);
                }
            } else {
                Resource resourceToAdd = ResourceTypeTree.this.adminResolver.getResource(resourceType);
                if (!ResourceTypeTree.this.adminResolver.isResourceType(resourceToAdd, node.getResourceType())) {
                    throw new IncompatibleResourceTypeException(resourceToAdd + " is not a " + node.getResourceType());
                }
                boolean isGrandchild = false;
                for (Node<T> child : node.getChildren()) {
                    try {
                        this.insert(resourceType, value, child);
                        isGrandchild = true;
                        break;
                    }
                    catch (IncompatibleResourceTypeException incompatibleResourceTypeException) {
                    }
                }
                if (!isGrandchild) {
                    Node<T> child = new Node<T>(resourceType, value, node);
                    node.addChild(child);
                }
            }
        }

        public boolean isEmpty() {
            return this.root == null;
        }

        public List<RTree<T>> remove(String resourceType) {
            this.delete(resourceType, this.root);
            if (this.rootIsRemoved) {
                ArrayList<RTree<T>> newTrees = new ArrayList<RTree<T>>(this.root.getChildren().size());
                for (Node newSubRoot : this.root.getChildren()) {
                    newSubRoot.setParent(null);
                    newTrees.add(new RTree<T>(newSubRoot));
                }
                this.root = null;
                return newTrees;
            }
            return Collections.emptyList();
        }

        private boolean delete(String resourceType, Node<T> node) {
            Resource resource = ResourceTypeTree.this.adminResolver.getResource(resourceType);
            if (StringUtils.equals((CharSequence)resourceType, (CharSequence)node.getResourceType())) {
                Node<T> parent = node.getParent();
                if (parent == null) {
                    this.rootIsRemoved = true;
                } else {
                    for (Node<T> child : node.getChildren()) {
                        child.setParent(parent);
                        parent.addChild(child);
                    }
                    parent.removeChild(node);
                }
                return true;
            }
            if (!ResourceTypeTree.this.adminResolver.isResourceType(resource, node.getResourceType())) {
                return false;
            }
            boolean wasChild = false;
            for (Node<T> child : node.getChildren()) {
                wasChild = this.delete(resourceType, child);
                if (!wasChild) continue;
                return true;
            }
            return false;
        }

        public Map.Entry<String, T> findClosestParent(Resource resourceToFind) {
            if (!ResourceTypeTree.this.adminResolver.isResourceType(resourceToFind, this.root.getResourceType())) {
                return null;
            }
            final Node<T> closest = this.findClosestParentNode(this.root, resourceToFind);
            Map.Entry closestEntry = new Map.Entry<String, T>(){

                @Override
                public String getKey() {
                    return closest.getResourceType();
                }

                @Override
                public T getValue() {
                    return closest.getValue();
                }

                @Override
                public T setValue(T arg0) {
                    return null;
                }
            };
            return closestEntry;
        }

        public Collection<Map.Entry<String, T>> getParents(Resource resource) {
            if (!ResourceTypeTree.this.adminResolver.isResourceType(resource, this.root.getResourceType())) {
                return null;
            }
            Collection<Map.Entry<String, T>> parents = new ArrayList<Map.Entry<String, T>>();
            parents = this.getParents(resource, this.root, parents);
            return parents;
        }

        protected Collection<Map.Entry<String, T>> getParents(Resource resource, Node<T> root, Collection<Map.Entry<String, T>> parents) {
            RTreeEntry rootEntry = new RTreeEntry(root);
            parents.add(rootEntry);
            Node<T> parent = root;
            for (Node<T> child : parent.getChildren()) {
                if (child.getResourceType().equals(resource.getResourceType())) break;
                if (!ResourceTypeTree.this.adminResolver.isResourceType(resource, child.getResourceType())) continue;
                this.getParents(resource, child, parents);
            }
            return parents;
        }

        private Node<T> findClosestParentNode(Node<T> node, Resource resource) {
            Node<T> closest = node;
            boolean bottomedOut = false;
            block0: while (closest.hasChildren() && !bottomedOut) {
                bottomedOut = true;
                for (Node<T> child : closest.getChildren()) {
                    if (!ResourceTypeTree.this.adminResolver.isResourceType(resource, child.getResourceType())) continue;
                    bottomedOut = false;
                    closest = child;
                    continue block0;
                }
            }
            return closest;
        }

        private class Node<T> {
            private final String resourceType;
            private final T value;
            private Node<T> parent;
            private List<Node<T>> children;

            public Node(String resourceType, T value, Node<T> parent) {
                this.resourceType = resourceType;
                this.value = value;
                this.parent = parent;
                this.children = new ArrayList<Node<T>>(5);
            }

            public String toString() {
                return this.resourceType;
            }

            public boolean hasChildren() {
                return this.children.size() != 0;
            }

            public void removeChild(Node<T> node) {
                this.children.remove(node);
            }

            public void setParent(Node<T> parent) {
                this.parent = parent;
            }

            public String getResourceType() {
                return this.resourceType;
            }

            public List<Node<T>> getChildren() {
                return this.children;
            }

            public Node<T> getParent() {
                return this.parent;
            }

            public T getValue() {
                return this.value;
            }

            public void setChildren(List<Node<T>> children) {
                this.children = children;
            }

            public void addChild(Node<T> child) {
                this.children.add(child);
            }
        }

        private class RTreeEntry
        implements Map.Entry<String, T> {
            final Node<T> node;

            public RTreeEntry(Node<T> node) {
                this.node = node;
            }

            @Override
            public String getKey() {
                return this.node.getResourceType();
            }

            @Override
            public T getValue() {
                return this.node.getValue();
            }

            @Override
            public T setValue(T value) {
                return null;
            }
        }
    }

    private static class IncompatibleResourceTypeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IncompatibleResourceTypeException(String message) {
            super(message);
        }
    }
}

