/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.endpoints;

import com.adobe.cq.social.blueprint.api.SiteActivationService;
import com.adobe.cq.social.blueprint.api.SiteBlueprintUtil;
import com.adobe.cq.social.blueprint.api.TemplateRolloutService;
import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.console.utils.FunctionDefinitionUtils;
import com.adobe.cq.social.console.utils.PropertiesUtils;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.site.api.CommunitySite;
import com.adobe.cq.social.site.api.CommunitySiteService;
import com.adobe.cq.social.site.api.SiteConfiguration;
import com.adobe.cq.social.site.api.SiteConfigurator;
import com.adobe.cq.social.site.endpoints.SiteOperationExtension;
import com.adobe.cq.social.site.endpoints.SiteOperations;
import com.adobe.cq.social.templates.api.FunctionDefinition;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.ReplicationException;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.activation.DataSource;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.tenant.Tenant;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
@Properties(value={@org.apache.felix.scr.annotations.Property(name="fieldWhitelist", cardinality=100)})
public abstract class AbstractSiteOperationService<T extends SiteOperationExtension, U extends Operation>
extends AbstractOperationService<T, U, CommunitySite>
implements SiteOperations {
    private static final String MSM_SERVICE = "msm-service";
    private static final String USER_ADMIN = "communities-user-admin";
    private static final String ACL_MANAGER = "communities-acl-manager";
    private static final String NODE_JCR_CONTENT = "jcr:content";
    private static final String PROPERTY_CQ_IS_COMMUNITY_SITE = "cq:isCommunitySite";
    private static final String CONTENT_SITES = "/content/sites";
    private static final String SITES_ROOT_TITLE = "Community Sites";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSiteOperationService.class);
    private static final int PARAM_NAME_INDEX = 0;
    private static final int PARAM_CLASS_INDEX = 1;
    private static final int PARAM_REQUIRED_INDEX = 2;
    private static final Object[][] requestParams = new Object[][]{{"name", String.class, Boolean.FALSE}, {"jcr:description", String.class, Boolean.FALSE}, {"urlName", String.class, Boolean.TRUE}, {"siteRoot", String.class, Boolean.FALSE}, {"blueprint", String.class, Boolean.TRUE}, {"theme", String.class, Boolean.FALSE}, {"tagNameSpaces", String[].class, Boolean.FALSE}, {"moderateContent", Boolean.class, Boolean.FALSE}, {"groupAdmin", String[].class, Boolean.FALSE}, {"moderators", String[].class, Boolean.FALSE}, {"flagModerator", Integer.class, Boolean.FALSE}, {"createGroupPermission", String.class, Boolean.FALSE}, {"allowFacebook", Boolean.class, Boolean.FALSE}, {"allowTwitter", Boolean.class, Boolean.FALSE}, {"allowAnonymousAccess", Boolean.class, Boolean.FALSE}, {"allowUserRegistration", Boolean.class, Boolean.FALSE}, {"allowPrivateMessaging", Boolean.class, Boolean.FALSE}, {"baseLanguage", String.class, Boolean.FALSE}, {"allowMachineTranslation", Boolean.class, Boolean.FALSE}, {"availableLanguages", String[].class, Boolean.FALSE}, {"persistTranslation", String.class, Boolean.FALSE}, {"fbconnectoauthid", String.class, Boolean.FALSE}, {"twitterconnectoauthid", String.class, Boolean.FALSE}, {"allowCaptcha", Boolean.class, Boolean.FALSE}, {"functions", String.class, Boolean.FALSE}, {"translatePageOrSection", String.class, Boolean.FALSE}, {"enableAnalytics", Boolean.class, Boolean.FALSE}, {"analyticsCloudConfigPath", String.class, Boolean.FALSE}};
    private static final String[] specialParams = new String[]{"availableLanguages", "tagNameSpaces", "functions"};
    private static final int ATTACHMENT_FILE_LIMIT = Integer.MAX_VALUE;
    private static final List<String> WHITE_LIST = new ArrayList<String>();
    private static final String[] BLACK_LIST = new String[0];
    private static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;
    @Reference
    private SocialUtils socialUtils;
    @Reference
    private FunctionDefinitionUtils funcDefUtils;
    @Reference
    private TemplateRolloutService siteBlueprintService;
    @Reference
    CommunitySiteService siteService;
    @Reference
    private SiteActivationService groupService;
    @Reference
    private SiteConfigurator siteConfigurator;
    private ComponentContext context;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    public static final String CHARSET_PROPERTY = "_charset_";
    private static final int NUMBER_OF_RANDOM_CHAR = 5;
    protected String[] fieldWhitelist;
    public static final String PROPERTY_FIELD_WHITELIST = "fieldWhitelist";

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context;
        this.fieldWhitelist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_FIELD_WHITELIST));
    }

    private void cleanupFailure(Session session) {
        try {
            session.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.info("Failed to refresh the session", (Throwable)e);
        }
    }

    protected Resource create(Resource root, String name, Map<String, Object> requestParameters, List<DataSource> attachments, List<DataSource> cssFiles, List<DataSource> siteThumbnail, Session session, ResourceResolver msmResolver, ResourceResolver userManagerResolver, ResourceResolver aclResolver) throws OperationException {
        try {
            U createOperation = this.getCreateOperation();
            this.performBeforeActions(createOperation, session, root, requestParameters);
            Resource siteRoot = this.createSite(root, name, attachments, cssFiles, siteThumbnail, requestParameters, msmResolver, userManagerResolver, aclResolver);
            SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(siteRoot);
            CommunitySite site = (CommunitySite)(factory != null ? factory.getSocialComponent(siteRoot) : null);
            this.siteConfigurator.setSiteLevelConfiguration(site, msmResolver, aclResolver, userManagerResolver);
            this.performAfterActions(createOperation, session, site, requestParameters);
            return siteRoot;
        }
        catch (OperationException e) {
            this.cleanupFailure(session);
            throw e;
        }
        catch (Exception e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to create community site.", e, 500);
        }
    }

    protected Resource update(Resource siteResource, String name, Map<String, Object> requestParameters, List<DataSource> attachments, List<DataSource> siteThumbnail, List<DataSource> siteCSS, Session session, ResourceResolver msmResolver, ResourceResolver userManagerResolver, ResourceResolver aclResolver) throws OperationException {
        if (ResourceUtil.isNonExistingResource(siteResource)) {
            throw new OperationException("Invalid site resource '" + siteResource.getPath() + "'", 400);
        }
        Resource configResource = "configuration".equals(siteResource.getName()) ? siteResource : siteResource.getChild("configuration");
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(configResource);
        CommunitySite currentValue = (CommunitySite)(factory != null ? factory.getSocialComponent(configResource) : null);
        if (currentValue == null) {
            throw new OperationException("Failed to resolve updated community site " + name, 400);
        }
        try {
            U updateOperation = this.getUpdateOperation();
            this.performBeforeActions(updateOperation, session, configResource, requestParameters);
            Resource siteRoot = this.updateSite(configResource, name, attachments, siteThumbnail, siteCSS, requestParameters, currentValue, msmResolver, userManagerResolver, aclResolver);
            CommunitySite updatedSite = (CommunitySite)(factory != null ? factory.getSocialComponent(siteRoot) : null);
            this.siteConfigurator.setSiteLevelConfiguration(updatedSite, msmResolver, aclResolver, userManagerResolver);
            this.performAfterActions(updateOperation, session, updatedSite, requestParameters);
            return siteRoot;
        }
        catch (OperationException e) {
            this.cleanupFailure(session);
            throw e;
        }
        catch (Exception e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to update community site.", e, 500);
        }
    }

    @Override
    public SocialComponent getSocialComponentForCommunitySite(Resource site, SlingHttpServletRequest request) {
        Resource resource = request.getResourceResolver().getResource(site.getPath());
        Resource siteComponent = !site.getPath().endsWith("configuration") ? resource.getChild("configuration") : resource;
        SocialComponentFactory factory = this.componentFactoryManager.getSocialComponentFactory(siteComponent);
        return factory != null ? factory.getSocialComponent(siteComponent, request) : null;
    }

    protected Resource createSite(Resource tenantRoot, String name, List<DataSource> attachments, List<DataSource> cssFiles, List<DataSource> siteThumbnail, Map<String, Object> properties, ResourceResolver msmResolver, ResourceResolver userManagerResolver, ResourceResolver aclResolver) throws OperationException {
        ResourceResolver resolver = tenantRoot.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        if (StringUtils.equals((CharSequence)name, (CharSequence)"resources")) {
            throw new OperationException("Illegal name, 'resources' is a reserved name and cannot be used for the name of site.", 400);
        }
        this.getGroupPermissionType(properties);
        Node sitesRoot = this.getOrCreateSitesRootPage(tenantRoot.getPath(), resolver);
        try {
            String[] languages;
            Node siteContentParentNode;
            String sitePath;
            Session msmSession = msmResolver.adaptTo(Session.class);
            Session userManagerSession = userManagerResolver.adaptTo(Session.class);
            Session aclSession = aclResolver.adaptTo(Session.class);
            String baseLanguage = (String)properties.get("baseLanguage");
            if (sitesRoot.hasNode(name) && sitesRoot.getNode(name).hasNode(baseLanguage)) {
                throw new OperationException("Site with your selected language already exists", 409);
            }
            String siteId = this.generateUniqueSiteId(resolver, name, tenantRoot.getPath());
            String bluePrint = (String)properties.get("blueprint");
            String title = (String)properties.get("name");
            if (StringUtils.isBlank((CharSequence)title)) {
                title = (String)properties.get("urlName");
            }
            boolean isLanguageInRoot = false;
            if (LanguageUtil.getLanguageRoot(tenantRoot.getPath()) != null) {
                isLanguageInRoot = true;
                sitePath = this.siteBlueprintService.rolloutBlueprint(msmSession, bluePrint, name, title, sitesRoot.getPath());
            } else {
                baseLanguage = (String)properties.get("baseLanguage");
                if (StringUtils.isEmpty((CharSequence)baseLanguage)) {
                    baseLanguage = "en";
                }
                sitePath = this.siteBlueprintService.rolloutBlueprint(msmSession, bluePrint, name, title, sitesRoot.getPath(), baseLanguage);
            }
            Node site = resolver.getResource(sitePath).adaptTo(Node.class);
            Node configNode = site.addNode("configuration", "sling:Folder");
            U operation = this.getCreateOperation();
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                String key = property.getKey();
                if (!this.isConfigurationParameter(operation, key)) continue;
                JcrUtil.setProperty(configNode, key, property.getValue());
            }
            Node siteContentNode = isLanguageInRoot ? site.getNode(NODE_JCR_CONTENT) : site.getParent().getNode(NODE_JCR_CONTENT);
            JcrUtil.setProperty(siteContentNode, PROPERTY_CQ_IS_COMMUNITY_SITE, true);
            JcrUtil.setProperty(configNode, SLING_RESOURCE_TYPE, "social/console/components/hbs/sitecollection/site");
            JcrUtil.setProperty(configNode, "siteId", siteId);
            if (siteContentNode != null && (siteContentParentNode = siteContentNode.getParent()) != null && !siteContentParentNode.hasNode("folderConfiguration")) {
                siteContentParentNode.addNode("folderConfiguration", "sling:Folder");
                Node siteContentParentconfigNode = siteContentParentNode.getNode("folderConfiguration");
                JcrUtil.setProperty(siteContentParentconfigNode, SLING_RESOURCE_TYPE, "social/console/components/hbs/sitecollection/sitefolder");
            }
            Resource siteRes = resolver.getResource(site.getPath());
            Object anonymousAccess = properties.get("allowAnonymousAccess");
            Object groupAdmins = properties.get("groupAdmin");
            Object groupCreatePermissionType = properties.get("createGroupPermission");
            Object moderators = properties.get("moderators");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("allowAnonymousAccess", anonymousAccess);
            map.put("groupAdmin", groupAdmins);
            map.put("createGroupPermission", groupCreatePermissionType);
            map.put("moderators", moderators);
            CommunityContext context = siteRes.adaptTo(CommunityContext.class);
            this.siteService.createSiteUserGroups(siteRes, context, msmSession, map, userManagerSession, aclSession);
            this.siteService.applyACLs(bluePrint, siteRes, context, msmSession, userManagerSession, aclSession);
            Node photoFolder = site.addNode("photos", "sling:Folder");
            String themeId = (String)PropertiesUtils.get(properties, (String)"theme", (Object)"/etc/designs/community/sitethemes/bootstrap-default/clientlibs");
            Node image = null;
            for (DataSource ds : attachments) {
                image = AbstractSiteOperationService.addThemeAsset(resolver, context, themeId, ds.getName(), resolver.adaptTo(Session.class).getValueFactory().createBinary(ds.getInputStream()), ds.getContentType());
                String contentMimeType = ds.getContentType();
                if (image == null) continue;
                JcrUtil.copy(image, photoFolder, "image");
            }
            Node siteCSSNode = this.createCSSAsset(cssFiles, session, context);
            if (siteCSSNode != null) {
                JcrUtil.setProperty(configNode, "theme", siteCSSNode.getPath());
            }
            this.createThumbnailAsset(siteThumbnail, siteRes, resolver, context);
            String[] tags = (String[])properties.get("tagNameSpaces");
            if (tags != null) {
                tags = this.trimTags(tags);
                JcrUtil.setProperty(configNode, "tagNameSpaces", tags);
            }
            if ((languages = (String[])properties.get("availableLanguages")) != null) {
                JcrUtil.setProperty(configNode, "availableLanguages", languages);
            }
            session.save();
            msmResolver.commit();
            return resolver.getResource(configNode.getPath());
        }
        catch (OperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error creating Community site.", (Throwable)e);
            throw new OperationException(e.getMessage(), e, 500);
        }
    }

    protected Resource updateSite(Resource site, String name, List<DataSource> attachments, List<DataSource> siteThumbnail, List<DataSource> siteCSS, Map<String, Object> properties, CommunitySite currentValue, ResourceResolver msmResolver, ResourceResolver userManagerResolver, ResourceResolver aclResolver) throws OperationException {
        ResourceResolver resolver = site.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        try {
            String[] availableLanguages;
            Node themeNode;
            String themeId;
            String structureString;
            Session msmSession = msmResolver.adaptTo(Session.class);
            Session userManagerSession = userManagerResolver.adaptTo(Session.class);
            Session aclSession = aclResolver.adaptTo(Session.class);
            CommunityContext context = site.adaptTo(CommunityContext.class);
            Node configNode = session.getNode(site.getPath());
            String siteName = (String)properties.get("name");
            Boolean allowFB = (Boolean)properties.get("allowFacebook");
            Boolean allowTwitter = (Boolean)properties.get("allowTwitter");
            if ((allowFB == null || !allowFB.booleanValue()) && configNode.hasProperty("fbconnectoauthid")) {
                configNode.getProperty("fbconnectoauthid").remove();
            }
            if ((allowTwitter == null || !allowTwitter.booleanValue()) && configNode.hasProperty("twitterconnectoauthid")) {
                configNode.getProperty("twitterconnectoauthid").remove();
            }
            if (StringUtils.isBlank((CharSequence)siteName)) {
                siteName = (String)properties.get("urlName");
            }
            if (!StringUtils.isEmpty((CharSequence)(structureString = (String)properties.get("functions")))) {
                try {
                    this.updateSiteStructure(configNode, site.getParent(), structureString, site.getResourceResolver());
                    ModifiableValueMap pageProps = site.getParent().getChild(NODE_JCR_CONTENT).adaptTo(ModifiableValueMap.class);
                    pageProps.put("jcr:title", siteName);
                    pageProps.put("pageTitle", siteName);
                }
                catch (JSONException e) {
                    throw new OperationException("Malformed site structure", e, 400);
                }
            }
            U operation = this.getUpdateOperation();
            Resource parent = site.getParent();
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                String key = property.getKey();
                if (!this.isConfigurationParameter(operation, key) || !this.isUpdatedParameter(key, property.getValue(), configNode)) continue;
                if (!ArrayUtils.contains((Object[])this.fieldWhitelist, (Object)key)) {
                    JcrUtil.setProperty(configNode, key, property.getValue());
                    continue;
                }
                if (configNode.hasProperty(key)) {
                    if (!configNode.getProperty(key).getClass().equals(property.getValue().getClass())) {
                        configNode.getProperty(key).remove();
                        JcrUtil.setProperty(configNode, key, property.getValue());
                        continue;
                    }
                    JcrUtil.setProperty(configNode, key, property.getValue());
                    continue;
                }
                JcrUtil.setProperty(configNode, key, property.getValue());
            }
            Object anonymousAccess = properties.get("allowAnonymousAccess");
            String[] groupAdmins = properties.get("groupAdmin");
            String groupCreatePermissionType = this.getGroupPermissionType(properties);
            String[] moderators = properties.get("moderators");
            if (moderators == null && configNode.hasProperty("moderators")) {
                configNode.getProperty("moderators").remove();
            }
            if (groupAdmins == null && configNode.hasProperty("groupAdmin")) {
                configNode.getProperty("groupAdmin").remove();
            }
            if (groupAdmins != null || moderators != null || groupCreatePermissionType != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("allowAnonymousAccess", anonymousAccess);
                map.put("groupAdmin", groupAdmins != null ? groupAdmins : new String[]{});
                map.put("createGroupPermission", groupCreatePermissionType != null ? groupCreatePermissionType : currentValue.getConfiguration().getGroupManagementConfiguration().getCreatePermission());
                map.put("moderators", moderators != null ? moderators : new String[]{});
                String bluePrint = (String)properties.get("blueprint");
                this.siteService.createSiteUserGroups(site, context, msmSession, map, userManagerSession, aclSession);
                this.siteService.applyACLs(bluePrint, site, context, msmSession, userManagerSession, aclSession);
            }
            String payload = "";
            payload = context.isMultiTenantSupported() ? context.getSitePayloadPath() + parent.getPath() : context.getSitePayloadPath() + site.getPath();
            Node photoFolder = configNode.getParent().getNode("photos");
            String currentThemeId = "";
            if (configNode.hasProperty("theme")) {
                currentThemeId = configNode.getProperty("theme").getString();
            }
            if (StringUtils.isBlank((CharSequence)currentThemeId)) {
                currentThemeId = "/etc/designs/community/sitethemes/bootstrap-default/clientlibs";
            }
            if (!(themeId = (String)PropertiesUtils.get(properties, (String)"theme", (Object)currentThemeId)).equals(currentThemeId) && (themeNode = this.getThemeNode(context, currentThemeId, session)) != null) {
                themeNode.remove();
            }
            Node image = null;
            for (DataSource ds : attachments) {
                image = AbstractSiteOperationService.addThemeAsset(resolver, context, themeId, ds.getName(), resolver.adaptTo(Session.class).getValueFactory().createBinary(ds.getInputStream()), ds.getContentType());
                String contentMimeType = ds.getContentType();
                if (image == null) continue;
                JcrUtil.copy(image, photoFolder, "image");
            }
            Node siteThumbnailImage = this.createThumbnailAsset(siteThumbnail, parent, resolver, context);
            Node siteCSSNode = this.createCSSAsset(siteCSS, session, context);
            if (siteCSSNode != null) {
                JcrUtil.setProperty(configNode, "theme", siteCSSNode.getPath());
            } else {
                String themeProp = (String)PropertiesUtils.get(properties, (String)"theme", (Object)"/etc/designs/community/sitethemes/bootstrap-default/clientlibs");
                JcrUtil.setProperty(configNode, "theme", themeProp);
            }
            String[] tags = (String[])properties.get("tagNameSpaces");
            if (tags != null) {
                if ((tags = this.trimTags(tags)).length == 0) {
                    JcrUtil.setProperty(configNode, "tagNameSpaces", new String[0]);
                }
                JcrUtil.setProperty(configNode, "tagNameSpaces", tags);
            }
            if ((availableLanguages = (String[])properties.get("availableLanguages")) != null) {
                if (availableLanguages.length == 0) {
                    JcrUtil.setProperty(configNode, "availableLanguages", new String[0]);
                } else {
                    JcrUtil.setProperty(configNode, "availableLanguages", availableLanguages);
                }
            }
            session.save();
            return resolver.getResource(configNode.getPath());
        }
        catch (Exception e) {
            LOG.error("Error updating Community site.", (Throwable)e);
            throw new OperationException("Error updating community site.", e, 500);
        }
    }

    private void updateSiteStructure(Node configNode, Resource site, String structureString, ResourceResolver resolver) throws JSONException, RepositoryException, PersistenceException, WCMException, OperationException {
        JSONObject structure = new JSONObject(structureString);
        PageManager pageMgr = resolver.adaptTo(PageManager.class);
        JSONArray functions = structure.getJSONArray("functions");
        JSONArray newStructure = new JSONArray();
        ArrayList<String> deletedPages = new ArrayList<String>(3);
        for (int i = 0; i < functions.length(); ++i) {
            JSONObject function = functions.getJSONObject(i);
            FunctionDefinition funcDef = this.funcDefUtils.createFunctionDefinition(function, resolver);
            function.put("funcDef", funcDef);
            StructureActions action = function.has("action") ? StructureActions.fromString(function.getString("action")) : null;
            function.put("action", (Object)action);
            if (action != StructureActions.DELETED) {
                newStructure.put(function);
            }
            if (action == StructureActions.NEW) {
                this.siteBlueprintService.rolloutFunction(site.getPath(), funcDef, resolver);
            }
            functions.put(i, function);
        }
        this.reorderFunctions(functions, site, resolver, configNode.getProperty("blueprint").getString(), deletedPages);
        Node functionsNode = this.funcDefUtils.createFunctions(newStructure, configNode, resolver);
        this.deleteFunctions(functionsNode, deletedPages, site, pageMgr, resolver);
        this.applyConfigurations(functionsNode, site, resolver);
    }

    private void deleteFunctions(Node functionsNode, List<String> deletedPages, Resource site, PageManager pageMgr, ResourceResolver resolver) throws WCMException, ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        for (int i = 0; i < deletedPages.size(); ++i) {
            this.markPageForDeletion(site.getChild(deletedPages.get(i)), pageMgr, deletedPages, resolver.getUserID());
        }
        functionsNode.setProperty("toBeDeleted", deletedPages.toArray(new String[deletedPages.size()]));
    }

    private void markPageForDeletion(Resource page, PageManager pageMgr, List<String> deletedPages, String userId) throws WCMException {
        Page pageToBeDeleted = pageMgr.getPage(page.getPath());
        if (pageToBeDeleted != null) {
            Resource contentResource = pageToBeDeleted.getContentResource();
            ModifiableValueMap properties = contentResource.adaptTo(ModifiableValueMap.class);
            properties.put("deleted", Calendar.getInstance());
            properties.put("deletedBy", userId);
            properties.put("hideInNav", true);
        }
    }

    private void applyConfigurations(Node functionsNode, Resource site, ResourceResolver resolver) throws RepositoryException {
        Resource functionsFolder = resolver.getResource(functionsNode.getPath());
        boolean isHomePage = true;
        PageManager pageManager = resolver.adaptTo(PageManager.class);
        for (Resource function : functionsFolder.getChildren()) {
            ValueMap functionProps = function.adaptTo(ValueMap.class);
            String functionPath = functionProps.get("function", "");
            Resource functionMeta = resolver.getResource(functionPath);
            Page functionPage = isHomePage ? pageManager.getPage(site.getPath()) : pageManager.getPage(site.getChild(functionProps.get("url", "")).getPath());
            this.siteBlueprintService.applyFunctionConfig(resolver, function, functionMeta, functionPage);
            isHomePage = false;
        }
    }

    private void reorderFunctions(JSONArray newStructure, Resource site, ResourceResolver resolver, String templatePath, List<String> deletedPages) throws JSONException, WCMException, PersistenceException, RepositoryException {
        PageManager pageManager = resolver.adaptTo(PageManager.class);
        Page oldHome = this.fixHomePage(newStructure, templatePath, site, resolver, deletedPages, pageManager);
        for (int i = newStructure.length() - 1; i > 0; --i) {
            boolean hasUrlChanged;
            JSONObject function = newStructure.getJSONObject(i);
            FunctionDefinition funcDef = (FunctionDefinition)function.get("funcDef");
            String child = function.has("origUrl") ? function.getString("origUrl") : funcDef.getUrl();
            StructureActions action = function.has("action") ? (StructureActions)((Object)function.get("action")) : null;
            Resource resourceBeingTouched = site.getChild(child);
            Page pageToTouch = this.findPageToTouch(pageManager, oldHome, resourceBeingTouched);
            boolean bl = function.has("origUrl") ? !StringUtils.equals((CharSequence)function.getString("origUrl"), (CharSequence)funcDef.getUrl()) : (hasUrlChanged = false);
            if (action == StructureActions.DELETED) {
                deletedPages.add(pageToTouch.getName());
                continue;
            }
            String nextFuncUrl = null;
            if (i + 1 != newStructure.length()) {
                JSONObject nextFunction = newStructure.getJSONObject(i + 1);
                FunctionDefinition nextFunDefc = (FunctionDefinition)nextFunction.get("funcDef");
                nextFuncUrl = nextFunDefc.getUrl();
            }
            if (hasUrlChanged) {
                this.markForMove(pageToTouch, site.getPath() + "/" + funcDef.getUrl(), nextFuncUrl, resolver, deletedPages, pageManager);
                continue;
            }
            pageManager.move(pageToTouch, site.getPath() + "/" + funcDef.getUrl(), nextFuncUrl, false, true, null);
        }
    }

    private void markForMove(Page pageToTouch, String newUrl, String nextFuncUrl, ResourceResolver resolver, List<String> deletedPages, PageManager pageManager) throws WCMException {
        deletedPages.add(pageToTouch.getName());
        pageManager.copy(pageToTouch, newUrl, nextFuncUrl, false, false);
    }

    private Page findPageToTouch(PageManager pageManager, Page oldHome, Resource resourceBeingMoved) {
        if (resourceBeingMoved == null) {
            return oldHome;
        }
        Page potentialMatch = pageManager.getPage(resourceBeingMoved.getPath());
        Resource contentResource = potentialMatch.getContentResource();
        ValueMap resourceProps = contentResource.getValueMap();
        if (resourceProps.containsKey("deleted")) {
            return oldHome;
        }
        return potentialMatch;
    }

    private Page fixHomePage(JSONArray newStructure, String templatePath, Resource site, ResourceResolver resolver, List<String> deletedPages, PageManager pageManager) throws PersistenceException, JSONException, WCMException, RepositoryException {
        StructureActions action;
        JSONObject function = newStructure.getJSONObject(0);
        FunctionDefinition funcDef = (FunctionDefinition)function.get("funcDef");
        String child = function.has("origUrl") ? function.getString("origUrl") : funcDef.getUrl();
        StructureActions structureActions = action = function.has("action") ? (StructureActions)((Object)function.get("action")) : null;
        if (this.hasHomePageMoved(newStructure, site, function, action)) {
            return this.moveHomePage(pageManager, newStructure, site, resolver, templatePath, deletedPages);
        }
        return null;
    }

    private Page moveHomePage(PageManager pageManager, JSONArray newStructure, Resource site, ResourceResolver resolver, String templatePath, List<String> deletedPages) throws WCMException, JSONException, PersistenceException, RepositoryException {
        Page oldHome = pageManager.copy(pageManager.getPage(site.getPath()), site.getPath() + "/oldHome", null, true, true);
        JSONObject newHomeFunc = newStructure.getJSONObject(0);
        Resource oldHomeContent = site.getChild(NODE_JCR_CONTENT);
        resolver.delete(oldHomeContent);
        Node siteRoot = site.adaptTo(Node.class);
        String newHomeUrl = newHomeFunc.has("origUrl") ? newHomeFunc.getString("origUrl") : newHomeFunc.getString("url");
        Node newHomeContent = site.getChild(newHomeUrl + "/jcr:content").adaptTo(Node.class);
        JcrUtil.copy(newHomeContent, siteRoot, NODE_JCR_CONTENT);
        deletedPages.add(newHomeUrl);
        this.siteBlueprintService.configureHomePage(this.getSiteRootConfig(resolver, templatePath), resolver.getResource(oldHomeContent.getPath()));
        return oldHome;
    }

    private Resource getSiteRootConfig(ResourceResolver resolver, String templatePath) {
        Resource template = resolver.getResource(templatePath);
        ValueMap templateProps = template.getValueMap();
        String baseTemplatePath = templateProps.get("sitePath", "/content/communities/templates/basetemplate");
        Resource siteWideFunctions = resolver.getResource(baseTemplatePath);
        return siteWideFunctions.getChild("siteRootConfig");
    }

    private boolean hasHomePageMoved(JSONArray newStructure, Resource site, JSONObject function, StructureActions action) throws JSONException {
        if (action == StructureActions.MOVED || action == StructureActions.NEW) {
            return true;
        }
        return site.getChild(function.getString("origUrl")) != null;
    }

    private String[] trimTags(String[] tags) {
        ArrayList<String> tagList = new ArrayList<String>(tags.length);
        for (String tag : tags) {
            if (StringUtils.isEmpty((CharSequence)tag)) continue;
            tagList.add(tag);
        }
        return tagList.toArray(new String[tagList.size()]);
    }

    private Node createCSSAsset(List<DataSource> siteThumbnail, Session session, CommunityContext context) throws RepositoryException, IOException {
        String absolutePath = context.getSiteThemePath();
        String nodeType = "cq:ClientLibraryFolder";
        for (DataSource cssFile : siteThumbnail) {
            boolean isCss = cssFile.getContentType().equalsIgnoreCase("text/css");
            if (!isCss) continue;
            String assetName = JcrUtil.createValidName(cssFile.getName());
            Node assetRootNode = JcrUtil.createPath(absolutePath, false, "sling:Folder", "sling:Folder", session, false);
            Node assetNode = JcrUtil.createUniqueNode(assetRootNode, assetName, "cq:ClientLibraryFolder", session);
            Node cssNode = JcrUtils.putFile(assetNode, assetName, "text/css", cssFile.getInputStream());
            String themeCategoryName = "cq.social.console.theme.custom." + context.getSiteId() + "." + assetNode.getName();
            if (context.isMultiTenantSupported()) {
                themeCategoryName = "cq.social.console.theme.custom." + context.getTenantId() + "." + context.getSiteId() + "." + assetNode.getName();
            }
            JcrUtil.setProperty(assetNode, "categories", new String[]{themeCategoryName});
            JcrUtils.putFile(assetNode, "css.txt", "text/plain", new ByteArrayInputStream(cssNode.getName().getBytes()));
            return assetNode;
        }
        return null;
    }

    private Node createThumbnailAsset(List<DataSource> siteThumbnail, Resource site, ResourceResolver resolver, CommunityContext context) throws RepositoryException, IOException {
        if (siteThumbnail != null && !siteThumbnail.isEmpty()) {
            Iterator<DataSource> i$;
            Node siteNode = site.getChild(NODE_JCR_CONTENT).adaptTo(Node.class);
            if (siteNode.hasNode("image")) {
                Node fileNode = siteNode.getNode("image");
                fileNode.remove();
                resolver.adaptTo(Session.class).save();
            }
            if ((i$ = siteThumbnail.iterator()).hasNext()) {
                DataSource ds = i$.next();
                return AbstractSiteOperationService.createFile(resolver, "file", resolver.adaptTo(Session.class).getValueFactory().createBinary(ds.getInputStream()), ds.getContentType(), siteNode, "image", ds.getName(), context);
            }
        }
        return null;
    }

    private boolean isUpdatedParameter(String key, Object value, Node configNode) throws RepositoryException {
        if (configNode.hasProperty(key)) {
            Property prop = configNode.getProperty(key);
            if (!prop.isMultiple()) {
                Value currentValue = prop.getValue();
                Value newValue = JcrUtil.createValue(value, configNode.getSession());
                if (newValue != null) {
                    return !newValue.equals(currentValue);
                }
                return true;
            }
            return true;
        }
        return true;
    }

    private String getGroupPermissionType(Map<String, Object> properties) throws OperationException {
        String groupCreatePermissionType = (String)properties.get("createGroupPermission");
        if (groupCreatePermissionType != null) {
            try {
                SiteConfiguration.GroupManagementConfiguration.CreatePermission.valueOf(groupCreatePermissionType);
            }
            catch (IllegalArgumentException e) {
                throw new OperationException("Invalid Group Permission Type value.", 400);
            }
        }
        return groupCreatePermissionType;
    }

    private String getRootPath(Resource tenantRoot) {
        String tenantId;
        ResourceResolver resolver = tenantRoot.getResourceResolver();
        String rootPath = tenantRoot.getPath();
        Tenant tenant = tenantRoot.adaptTo(Tenant.class);
        boolean adjustRootPath = false;
        if (tenant == null) {
            tenant = resolver.adaptTo(Tenant.class);
            adjustRootPath = true;
        }
        String string = tenantId = tenant == null ? null : tenant.getId();
        if (adjustRootPath) {
            rootPath = rootPath + "/" + tenantId;
        }
        return rootPath;
    }

    private boolean isSpecialRequestParam(String paramName) {
        for (int i = 0; i < specialParams.length; ++i) {
            if (!paramName.equals(specialParams[i])) continue;
            return true;
        }
        return false;
    }

    private Node getOrCreateSitesRootPage(String contentPath, ResourceResolver resolver) throws OperationException {
        try {
            if (resolver.getResource(contentPath) == null) {
                PageManager pm = resolver.adaptTo(PageManager.class);
                Page page = pm.create(Text.getRelativeParent(contentPath, 1), Text.getName(contentPath), null, SITES_ROOT_TITLE);
            }
            Session session = resolver.adaptTo(Session.class);
            return session.getNode(contentPath);
        }
        catch (Exception e) {
            throw new OperationException("Error creating root of community site.", e, 500);
        }
    }

    @Override
    public Resource create(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String rootPath = request.getParameter("siteRoot");
        Resource root = null;
        if (StringUtils.isBlank((CharSequence)rootPath)) {
            root = resource.getResourceResolver().getResource(CONTENT_SITES);
        } else {
            root = resource.getResourceResolver().getResource(rootPath);
            if (root == null) {
                root = new NonExistingResource(resource.getResourceResolver(), rootPath);
            }
        }
        if (!this.siteService.mayPost(root, session)) {
            throw new OperationException("Access violation.", 403);
        }
        String name = request.getParameter("urlName");
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new OperationException("Community site name is missing", 400);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, true);
            this.getCustomProperties(request, props, session);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to obtain community site parameters.", e, 500);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, "pagebanner");
        List<DataSource> cssFiles = this.getAttachmentsFromRequest(request, "pagecss");
        List<DataSource> siteThumbnail = this.getAttachmentsFromRequest(request, "pagethumbnail");
        U createOperation = this.getCreateOperation();
        this.getExtensionParameters(createOperation, request, props);
        ResourceResolver msmResolver = null;
        ResourceResolver userManagerResolver = null;
        ResourceResolver aclResolver = null;
        try {
            msmResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            userManagerResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            aclResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", ACL_MANAGER));
            Resource resource2 = this.create(root, name, props, attachments, cssFiles, siteThumbnail, session, msmResolver, userManagerResolver, aclResolver);
            return resource2;
        }
        catch (LoginException e) {
            LOG.error("Failed to login as service user.", (Throwable)e);
            throw new OperationException(e.getMessage(), e, 500);
        }
        finally {
            if (msmResolver != null) {
                msmResolver.close();
            }
            if (userManagerResolver != null) {
                userManagerResolver.close();
            }
            if (aclResolver != null) {
                aclResolver.close();
            }
        }
    }

    private String createUniqueNameHint(String nameBase, int numRandomChars) {
        String base = nameBase;
        if (base.length() > 20) {
            base = base.substring(0, 20);
        }
        base = base.replaceAll("\\<.*?>", "");
        base = base.replaceAll("\\&.*?\\;", "");
        StringBuilder name = new StringBuilder(base);
        String suffix = this.socialUtils.generateRandomString(numRandomChars);
        name.append("-");
        name.append(suffix);
        return name.toString().toLowerCase();
    }

    private synchronized String generateUniqueSiteId(ResourceResolver resolver, String name, String root) throws OperationException {
        int num = 0;
        do {
            String siteId;
            if (SiteBlueprintUtil.validateGroupName(resolver, siteId = this.createUniqueNameHint(name, 5), root)) {
                return siteId;
            }
            LOG.debug("failed with {}", (Object)siteId);
        } while (++num < 10);
        throw new OperationException("Failed to generate a unique community site id with name " + name, 500);
    }

    @Override
    public Resource update(SlingHttpServletRequest request) throws OperationException {
        Resource resource = request.getResource();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        CommunitySite site = resource.adaptTo(CommunitySite.class);
        if (!this.siteService.mayPost(resource, session)) {
            throw new OperationException("Access violation.", 403);
        }
        String name = site != null ? site.getSiteUrlName() : resource.getName();
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, false);
            this.getCustomProperties(request, props, session);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to create community site.", e, 500);
        }
        List<DataSource> siteBanner = this.getAttachmentsFromRequest(request, "pagebanner");
        List<DataSource> siteCSS = this.getAttachmentsFromRequest(request, "pagecss");
        List<DataSource> siteThumbnail = this.getAttachmentsFromRequest(request, "pagethumbnail");
        U updateOperation = this.getUpdateOperation();
        this.getExtensionParameters(updateOperation, request, props);
        ResourceResolver msmResolver = null;
        ResourceResolver userManagerResolver = null;
        ResourceResolver aclResolver = null;
        try {
            msmResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", MSM_SERVICE));
            userManagerResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", USER_ADMIN));
            aclResolver = this.serviceUserWrapper.getServiceResourceResolver(this.resourceResolverFactory, Collections.singletonMap("sling.service.subservice", ACL_MANAGER));
            Resource resource2 = this.update(resource, name, props, siteBanner, siteThumbnail, siteCSS, session, msmResolver, userManagerResolver, aclResolver);
            return resource2;
        }
        catch (LoginException e) {
            LOG.error("Failed to login as service user.", (Throwable)e);
            throw new OperationException(e.getMessage(), e, 500);
        }
        finally {
            if (msmResolver != null) {
                msmResolver.close();
            }
            if (userManagerResolver != null) {
                userManagerResolver.close();
            }
            if (aclResolver != null) {
                aclResolver.close();
            }
        }
    }

    protected List<DataSource> getAttachmentsFromRequest(SlingHttpServletRequest request) {
        RequestParameter[] fileRequestParameters = request.getRequestParameters("file");
        if (fileRequestParameters != null) {
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, Integer.MAX_VALUE, WHITE_LIST, BLACK_LIST);
        }
        return Collections.emptyList();
    }

    protected List<DataSource> getSiteThumbnailAttachmentsFromRequest(SlingHttpServletRequest request) {
        RequestParameter[] fileRequestParameters = request.getRequestParameters("pagethumbnail");
        if (fileRequestParameters != null) {
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, Integer.MAX_VALUE, WHITE_LIST, BLACK_LIST);
        }
        return Collections.emptyList();
    }

    protected List<DataSource> getAttachmentsFromRequest(SlingHttpServletRequest request, String requestParameterName) {
        RequestParameter[] fileRequestParameters = request.getRequestParameters(requestParameterName);
        if (fileRequestParameters != null) {
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, Integer.MAX_VALUE, WHITE_LIST, BLACK_LIST);
        }
        return Collections.emptyList();
    }

    protected void getDefaultProperties(SlingHttpServletRequest request, Map<String, Object> props, boolean validateRequired) throws RepositoryException, OperationException {
        for (int i = 0; i < requestParams.length; ++i) {
            Object[] params = requestParams[i];
            Class clazz = (Class)params[1];
            String name = (String)params[0];
            if (clazz.isArray()) {
                String[] values = request.getParameterValues(name);
                if (validateRequired && values == null && ((Boolean)params[2]).booleanValue()) {
                    throw new OperationException("Community site value '" + name + "' is empty", 400);
                }
                if (clazz != String[].class || values == null) continue;
                props.put(name, values);
                continue;
            }
            String value = request.getParameter(name);
            if (validateRequired && value == null && ((Boolean)params[2]).booleanValue()) {
                throw new OperationException("Community site value '" + name + "' is empty", 400);
            }
            if (value == null) continue;
            props.put(name, PropertiesUtils.toObject((String)value, (Class)clazz));
        }
    }

    protected void getCustomProperties(SlingHttpServletRequest request, Map<String, Object> map, Session session) throws RepositoryException, OperationException {
        RequestParameterMap params = request.getRequestParameterMap();
        for (String key : params.keySet()) {
            if (map.containsKey(key) || StringUtils.equals((CharSequence)key, (CharSequence)CHARSET_PROPERTY)) continue;
            if (!ArrayUtils.contains((Object[])this.fieldWhitelist, (Object)key) || key.contains(":")) {
                LOG.debug("skipped custom form field [{}], not in white list.", (Object)key);
                continue;
            }
            RequestParameter[] values = (RequestParameter[])params.get(key);
            if (values.length > 0 && values[0].isFormField()) {
                if (values.length == 1) {
                    String paramVal = values[0].getString();
                    if (paramVal == null) continue;
                    map.put(key, values[0].getString());
                    continue;
                }
                String[] paramValues = request.getParameterValues(key);
                if (paramValues == null) continue;
                map.put(key, paramValues);
                continue;
            }
            LOG.debug("skipped custom form field [{}], empty or binary not allowed.", (Object)key);
        }
    }

    protected void getProp(SlingHttpServletRequest request, String key, String defaultValue, Map<String, Object> props) {
        String value = request.getParameter(key);
        props.put(key, StringUtils.isBlank((CharSequence)value) ? "" : value);
    }

    protected String getUserIdFromRequest(SlingHttpServletRequest request, String defaultValue) {
        String userIdentifier;
        UserProperties up = request.getResourceResolver().adaptTo(UserProperties.class);
        String string = userIdentifier = up == null ? null : up.getAuthorizableID();
        if (userIdentifier == null) {
            userIdentifier = defaultValue;
        }
        return userIdentifier;
    }

    protected static Node createFile(ResourceResolver resolver, String name, Binary data, String contentType, Node themeIdNode, String assetRootName, String fileNameProperty, CommunityContext context) throws RepositoryException {
        Node resNode;
        Node assetNode;
        int pos;
        Session session = resolver.adaptTo(Session.class);
        boolean isCss = contentType.equalsIgnoreCase("text/css");
        String nodeType = "nt:unstructured";
        boolean createUniqueLeaf = false;
        String aRootName = assetRootName;
        Node assetRootNode = JcrUtil.createPath(themeIdNode, aRootName, false, "nt:unstructured", "nt:unstructured", session, false);
        String assetName = name;
        if (assetName == null) {
            assetName = "a" + System.currentTimeMillis() + ".bin";
        } else {
            int pos2 = assetName.lastIndexOf(47);
            if (pos2 < 0) {
                pos2 = assetName.lastIndexOf(92);
            }
            if (pos2 >= 0) {
                assetName = name.substring(pos2 + 1);
            }
        }
        String assetContentType = contentType;
        if (assetContentType == null) {
            assetContentType = "application/octet-stream";
        }
        if ((pos = assetContentType.indexOf(59)) > 0) {
            assetContentType = assetContentType.substring(0, pos);
        }
        String fileNameWithoutExtension = FilenameUtils.getBaseName((String)assetName);
        String fileNameExtension = FilenameUtils.getExtension((String)assetName);
        fileNameWithoutExtension = JcrUtil.isValidName(fileNameWithoutExtension) ? fileNameWithoutExtension : JcrUtil.createValidName(fileNameWithoutExtension);
        String fileName = "";
        fileName = StringUtils.isBlank((CharSequence)fileNameExtension) ? fileNameWithoutExtension : fileNameWithoutExtension + "." + fileNameExtension;
        if (assetRootNode.hasNode(fileName)) {
            assetNode = assetRootNode.getNode(fileName);
            resNode = assetNode.getNode(NODE_JCR_CONTENT);
        } else {
            assetNode = assetRootNode.addNode(fileName, "cq:CommentAttachment");
            resNode = assetNode.addNode(NODE_JCR_CONTENT, "nt:resource");
        }
        resNode.setProperty("jcr:mimeType", assetContentType);
        resNode.setProperty("jcr:data", data);
        resNode.setProperty("jcr:lastModified", Calendar.getInstance());
        assetNode.setProperty("name", fileNameProperty);
        return assetNode;
    }

    protected static Node addThemeAsset(ResourceResolver resolver, CommunityContext context, String themeId, String name, Binary data, String contentType) throws OperationException {
        Session session = resolver.adaptTo(Session.class);
        try {
            Node tenantRootNode = session.getNode("/etc/designs");
            if (tenantRootNode != null) {
                String themePath = context.getSiteThemePath();
                String relativePath = new File("/etc/designs").toURI().relativize(new File(themePath).toURI()).getPath();
                Node themeRootNode = JcrUtils.getOrCreateByPath(tenantRootNode, relativePath, false, "sling:Folder", "sling:Folder", false);
                return AbstractSiteOperationService.createFile(resolver, name, data, contentType, themeRootNode, "images", name, context);
            }
            return null;
        }
        catch (RepositoryException e) {
            try {
                session.refresh(false);
            }
            catch (RepositoryException e1) {
                throw new OperationException("Repository error while adding theme asset.", 500);
            }
            throw new OperationException("Repository error while adding theme asset.", 500);
        }
    }

    private Node getThemeNode(CommunityContext context, String themeId, Session session) throws PathNotFoundException, RepositoryException {
        String themePath = context.getSiteThemePath() + 47 + themeId;
        return session.getNode(themePath);
    }

    private String getStringProperty(String key, Map<String, Object> props) throws RepositoryException {
        Object obj = props.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Value) {
            return ((Value)obj).getString();
        }
        return obj.toString();
    }

    @Override
    public SocialComponent publish(SlingHttpServletRequest request) throws OperationException {
        if (this.groupService == null) {
            throw new OperationException("Failed to get GroupService.", 403);
        }
        if (this.siteService == null) {
            throw new OperationException("Failed to get SiteService.", 403);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        String sitePath = request.getParameter("path");
        if (StringUtils.isEmpty((CharSequence)sitePath)) {
            throw new OperationException("Missing request parameter path", 400);
        }
        props.put("path", sitePath);
        Resource resource = request.getResource();
        U publishOperation = this.getPublishOperation();
        this.getExtensionParameters(publishOperation, request, props);
        this.performBeforeActions(publishOperation, resource.getResourceResolver().adaptTo(Session.class), resource, props);
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        if (!this.siteService.mayPost(request, session)) {
            throw new OperationException("User " + session.getUserID() + " has no permission to publish community site " + resource.getPath(), 403);
        }
        try {
            Resource clientLibResource;
            String themeId;
            Resource community = resolver.getResource(sitePath);
            if (community == null) {
                throw new OperationException("Failed to find site @" + sitePath, 404);
            }
            CommunityContext context = community.adaptTo(CommunityContext.class);
            Resource content = community.getChild(NODE_JCR_CONTENT);
            Resource config = community.getChild("configuration");
            Node node = content.adaptTo(Node.class);
            node.setProperty("formPayload", context.getSitePayloadPath() + sitePath);
            if (config != null && StringUtils.isNotBlank((CharSequence)(themeId = (String)((Object)config.getValueMap().get("theme", String.class)))) && (clientLibResource = resolver.getResource(themeId)) != null) {
                String[] clientLibCategory;
                ValueMap clientLibResourceProperties = clientLibResource.adaptTo(ValueMap.class);
                for (String clientLib : clientLibCategory = (String[])clientLibResourceProperties.get("categories", String[].class)) {
                    if (!StringUtils.contains((CharSequence)clientLib, (CharSequence)"cq.social.console.theme.custom.")) continue;
                    node.setProperty("themePayload", themeId);
                }
            }
            this.groupService.activateCommunity(resolver, sitePath);
            CommunitySite site = (CommunitySite)this.getSocialComponentForCommunitySite(community, request);
            this.performAfterActions(publishOperation, session, site, props);
            return site;
        }
        catch (SlingException e) {
            throw new OperationException("Failed to activate community site; " + e.getMessage(), 403);
        }
        catch (ReplicationException e) {
            throw new OperationException("Failed to activate community site; " + e.getMessage(), 403);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to activate community site; " + e.getMessage(), 403);
        }
    }

    @Override
    public SocialComponent unpublish(SlingHttpServletRequest request) throws OperationException {
        if (this.siteService == null) {
            throw new OperationException("Failed to get SiteService.", 403);
        }
        String sitePath = request.getParameter("path");
        if (StringUtils.isEmpty((CharSequence)sitePath)) {
            throw new OperationException("Missing request parameter path", 400);
        }
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        if (!this.siteService.mayPost(request, session)) {
            throw new OperationException("User " + session.getUserID() + " has no permission to unpublish community site " + resource.getPath(), 403);
        }
        try {
            Resource community = resolver.getResource(sitePath);
            if (community == null) {
                throw new OperationException("Failed to find site @" + sitePath, 404);
            }
            this.groupService.deactivateCommunity(resolver, sitePath);
            return this.getSocialComponentForCommunitySite(community, request);
        }
        catch (SlingException e) {
            throw new OperationException("Failed to activate community site; " + e.getMessage(), 403);
        }
        catch (ReplicationException e) {
            throw new OperationException("Failed to activate community site; " + e.getMessage(), 403);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to activate community site; " + e.getMessage(), 403);
        }
    }

    protected abstract U getCreateOperation();

    protected abstract U getDeleteOperation();

    protected abstract U getUpdateOperation();

    protected abstract U getPublishOperation();

    protected abstract U getUnpublishOperation();

    protected void getExtensionParameters(U operation, SlingHttpServletRequest request, Map<String, Object> requestParameters) throws OperationException {
        if (this.extensionProviders.containsKey(operation)) {
            for (SiteOperationExtension extension : (SortedSet)this.extensionProviders.get(operation)) {
                try {
                    extension.getExtensionRequestParameters((Operation)operation, request, requestParameters);
                }
                catch (NoSuchMethodError e) {
                }
                catch (AbstractMethodError e) {}
            }
        }
    }

    protected boolean isConfigurationParameter(U operation, String parameterName) throws OperationException {
        for (String key : specialParams) {
            if (!key.equals(parameterName)) continue;
            return false;
        }
        if (this.extensionProviders.containsKey(operation)) {
            for (SiteOperationExtension extension : (SortedSet)this.extensionProviders.get(operation)) {
                try {
                    return extension.isConfigurationParameter((Operation)operation, parameterName);
                }
                catch (NoSuchMethodError e) {
                }
                catch (AbstractMethodError e) {
                }
            }
        }
        return true;
    }

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindFuncDefUtils(FunctionDefinitionUtils functionDefinitionUtils) {
        this.funcDefUtils = functionDefinitionUtils;
    }

    protected void unbindFuncDefUtils(FunctionDefinitionUtils functionDefinitionUtils) {
        if (this.funcDefUtils == functionDefinitionUtils) {
            this.funcDefUtils = null;
        }
    }

    protected void bindSiteBlueprintService(TemplateRolloutService templateRolloutService) {
        this.siteBlueprintService = templateRolloutService;
    }

    protected void unbindSiteBlueprintService(TemplateRolloutService templateRolloutService) {
        if (this.siteBlueprintService == templateRolloutService) {
            this.siteBlueprintService = null;
        }
    }

    protected void bindSiteService(CommunitySiteService communitySiteService) {
        this.siteService = communitySiteService;
    }

    protected void unbindSiteService(CommunitySiteService communitySiteService) {
        if (this.siteService == communitySiteService) {
            this.siteService = null;
        }
    }

    protected void bindGroupService(SiteActivationService siteActivationService) {
        this.groupService = siteActivationService;
    }

    protected void unbindGroupService(SiteActivationService siteActivationService) {
        if (this.groupService == siteActivationService) {
            this.groupService = null;
        }
    }

    protected void bindSiteConfigurator(SiteConfigurator siteConfigurator) {
        this.siteConfigurator = siteConfigurator;
    }

    protected void unbindSiteConfigurator(SiteConfigurator siteConfigurator) {
        if (this.siteConfigurator == siteConfigurator) {
            this.siteConfigurator = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    private static enum StructureActions {
        NEW("NEW"),
        MOVED("MOV"),
        DELETED("DEL");

        private final String actionString;

        private StructureActions(String actionString) {
            this.actionString = actionString;
        }

        public String getActionString() {
            return this.actionString;
        }

        public static StructureActions fromString(String actionString) {
            for (StructureActions action : StructureActions.values()) {
                if (!StringUtils.equals((CharSequence)actionString, (CharSequence)action.getActionString())) continue;
                return action;
            }
            return null;
        }
    }
}

