/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import com.adobe.cq.social.srp.SocialResourceProvider;
import com.adobe.cq.social.srp.internal.AbstractSchemaMapper;
import com.adobe.cq.social.srp.internal.CachingResourceProvider;
import com.adobe.cq.social.srp.internal.MapResource;
import com.adobe.cq.social.srp.internal.SocialModifiableValueMap;
import com.adobe.cq.social.srp.utilities.internal.InternalStaticResourceUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class MapResourceImpl
extends AbstractResource
implements MapResource {
    private final ResourceResolver resolver;
    private final CachingResourceProvider provider;
    private final Map<String, Object> doc;
    private ResourceMetadata metadata;
    private final boolean isAttachment;
    private final String resolvedPath;

    public MapResourceImpl(ResourceResolver resolver, CachingResourceProvider provider, String resolvedPath, Map<String, Object> doc, boolean isAttachment) {
        this.resolver = resolver;
        this.provider = provider;
        this.doc = doc;
        this.metadata = new ResourceMetadata();
        this.metadata.setResolutionPath(resolvedPath);
        this.isAttachment = isAttachment;
        this.resolvedPath = resolvedPath;
        if (isAttachment) {
            this.setAttachmentMetaData();
        }
    }

    private void setAttachmentMetaData() {
        Long length;
        Calendar created = (Calendar)this.doc.get(AbstractSchemaMapper.getSocoAddedKey());
        if (created != null) {
            this.metadata.setCreationTime(created.getTimeInMillis());
            this.metadata.setModificationTime(created.getTimeInMillis());
        }
        if ((length = (Long)this.doc.get(AbstractSchemaMapper.getSchemaAttachmentLengthKey())) != null) {
            this.metadata.setContentLength(length);
        }
    }

    @Override
    public Resource getParent() {
        String parentPath = (String)this.doc.get("social:parentid");
        if (StringUtils.isEmpty((CharSequence)parentPath)) {
            return null;
        }
        return this.getResourceResolver().getResource(parentPath);
    }

    @Override
    public String getPath() {
        return this.metadata.getResolutionPath();
    }

    @Override
    public String getResourceType() {
        String type = (String)this.doc.get("sling:resourceType");
        if (type == null) {
            return "nt:adobesocialtype";
        }
        return type;
    }

    @Override
    public String getResourceSuperType() {
        return (String)this.doc.get("sling:resourceSuperType");
    }

    @Override
    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    @Override
    public SocialResourceProvider getResourceProvider() {
        return this.provider;
    }

    @Override
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)new ValueMapDecorator(this.applyIncrement());
        }
        if (type == ModifiableValueMap.class) {
            return (AdapterType)new SocialModifiableValueMap(this);
        }
        if (type == Map.class) {
            return (AdapterType)this.doc;
        }
        if (type == InputStream.class) {
            try {
                return (AdapterType)this.provider.getAttachmentInputStream(this.resolver, this.resolvedPath);
            }
            catch (IOException e) {
                return null;
            }
        }
        return super.adaptTo(type);
    }

    private Map<String, Object> applyIncrement() {
        if (this.doc.containsKey("$inc") && this.doc.get("$inc") instanceof Map) {
            Map incMap = (Map)this.doc.get("$inc");
            HashMap temp = new HashMap();
            for (Map.Entry entry : incMap.entrySet()) {
                Long increment = (Long)entry.getValue();
                if (this.doc.containsKey(entry.getKey())) {
                    Object startValue = this.doc.get(entry.getKey());
                    if (startValue instanceof Long) {
                        temp.put(entry.getKey(), (Long)startValue + increment);
                        continue;
                    }
                    if (!(startValue instanceof Integer)) continue;
                    temp.put(entry.getKey(), ((Integer)startValue).longValue() + increment);
                    continue;
                }
                temp.put(entry.getKey(), increment);
            }
            HashMap<String, Object> newDoc = new HashMap<String, Object>();
            newDoc.putAll(this.doc);
            newDoc.putAll(temp);
            newDoc.remove("$inc");
            return newDoc;
        }
        return this.doc;
    }

    public void update() {
        this.provider.update(this);
    }

    @Override
    public Resource getRootJCRNode() {
        if (this.doc.containsKey("social:rootCommentSystem")) {
            return this.getResourceResolver().resolve((String)this.doc.get("social:rootCommentSystem"));
        }
        return null;
    }

    @Override
    public boolean isAttachment() {
        return this.isAttachment;
    }

    @Override
    public void unlockMetadata() {
        String resolvedPath = this.metadata.getResolutionPath();
        this.metadata = new ResourceMetadata();
        this.metadata.setResolutionPath(resolvedPath);
        if (this.isAttachment) {
            this.setAttachmentMetaData();
        }
    }

    private String getJcrAclPath() {
        return MapResourceImpl.getAclPathGivenBase(this.getPath(), this.provider.getASIPath());
    }

    public static String getAclPathGivenBase(String path, String providerBase) {
        return StringUtils.removeEnd((String)"/content/usergenerated", (String)"/") + "/" + StringUtils.removeStart((String)StringUtils.removeStart((String)path, (String)providerBase), (String)"/");
    }

    @Override
    public boolean checkPermissions(String permission) {
        return InternalStaticResourceUtilities.checkPermission(this.resolver, this.getJcrAclPath(), permission);
    }
}

