/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import com.adobe.cq.social.srp.internal.AbstractSchemaMapper;
import com.adobe.cq.social.srp.internal.MapResourceImpl;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;

class SocialModifiableValueMap
extends ModifiableValueMapDecorator {
    private static final Set<String> KEY_BLACK_LIST = new HashSet<String>();
    private final MapResourceImpl resource;

    public SocialModifiableValueMap(MapResourceImpl resource) {
        super(resource.adaptTo(Map.class));
        this.resource = resource;
    }

    @Override
    public Object put(String key, Object value) {
        Map incMap;
        if (KEY_BLACK_LIST.contains(key)) {
            return null;
        }
        this.resource.update();
        if (super.containsKey("$inc") && super.get("$inc") instanceof Map && (incMap = (Map)super.get("$inc")).containsKey(key)) {
            incMap.remove(key);
            if (incMap.isEmpty()) {
                super.remove("$inc");
            }
        }
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (KEY_BLACK_LIST.contains(key) || !super.containsKey(key) || super.get(key) == null) {
            return null;
        }
        this.resource.update();
        return super.put((String)key, (Object)null);
    }

    @Override
    public void clear() {
        super.clear();
        this.resource.update();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        boolean dirty = false;
        for (String string : m.keySet()) {
            if (KEY_BLACK_LIST.contains(string)) continue;
            super.put(string, m.get(string));
            dirty = true;
        }
        if (dirty) {
            this.resource.update();
        }
    }

    @Override
    public <T> T get(String name, Class<T> type) {
        Map incMap;
        Class<T> value = super.get(name, type);
        if ((type == Integer.class || type == Long.class) && super.containsKey("$inc") && super.get("$inc") instanceof Map && (incMap = (Map)super.get("$inc")).containsKey(name) && incMap.get(name) instanceof Long) {
            if (type == Long.class) {
                Long longValue = (Long)((Object)value);
                longValue = longValue + (Long)incMap.get(name);
                return (T)longValue;
            }
            Integer intValue = (Integer)((Object)value);
            intValue = intValue + ((Long)incMap.get(name)).intValue();
            return (T)intValue;
        }
        return (T)value;
    }

    static {
        KEY_BLACK_LIST.add(AbstractSchemaMapper.getSocoKey());
        KEY_BLACK_LIST.add(AbstractSchemaMapper.getSocoParentIdKey());
    }
}

