/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import com.adobe.cq.social.srp.internal.CachingResourceProvider;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocialProviderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocialProviderUtils.class);
    private static final String IGNORE_DOT_SUFFIX = "html|json|form|feed|deletecomment|editcomment|createcomment|composer|social|socialuserstatetoggle";
    private static final String IGNORE_SLASH_SUFFIX = "editcomment|editforum";
    private static final String PAGING_PATTERN = "(\\.social(\\.[0-9]+){1,2})|(\\.social.\\$\\{startIndex}.*)";
    private static final String DOT_PATTERN = "(\\.(?i)(html|json|form|feed|deletecomment|editcomment|createcomment|composer|social|socialuserstatetoggle))";
    private static final String SLASH_PATTERN = "(\\/(?i)(editcomment|editforum))";
    private static final String SUFFIX_PATTERN = "([^\\s]+((\\.(?i)(html|json|form|feed|deletecomment|editcomment|createcomment|composer|social|socialuserstatetoggle))|(\\/(?i)(editcomment|editforum))|(\\.social(\\.[0-9]+){1,2})|(\\.social.\\$\\{startIndex}.*))$)";
    private static final Pattern PATTERN = Pattern.compile("([^\\s]+((\\.(?i)(html|json|form|feed|deletecomment|editcomment|createcomment|composer|social|socialuserstatetoggle))|(\\/(?i)(editcomment|editforum))|(\\.social(\\.[0-9]+){1,2})|(\\.social.\\$\\{startIndex}.*))$)");

    private SocialProviderUtils() {
    }

    public static boolean isExtraneousSlingPath(String path) {
        return SocialProviderUtils.isExtraneousSlingPath(null, null, path);
    }

    public static boolean isExtraneousSlingPath(ResourceResolver resolver, CachingResourceProvider srp, String path) {
        if (path.contains("/_jcr_content/")) {
            return true;
        }
        if (path.endsWith("/")) {
            return true;
        }
        if (resolver != null && srp != null && StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)".social.json")) {
            SocialProviderUtils.batchResolve(resolver, srp, StringUtils.removeEndIgnoreCase((String)path, (String)".social.json"));
            return true;
        }
        Matcher matcher = PATTERN.matcher(path);
        if (matcher.matches()) {
            LOGGER.debug("Ignoring extraneous path: {}", (Object)path);
            return true;
        }
        return false;
    }

    private static void batchResolve(ResourceResolver resolver, CachingResourceProvider srp, String path) {
        ArrayList<String> resourcePaths = new ArrayList<String>();
        String component = StringUtils.substringAfterLast((String)path, (String)"/");
        String prefix = StringUtils.substringBeforeLast((String)path, (String)"/");
        StringBuilder sb = new StringBuilder(srp.getASIPath());
        StringTokenizer tokener = new StringTokenizer(StringUtils.removeStartIgnoreCase((String)prefix, (String)srp.getASIPath()), "/");
        while (tokener.hasMoreTokens()) {
            sb.append('/');
            sb.append(tokener.nextToken());
            resourcePaths.add(sb.toString());
        }
        if ("voting".equalsIgnoreCase(component)) {
            sb.append("/voting");
            resourcePaths.add(sb.toString());
            sb.append("/");
            sb.append(resolver.getUserID());
            resourcePaths.add(sb.toString());
        }
        if ("socialgraph".equalsIgnoreCase(component)) {
            sb.append("/socialgraph");
            resourcePaths.add(sb.toString());
        } else {
            String resourceName = StringUtils.substringBefore((String)component, (String)".");
            sb.append("/");
            sb.append(resourceName);
            resourcePaths.add(sb.toString());
        }
        if (!resourcePaths.isEmpty()) {
            srp.getResources(resolver, resourcePaths);
        }
    }
}

