/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.subscriptions.api;

import org.apache.commons.lang.StringUtils;

public enum SubscriptionType {
    FOLLOWING("Followings", "following", "social/socialgraph/components/hbs/following", "Activities", null),
    SUBSCRIPTION("Subscriptions", "notification", "social/subscriptions/components/hbs/subscription", "Notifications", null);

    private final String name;
    private final String id;
    private final String resourceType;
    private final String displayName;
    private final String[] supportedTypes;

    private SubscriptionType(String name, String id, String resourceType, String displayName, String[] supportedTypes) {
        this.name = name;
        this.id = id;
        this.resourceType = resourceType;
        this.displayName = displayName;
        this.supportedTypes = supportedTypes;
    }

    public String getValue() {
        return this.name;
    }

    public String getRelationshipId() {
        return this.id;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String[] getSupportedTypes() {
        return (String[])this.supportedTypes.clone();
    }

    public boolean supportedAllTypes() {
        return this.supportedTypes == null || this.supportedTypes.length == 0;
    }

    public static SubscriptionType getByRelationshipId(String id) {
        if (StringUtils.isNotEmpty((String)id)) {
            for (SubscriptionType type : SubscriptionType.values()) {
                if (!id.equals(type.getRelationshipId())) continue;
                return type;
            }
        }
        return null;
    }

    public static SubscriptionType getByValue(String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            for (SubscriptionType type : SubscriptionType.values()) {
                if (!value.equals(type.getValue())) continue;
                return type;
            }
        }
        return null;
    }
}

