/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.subscriptions.client.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.subscriptions.api.Subscription;
import com.adobe.cq.social.subscriptions.api.SubscriptionManager;
import com.adobe.cq.social.subscriptions.api.SubscriptionType;
import com.adobe.cq.social.subscriptions.client.api.SubscriptionCollection;
import com.adobe.cq.social.subscriptions.client.api.SubscriptionStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public class AbstractSubscriptionCollection
extends BaseSocialComponent
implements SubscriptionCollection {
    private final ResourceResolver resolver;
    private String userId;
    private String otherId;
    private static String[] subscriptionTypes;
    private SortedMap<String, SubscriptionStatus> states;
    private final SubscriptionManager subscriptionManager;
    private boolean isSubscribed;
    private boolean isUserLoggedIn;

    public AbstractSubscriptionCollection(Resource resource, ClientUtilities clientUtils, QueryRequestInfo q, SubscriptionManager subscriptionManager) {
        super(resource, clientUtils);
        this.initializeNodes(resource, clientUtils);
        this.resolver = resource.getResourceResolver();
        this.subscriptionManager = subscriptionManager;
    }

    public AbstractSubscriptionCollection(Resource resource, ClientUtilities clientUtils, QueryRequestInfo q, List<Subscription> subscriptions) {
        super(resource, clientUtils);
        this.initializeNodes(resource, clientUtils);
        this.resolver = resource.getResourceResolver();
        this.subscriptionManager = null;
        this.states = this.createStateList(subscriptions);
    }

    private void initializeNodes(Resource resource, ClientUtilities clientUtils) {
        SlingHttpServletRequest request = clientUtils.getRequest();
        if (request != null) {
            this.userId = resource.getResourceResolver().getUserID();
            this.otherId = clientUtils.getUserId(request.getParameter("subscribedId"));
        }
        ValueMap properties = null;
        if (StringUtils.isBlank((String)this.userId)) {
            this.userId = resource.getResourceResolver().getUserID();
        }
        if (StringUtils.isBlank((String)this.otherId)) {
            properties = resource.getValueMap();
            if (properties == null) {
                properties = resource.getValueMap();
            }
            this.otherId = properties.get("subscribedId", "");
            if (StringUtils.isBlank((String)this.otherId)) {
                String resourceId = resource.getPath();
                this.otherId = resourceId.startsWith("/social/authors/") ? clientUtils.getUserId(resourceId) : Text.getRelativeParent(resourceId, 1);
            }
        }
        boolean bl = this.isUserLoggedIn = !StringUtils.isEmpty((String)this.userId) && !this.userId.equalsIgnoreCase("Anonymous");
        if (StringUtils.isBlank((String)this.otherId)) {
            throw new IllegalArgumentException("Invalid value of followedId.");
        }
    }

    @Override
    public String getSubscribedId() {
        return this.otherId;
    }

    @Override
    public String getOwner() {
        return this.userId;
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String[] getTypes() {
        String[] retVal = new String[subscriptionTypes.length];
        System.arraycopy(subscriptionTypes, 0, retVal, 0, subscriptionTypes.length);
        return retVal;
    }

    @Override
    public Map<String, SubscriptionStatus> getStates() {
        if (this.states == null) {
            if (this.isUserLoggedIn) {
                List<Subscription> subscriptions = this.subscriptionManager.getSubscriptions(this.resolver, this.otherId, this.userId, subscriptionTypes);
                if (subscriptions != null) {
                    this.states = this.createStateList(subscriptions);
                }
            } else {
                this.states = this.createStateList(Collections.<Subscription>emptyList());
            }
        }
        if (this.states != null) {
            return Collections.unmodifiableMap(this.states);
        }
        return Collections.emptyMap();
    }

    private SortedMap<String, SubscriptionStatus> createStateList(List<Subscription> subscriptions) {
        TreeMap<String, SubscriptionStatus> states = new TreeMap<String, SubscriptionStatus>(new Comparator<String>(){

            @Override
            public int compare(String k1, String k2) {
                SubscriptionType t1 = null;
                SubscriptionType t2 = null;
                if (StringUtils.isNotBlank((String)k1)) {
                    t1 = SubscriptionType.getByRelationshipId(k1);
                }
                if (StringUtils.isNotBlank((String)k2)) {
                    t2 = SubscriptionType.getByRelationshipId(k2);
                }
                if (t1 != null && t2 != null) {
                    return t1.compareTo(t2);
                }
                return 0;
            }
        });
        for (Subscription subscription : subscriptions) {
            states.put(subscription.getSubscriptionType(), new SubscriptionStatusImpl(subscription.getSubscriptionType(), true));
            this.isSubscribed = true;
        }
        for (int i = 0; i < subscriptionTypes.length; ++i) {
            if (states.containsKey(subscriptionTypes[i])) continue;
            states.put(subscriptionTypes[i], new SubscriptionStatusImpl(subscriptionTypes[i], false));
        }
        return states;
    }

    @Override
    public boolean isSubscribed() {
        if (this.states == null) {
            this.getStates();
        }
        return this.isSubscribed;
    }

    @Override
    public boolean isUserLoggedIn() {
        return this.isUserLoggedIn;
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        for (SubscriptionType type : SubscriptionType.values()) {
            list.add(type.getRelationshipId());
        }
        String[] buf = new String[list.size()];
        subscriptionTypes = list.toArray(buf);
    }

    static class SubscriptionStatusImpl
    implements SubscriptionStatus {
        private final String type;
        private final boolean state;

        public SubscriptionStatusImpl(String type, boolean state) {
            this.type = type;
            this.state = state;
        }

        @Override
        public String getDisplayName() {
            return SubscriptionType.getByRelationshipId(this.type).getDisplayName();
        }

        @Override
        public boolean isSelected() {
            return this.state;
        }
    }
}

