/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.subscriptions.endpoint;

import com.adobe.cq.social.graph.SocialGraph;
import com.adobe.cq.social.graph.Vertex;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.cq.social.subscriptions.api.SubscriptionManager;
import com.adobe.cq.social.subscriptions.api.SubscriptionType;
import com.adobe.cq.social.subscriptions.client.api.SubscriptionCollection;
import com.adobe.cq.social.subscriptions.client.api.SubscriptionCollectionComponentFactory;
import com.adobe.cq.social.subscriptions.endpoint.SubscriptionCollectionOperationExtension;
import com.adobe.cq.social.subscriptions.endpoint.SubscriptionCollectionOperations;
import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.Relationship;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractSubscriptionCollectionOperationService<T extends SubscriptionCollectionOperationExtension, U extends SubscriptionCollectionOperationExtension.SubscriptionCollectionOperation>
extends AbstractOperationService<T, U, SubscriptionCollection>
implements SubscriptionCollectionOperations {
    @Reference
    SubscriptionManager subscriptionManager;
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;
    String subscribedId;
    String userId;
    String[] types;
    Boolean[] states;
    ResourceResolver resolver;
    private static List<String> PARAM_LIST = Arrays.asList("subscribedId", "userId", "types", "states", ":operation");
    private static Logger LOG = LoggerFactory.getLogger(AbstractSubscriptionCollectionOperationService.class);

    @Override
    public SocialComponent update(SlingHttpServletRequest request) throws OperationException {
        boolean userIsLoggedIn;
        this.resolver = request.getResource().getResourceResolver();
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        this.userId = this.resolver.getUserID();
        boolean bl = userIsLoggedIn = !StringUtils.isEmpty((String)this.userId) && !this.userId.equalsIgnoreCase("Anonymous");
        if (!userIsLoggedIn) {
            throw new OperationException("User needs to login", 403);
        }
        this.subscribedId = request.getParameter("subscribedId");
        if (StringUtils.isEmpty((String)this.subscribedId)) {
            throw new OperationException("Invalid 'subscribedId' value", 400);
        }
        this.types = request.getParameterValues("types");
        if (this.types == null || this.types.length == 0) {
            throw new OperationException("Invalid 'types' value", 400);
        }
        for (String type : this.types) {
            SubscriptionType subType = SubscriptionType.getByRelationshipId(type);
            if (subType != null) continue;
            throw new OperationException("Invalid 'types: " + type, 400);
        }
        String[] reqStates = request.getParameterValues("states");
        if (reqStates == null || reqStates.length != this.types.length) {
            throw new OperationException("Invalid 'states' value", 400);
        }
        this.states = new Boolean[reqStates.length];
        for (int i = 0; i < reqStates.length; ++i) {
            this.states[i] = Boolean.valueOf(reqStates[i]);
        }
        requestParams.put("subscribedId", this.subscribedId);
        requestParams.put("userId", this.userId);
        requestParams.put("types", this.types);
        requestParams.put("states", this.states);
        RequestParameterMap params = request.getRequestParameterMap();
        for (String key : params.keySet()) {
            if (PARAM_LIST.contains(key)) continue;
            String[] values = request.getParameterValues(key);
            if (values.length == 1) {
                requestParams.put(key, values[0]);
                continue;
            }
            requestParams.put(key, values);
        }
        U operation = this.getUpdateOperation();
        Session session = this.resolver.adaptTo(Session.class);
        this.performBeforeActions(operation, session, request.getResource(), requestParams);
        SocialGraph graph = this.resolver.adaptTo(SocialGraph.class);
        Vertex userNode = graph.getVertex(this.userId);
        Vertex subscribedNode = graph.getVertex(this.subscribedId);
        boolean isFollowedUser = this.subscribedId.startsWith("/social/authors/") || !this.subscribedId.startsWith("/");
        String relType = isFollowedUser ? "USER" : "RESOURCE";
        ArrayList<Relationship> subscriptions = new ArrayList<Relationship>();
        if (userNode != null && subscribedNode != null) {
            for (int i = 0; i < this.types.length; ++i) {
                Relationship rel = userNode.getRelationship(Direction.OUTGOING, subscribedNode, this.types[i]);
                if (rel == null && this.states[i].booleanValue()) {
                    rel = userNode.createRelationshipTo(subscribedNode, this.types[i], relType);
                    subscriptions.add(rel);
                    LOG.info("Adding relationship user:{} node:{} types:{}", new Object[]{userNode.getId(), subscribedNode.getId(), this.types[i]});
                    continue;
                }
                if (rel != null && !this.states[i].booleanValue()) {
                    rel.delete();
                    LOG.info("Remove relationship user:{}, endNode:{} type:{}", new Object[]{rel.getStartNode().getId(), rel.getEndNode().getId(), this.types[i]});
                    continue;
                }
                LOG.info("same state requestState:{} currentState:{} user:{} subscribed:{}", new Object[]{this.states[i], rel != null, userNode.getId(), subscribedNode.getId()});
                if (rel == null) continue;
                subscriptions.add(rel);
            }
        }
        graph.save();
        SocialComponent component = this.getSocialComponent(request, subscriptions);
        if (component != null) {
            try {
                if (LOG.isInfoEnabled()) {
                    StringBuffer logInfo = new StringBuffer("\nRequest States: [");
                    for (int i = 0; i < this.types.length; ++i) {
                        logInfo = logInfo.append(this.types[i]).append(":").append(this.states[i]).append(" ");
                    }
                    logInfo = logInfo.append("] Component:").append(component.toJSONString(true));
                    LOG.info(logInfo.toString());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.performAfterActions(operation, session, (SubscriptionCollection)component, requestParams);
        } else {
            LOG.warn("Failed to obtain the social component");
        }
        return component;
    }

    private SocialComponent getSocialComponent(SlingHttpServletRequest request, List<Relationship> subscriptions) {
        SocialComponentFactory factory;
        Resource resource = request.getResource();
        if (ResourceUtil.isNonExistingResource(resource)) {
            resource = new SyntheticResource(resource.getResourceResolver(), "social/subscriptions/components/hbs/subscriptions", this.getResourceType());
        }
        if ((factory = this.componentFactoryManager.getSocialComponentFactory(resource)) instanceof SubscriptionCollectionComponentFactory) {
            return ((SubscriptionCollectionComponentFactory)factory).getSocialComponent(resource, request, subscriptions);
        }
        return factory != null ? factory.getSocialComponent(resource, request) : null;
    }

    protected String getResourceType() {
        return "social/subscriptions/components/hbs/subscriptions";
    }

    protected abstract U getUpdateOperation();

    protected abstract ResourceResolver getPrivilegedResolver() throws LoginException;

    protected void bindSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    protected void unbindSubscriptionManager(SubscriptionManager subscriptionManager) {
        if (this.subscriptionManager == subscriptionManager) {
            this.subscriptionManager = null;
        }
    }

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }
}

