/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.tally.client.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.User;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.tally.client.api.Response;
import com.adobe.cq.social.tally.client.api.ResponseValue;
import com.adobe.cq.social.tally.client.api.TallyResponseSocialComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public abstract class AbstractTallyResponse
extends BaseSocialComponent
implements TallyResponseSocialComponent {
    private final Response<? extends ResponseValue> response;
    protected final Resource resource;

    public AbstractTallyResponse(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.resource = resource;
        this.response = this.getResponseFromResource();
    }

    protected ResponseValue getResponseValue(final String response) {
        return new ResponseValue(){

            @Override
            public String getResponseValue() {
                return response;
            }
        };
    }

    public AbstractTallyResponse(Response<? extends ResponseValue> response, ClientUtilities clientUtils) {
        super(response.getResource(), clientUtils);
        this.response = response;
        this.resource = response.getResource();
    }

    @Override
    public User getAuthor() {
        if (StringUtils.isEmpty((String)this.response.getUserId())) {
            return null;
        }
        return this.clientUtils.getUser(this.response.getUserId(), this.resource.getResourceResolver());
    }

    @Override
    public String getResponse() {
        return this.response.getResponseValue() == null ? null : this.response.getResponseValue().getResponseValue();
    }

    private Response<ResponseValue> getResponseFromResource() {
        final ValueMap vm = this.resource.adaptTo(ValueMap.class);
        return new Response(){

            @Override
            public String getUserId() {
                return vm.get("userIdentifier", "");
            }

            public ResponseValue getResponseValue() {
                return AbstractTallyResponse.this.getResponseValue(vm.get("response", ""));
            }

            @Override
            public Long getTimeStamp() {
                return vm.get("timestamp", 0L);
            }

            @Override
            public Resource getResource() {
                return AbstractTallyResponse.this.resource;
            }
        };
    }
}

