/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.tally.client.api;

import com.adobe.cq.social.scf.core.SocialEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.event.Event;

public class TallyEvent
extends SocialEvent<TallyActions> {
    private static final long serialVersionUID = 1L;
    protected static final String PARENT_PATH = "PARENT_PATH";
    public static final String TALLY_TOPIC_PREFIX = "tally/";

    public TallyEvent(String tallyPath, String userId, String parentPath, String tallyType, TallyActions action) {
        this(tallyPath, userId, parentPath, tallyType, action, null, null);
    }

    public TallyEvent(String tallyPath, String userId, final String parentPath, String tallyType, TallyActions action, Map<String, Object> objectExtraProps, Map<String, Object> targetExtraProps) {
        super(TALLY_TOPIC_PREFIX + tallyType, tallyPath, userId, action.setType(tallyType), new SocialEvent.BaseEventObject(tallyPath, "review", objectExtraProps), new SocialEvent.BaseEventObject(parentPath, "article", targetExtraProps), (Map<String, Object>)new HashMap<String, Object>(1){
            private static final long serialVersionUID = 1L;
            {
                super(x0);
                if (parentPath != null) {
                    this.put(TallyEvent.PARENT_PATH, parentPath);
                }
            }
        });
    }

    private TallyEvent(Event event) {
        super(event);
    }

    public String getParentPath() {
        return (String)this.getProperty(PARENT_PATH);
    }

    public static TallyEvent fromEvent(Event event) {
        if (StringUtils.startsWith((CharSequence)event.getTopic(), (CharSequence)"com/adobe/cq/social/tally/")) {
            return new TallyEvent(event);
        }
        return null;
    }

    public String getTallyType() {
        return this.getTopic().substring(this.getTopic().lastIndexOf("/") + 1);
    }

    public static enum TallyActions implements SocialEvent.SocialActions
    {
        SET_RESPONSE,
        UNSET_RESPONSE;

        String type;

        TallyActions setType(String type) {
            this.type = type.toLowerCase();
            return this;
        }

        @Override
        public String getVerb() {
            switch (this) {
                case SET_RESPONSE: {
                    return "add " + this.type;
                }
                case UNSET_RESPONSE: {
                    return "remove " + this.type;
                }
            }
            throw new IllegalArgumentException("Unsupported action");
        }
    }
}

