/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.translation;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.translation.TranslationResults;
import com.adobe.cq.social.translation.TranslationUtil;
import com.adobe.cq.social.translation.TranslationVariables;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.TranslationSaveQueue;
import com.adobe.cq.social.ugcbase.TranslationUpdate;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationManager;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationSCFUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TranslationSCFUtil.class);
    private static final String JCR_DESCRIPTION_PROP = "jcr:description";
    private static final String JCR_TITLE_PROP = "jcr:title";
    private static final String NO_CACHING = "no_caching";
    private static final String CACHE_WHEN_CALL = "cache_when_call";
    public static final String REFERER = "referer";
    private static final String BROWSER_LANGUAGE = "Accept-Language";
    private static final String COMMENT_MODIFIED = "cq:lastModified";
    private static final String PERSIST_TRANSLATION = "persistTranslation";
    private static final String POST_EDITED = "postEdited";
    private static final String TRANSLATION_NODE = "translation";

    public static void updateEditTranslation(Resource resource, Session session, String userID, String requestURI, String requestReferer, String requestBrowserLang, String modifiedTranslation, TranslationSaveQueue translationSaveQueue) {
        LOG.trace("Inside updateEditTranslation: ");
        String srcLanguage = TranslationUtil.getUGCLanguage(resource);
        String caching = null;
        String targetLanguage = null;
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        if (context == null) {
            LOG.error("updateEditTranslation: CommunityContext is null.");
            return;
        }
        caching = TranslationUtil.getCaching(resource);
        targetLanguage = TranslationUtil.getTranslationTargetLanguage(resource.getResourceResolver(), resource, userID, requestURI, requestReferer, requestBrowserLang);
        if (LOG.isDebugEnabled()) {
            LOG.debug("resourcePath: {}", (Object)resource.getPath());
            LOG.debug("userID: {}", (Object)userID);
            LOG.debug("requestURI: {}", (Object)requestURI);
            LOG.debug("requestReferer: {}", (Object)requestReferer);
            LOG.debug("requestBrowserLang: {}", (Object)requestBrowserLang);
            LOG.debug("srcLanguage: {}", (Object)srcLanguage);
            LOG.debug("targetLanguage: {}", (Object)targetLanguage);
            LOG.debug("modifiedTranslation: {}", (Object)modifiedTranslation);
        }
        int rating = 6;
        SocialUtils socialUtils = resource.getResourceResolver().adaptTo(SocialUtils.class);
        TranslationManager tm = socialUtils.getTranslationManager();
        if (tm != null) {
            HashMap<String, String> translation = new HashMap<String, String>();
            ValueMap resourceValueMap = resource.adaptTo(ValueMap.class);
            String originText = resourceValueMap.get(JCR_DESCRIPTION_PROP, "");
            boolean isTranslationModified = TranslationUtil.storeModifiedTranslation(resource, tm, originText, srcLanguage, targetLanguage, modifiedTranslation, TranslationConstants.ContentType.HTML, userID, 6);
            translation.put(JCR_DESCRIPTION_PROP, modifiedTranslation);
            translation.put(POST_EDITED, "true");
            if (!NO_CACHING.equals(caching)) {
                TranslationUpdate translationUpdate = new TranslationUpdate(resource.getPath(), targetLanguage, translation);
                translationSaveQueue.getUpdateQueue().add(translationUpdate);
                LOG.trace("Translation added to update queue");
                translationSaveQueue.registerUpdate();
            }
        }
    }

    public static TranslationResults getTranslationSCF(Resource resource, ClientUtilities clientUtils) {
        LOG.trace("Inside getTranslationSCF: ");
        boolean isSiteForum = false;
        String caching = null;
        String targetLanguage = null;
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        if (context == null) {
            LOG.error("getTranslationSCF: CommunityContext is null.");
            return null;
        }
        if (!TranslationUtil.doDisplayTranslation(resource.getResourceResolver(), resource, clientUtils)) {
            return null;
        }
        caching = TranslationUtil.getCaching(resource);
        targetLanguage = TranslationUtil.getTranslationTargetLanguage(resource.getResourceResolver(), resource, clientUtils.getAuthorizedUserId(), clientUtils.getRequest().getRequestURI(), clientUtils.getRequest().getHeader(REFERER), clientUtils.getRequest().getHeader(BROWSER_LANGUAGE), clientUtils);
        return TranslationSCFUtil.getTranslationResults(resource, targetLanguage, caching, false, clientUtils);
    }

    private static TranslationResults getTranslationResults(Resource commentResource, String toLanguage, String caching, boolean isSiteForum, ClientUtilities clientUtils) {
        TranslationResults translationResults = null;
        HashMap<String, String> translation = new HashMap<String, String>();
        boolean isTranslationCached = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("commentResourcePath: {}", (Object)commentResource.getPath());
            LOG.debug("toLanguage: {}", (Object)toLanguage);
            LOG.debug("caching: {}", (Object)caching);
            LOG.debug("isSiteForum: {}", (Object)isSiteForum);
        }
        if (toLanguage != null && !"".equals(toLanguage)) {
            Resource transResource = commentResource.getChild("translation/" + toLanguage);
            if (transResource != null) {
                Object translationDateObject;
                boolean bEditComment = false;
                ValueMap resourceProperties = commentResource.adaptTo(ValueMap.class);
                ValueMap translationProps = transResource.adaptTo(ValueMap.class);
                Date commentModifiedDate = null;
                Date translationDate = null;
                Object commentModifiedObject = resourceProperties.get(COMMENT_MODIFIED, null);
                if (commentModifiedObject != null) {
                    if (commentModifiedObject instanceof Calendar) {
                        Calendar commentModifiedCalendar = commentModifiedObject;
                        if (commentModifiedCalendar != null) {
                            commentModifiedDate = commentModifiedCalendar.getTime();
                        }
                    } else if (commentModifiedObject instanceof Date) {
                        commentModifiedDate = commentModifiedObject;
                    }
                }
                if ((translationDateObject = translationProps.get("translationDate", null)) != null) {
                    if (translationDateObject instanceof GregorianCalendar) {
                        GregorianCalendar translationDateCalendar = translationDateObject;
                        if (translationDateCalendar != null) {
                            translationDate = translationDateCalendar.getTime();
                        }
                    } else if (translationDateObject instanceof Date) {
                        translationDate = translationDateObject;
                    }
                }
                if (translationDate != null) {
                    if (commentModifiedDate != null) {
                        bEditComment = commentModifiedDate.after(translationDate);
                        LOG.debug("getTranslationResults: Comment has been modified - " + bEditComment);
                    }
                    int cachingDuration = isSiteForum ? 0 : TranslationVariables.getCachingDuration();
                    if (!bEditComment && !TranslationSCFUtil.isTranslationExpired(translationDate, cachingDuration)) {
                        LOG.debug("getTranslationResults: Getting translation from cache. ");
                        String strTranslationResult = translationProps.get(JCR_DESCRIPTION_PROP, (String)null);
                        translation.put(JCR_DESCRIPTION_PROP, strTranslationResult);
                        translation.put(JCR_TITLE_PROP, translationProps.get(JCR_TITLE_PROP, (String)null));
                        isTranslationCached = true;
                        translationResults = new TranslationResults("", translation, TranslationSCFUtil.getTranslationAttribution(commentResource, clientUtils), TranslationVariables.getDisplay());
                    }
                }
            }
            if (!isTranslationCached) {
                LOG.debug("getTranslation: Getting fresh translation. ");
                SocialUtils socialUtils = clientUtils.getSocialUtils();
                TranslationManager tm = socialUtils.getTranslationManager();
                String srcLanguage = TranslationUtil.getUGCLanguage(commentResource);
                String[] properties = new String[]{JCR_TITLE_PROP, JCR_DESCRIPTION_PROP};
                if (tm != null) {
                    translationResults = TranslationUtil.getTranslation(srcLanguage, toLanguage, properties, commentResource, tm);
                    if (translationResults != null) {
                        translationResults.setDisplay(TranslationVariables.getDisplay());
                        translationResults.setAttribution(TranslationSCFUtil.getTranslationAttribution(commentResource, clientUtils));
                    }
                    if (!NO_CACHING.equals(caching) && "Success".equalsIgnoreCase(translationResults.getStatus())) {
                        TranslationUpdate translationUpdate = new TranslationUpdate(commentResource.getPath(), toLanguage, translationResults.getTranslation());
                        TranslationSaveQueue translationSaveQueue = socialUtils.getTranslationSaveQueue();
                        if (translationSaveQueue != null) {
                            translationSaveQueue.getUpdateQueue().add(translationUpdate);
                            LOG.trace("getTranslationResults: Translation added to update queue");
                            translationSaveQueue.registerUpdate();
                        } else {
                            LOG.error("TranslationSCFUtil: translationSaveQueue is null.");
                        }
                    }
                }
            }
        }
        return translationResults;
    }

    public static String getTranslationAttribution(Resource resource, ClientUtilities clientUtils) {
        String attribution = null;
        SocialUtils socialUtils = clientUtils.getSocialUtils();
        TranslationManager tm = socialUtils.getTranslationManager();
        if (TranslationVariables.isEnableAttribution()) {
            try {
                if (tm != null) {
                    attribution = tm.createTranslationService(TranslationUtil.getNonUgcResource(resource)).getTranslationServiceInfo().getTranslationServiceAttribution();
                }
            }
            catch (TranslationException ex) {
                LOG.trace("Error getting translation service attribution", (Throwable)ex);
            }
        }
        return attribution;
    }

    private static boolean isTranslationExpired(Date translationDate, int cachingMonths) {
        LOG.trace("In Function: isTranslationExpired");
        boolean retVal = false;
        if (translationDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1 * cachingMonths);
            boolean isTranslationCacheExpired = translationDate.before(calendar.getTime());
            retVal = cachingMonths > 0 && isTranslationCacheExpired;
        }
        return retVal;
    }

    public static boolean isSmartRenderingOn(Resource resource, ClientUtilities clientUtils) {
        boolean smartRenderingRetVal = false;
        String userId = clientUtils.getAuthorizedUserId();
        String PN_PROFILE_SMART_RENDERING = "smartRendering";
        String strProfile = "profile";
        boolean enabledUserSmartRendering = false;
        if (clientUtils != null) {
            try {
                String[] propertyNames;
                UserProperties userProperties = clientUtils.getUserProperties(userId, "profile");
                if (userProperties != null && (propertyNames = userProperties.getPropertyNames()) != null) {
                    for (String property : propertyNames) {
                        if (!property.equalsIgnoreCase("smartRendering")) continue;
                        enabledUserSmartRendering = true;
                        String propertyValue = userProperties.getProperty("smartRendering", null, String.class);
                        if (propertyValue == null || "".equals(propertyValue) || !propertyValue.equalsIgnoreCase("on")) break;
                        smartRenderingRetVal = true;
                        break;
                    }
                }
                if (!enabledUserSmartRendering) {
                    smartRenderingRetVal = TranslationVariables.isEnableSmartRendering();
                }
            }
            catch (RepositoryException ex) {
                LOG.error("TranslationSCFUtils.isSmartRenderingOn: " + ex.getMessage());
                return false;
            }
        }
        return smartRenderingRetVal;
    }
}

