/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.translation.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.cq.social.translation.api.SiteTranslationLanguage;
import com.adobe.cq.social.translation.api.SiteTranslationLanguageCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;

public class AbstractSiteTranslationLanguageCollectionImpl
extends BaseSocialComponent
implements SiteTranslationLanguageCollection {
    protected List<SiteTranslationLanguage> availableLanguages = new ArrayList<SiteTranslationLanguage>();

    public AbstractSiteTranslationLanguageCollectionImpl(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.init(resource, clientUtils);
    }

    protected void init(Resource resource, ClientUtilities clientUtilities) {
        this.getLanguages(this.getRootPath(), clientUtilities);
    }

    protected String getRootPath() {
        return "/etc/social/config/languageOpts/languageMapping";
    }

    protected void getLanguages(String path, ClientUtilities clientUtilities) {
        Resource resource;
        if (!StringUtils.isEmpty((CharSequence)path) && (resource = this.resource.getResourceResolver().getResource(path)) != null) {
            Iterator<Resource> resourceIterator = resource.listChildren();
            SocialComponentFactory translationLanguageSocialFactory = clientUtilities.getSocialComponentFactoryManager().getSocialComponentFactory(this.getTranslationLanguageResourceType());
            String languageResourceType = this.getTranslationLanguageResourceType();
            while (resourceIterator.hasNext()) {
                SiteTranslationLanguage language;
                Resource child = resourceIterator.next();
                if (!child.isResourceType(languageResourceType) || (language = (SiteTranslationLanguage)translationLanguageSocialFactory.getSocialComponent(child)) == null) continue;
                this.availableLanguages.add(language);
            }
        }
    }

    protected String getTranslationLanguageResourceType() {
        return "social/console/components/hbs/translationlanguages/language";
    }

    @Override
    public int getTotalSize() {
        return this.availableLanguages.size();
    }

    public List getItems() {
        return this.availableLanguages;
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
    }
}

