/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugc.api;

import com.adobe.cq.social.ugc.api.ComparisonType;
import com.adobe.cq.social.ugc.api.Constraint;
import com.adobe.cq.social.ugc.api.ConstraintGroup;
import com.adobe.cq.social.ugc.api.ConstraintVisitor;
import com.adobe.cq.social.ugc.api.DefaultConstraintVisitor;
import com.adobe.cq.social.ugc.api.FullTextConstraint;
import com.adobe.cq.social.ugc.api.Operator;
import com.adobe.cq.social.ugc.api.PathConstraint;
import com.adobe.cq.social.ugc.api.RangeConstraint;
import com.adobe.cq.social.ugc.api.SetConstraint;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugc.api.UgcSort;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UgcFilterQueryWriter {
    private static final String SELECT = "SELECT";
    private static final char SELECT_ALL = '*';
    private static final String FROM = "FROM";
    private static final String WHERE = "WHERE";
    private static final String ORDER_BY = "ORDER BY";
    private static final String CONTAINS = "CONTAINS";
    private static final String LIKE = "LIKE";
    private static final String IS = "IS";
    private static final String NULL = "NULL";
    private static final String IS_DESCENDANT_NODE = "ISDESCENDANTNODE";
    private static final String IS_SAME_NODE = "ISSAMENODE";
    private static final String IS_CHILD_NODE = "ISCHILDNODE";
    private static final String ASCENDING = "ASC";
    private static final String DESCENDING = "DESC";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String NOT = "NOT";
    private static final String AS = "AS";
    private static final char OPEN_FROM = '[';
    private static final char CLOSE_FROM = ']';
    private static final char SPACING = ' ';
    private static final char OPEN_GROUP = '(';
    private static final char CLOSE_GROUP = ')';
    private static final char OPEN_ORDER_NAME = '[';
    private static final char CLOSE_ORDER_NAME = ']';
    private static final char ORDERING_SEPARATOR = ',';
    private static final char VARIABLE_IDENTIFIER = '$';
    private static final char OPEN_SINGLE_QUOTE = '\'';
    private static final char CLOSE_SINGLE_QUOTE = '\'';
    private static final char OPEN_FUNCTION = '(';
    private static final char CLOSE_FUNCTION = ')';
    private static final char FUNCTION_PARAM_SEPARATOR = ',';
    private static final char SELECTOR_NAME = 'c';
    private static final char SELECTOR_SEPARATOR = '.';
    private static final char OPEN_FIELD_NAME = '[';
    private static final char CLOSE_FIELD_NAME = ']';
    private static final char EQUAL = '=';
    private static final char LESS_THAN = '<';
    private static final char GREATER_THAN = '>';
    private static final String LESS_THAN_OR_EQUAL = "<=";
    private static final String GREATER_THAN_OR_EQUAL = ">=";
    private static final String NOT_EQUAL = "<>";

    public String write(UgcFilter ugcFilter) {
        StringBuffer query = new StringBuffer();
        query.append(SELECT);
        query.append(' ');
        query.append('*');
        query.append(' ');
        query.append(FROM);
        query.append(' ');
        query.append('[');
        query.append(ugcFilter.getContentType());
        query.append(']');
        query.append(' ');
        query.append(AS);
        query.append(' ');
        query.append('c');
        query.append(' ');
        query.append(WHERE);
        if (ugcFilter.hasConstraints()) {
            query.append(' ');
            QueryWriterConstraintVisitor constraintVisitor = ugcFilter.hasVariables() ? new QueryWriterConstraintVisitor(query, ugcFilter.getVariables()) : new QueryWriterConstraintVisitor(query);
            Collection<Constraint> constraints = ugcFilter.getConstraints();
            for (Constraint constraint : constraints) {
                constraint.accept(constraintVisitor);
            }
        }
        this.handleSort(query, ugcFilter);
        return query.toString();
    }

    private void handleSort(StringBuffer query, UgcFilter ugcFilter) {
        if (ugcFilter.isSorted()) {
            query.append(' ');
            query.append(ORDER_BY);
            List<UgcSort> sortOrder = ugcFilter.getSortOrder();
            boolean first = true;
            for (UgcSort sort : sortOrder) {
                if (first) {
                    first = false;
                } else {
                    query.append(',');
                }
                query.append(' ');
                String propertyName = sort.getPropertyName();
                query.append('[');
                query.append(propertyName);
                query.append(']');
                query.append(' ');
                if (sort.isAscending()) {
                    query.append(ASCENDING);
                    continue;
                }
                query.append(DESCENDING);
            }
        }
    }

    private static class QueryWriterConstraintVisitor
    extends DefaultConstraintVisitor
    implements ConstraintVisitor {
        private boolean first = true;
        private final StringBuffer query;
        private Map<String, Object> variableMap;

        public QueryWriterConstraintVisitor(StringBuffer query) {
            this.query = query;
        }

        public QueryWriterConstraintVisitor(StringBuffer query, Map<String, Object> variables) {
            this.query = query;
            this.variableMap = variables;
        }

        public void visitSetConstraint(SetConstraint setConstraint) {
            this.writeOperator(setConstraint);
            this.writeNegation(setConstraint);
            if (setConstraint.size() > 1) {
                this.query.append('(');
            }
            for (int i = 0; i < setConstraint.size(); ++i) {
                if (i > 0) {
                    this.query.append(' ');
                    this.query.append(UgcFilterQueryWriter.OR);
                    this.query.append(' ');
                }
                this.appendSelector(this.query, setConstraint.getPropertyName());
                this.query.append(' ');
                this.query.append('=');
                this.query.append(' ');
                this.writeValue(this.query, setConstraint.get(i), "");
            }
            if (setConstraint.size() > 1) {
                this.query.append(')');
            }
        }

        @Override
        public void visitPathConstraint(PathConstraint pathConstraint) {
            this.writeOperator(pathConstraint);
            this.writeNegation(pathConstraint);
            String path = pathConstraint.getPath();
            switch (pathConstraint.getPathConstraintType()) {
                case IsSameNode: {
                    this.query.append(UgcFilterQueryWriter.IS_SAME_NODE);
                    break;
                }
                case IsDescendantNode: {
                    this.query.append(UgcFilterQueryWriter.IS_DESCENDANT_NODE);
                    break;
                }
                case IsChildNode: {
                    this.query.append(UgcFilterQueryWriter.IS_CHILD_NODE);
                    break;
                }
                default: {
                    throw new RuntimeException(pathConstraint.getPathConstraintType().name() + " is not supported");
                }
            }
            this.query.append('(');
            this.query.append('c');
            this.query.append(',');
            this.query.append(' ');
            this.query.append('\'');
            this.query.append(path.replace("'", "''"));
            this.query.append('\'');
            this.query.append(')');
        }

        public void visitValueConstraint(ValueConstraint valueConstraint) {
            this.writeOperator(valueConstraint);
            if (ComparisonType.NotEquals == valueConstraint.getComparison()) {
                this.query.append('(');
                this.query.append(UgcFilterQueryWriter.NOT);
                this.query.append(' ');
                this.query.append('(');
            } else {
                this.writeNegation(valueConstraint);
            }
            String name = valueConstraint.getPropertyName();
            Object value = valueConstraint.getValue();
            this.appendSelector(this.query, name);
            this.query.append(' ');
            ComparisonType comparisonType = valueConstraint.getComparison();
            Object v = value;
            if (value instanceof String) {
                v = this.fetchVariable((String)value);
            }
            switch (comparisonType) {
                case Equals: {
                    if (v == null) {
                        this.query.append(UgcFilterQueryWriter.IS);
                        break;
                    }
                    this.query.append('=');
                    break;
                }
                case NotEquals: {
                    if (v == null) {
                        this.query.append(UgcFilterQueryWriter.IS);
                        break;
                    }
                    this.query.append('=');
                    break;
                }
                case GreaterThan: {
                    this.query.append('>');
                    break;
                }
                case GreaterThanOrEqualTo: {
                    this.query.append(UgcFilterQueryWriter.GREATER_THAN_OR_EQUAL);
                    break;
                }
                case LessThan: {
                    this.query.append('<');
                    break;
                }
                case LessThanOrEqualTo: {
                    this.query.append(UgcFilterQueryWriter.LESS_THAN_OR_EQUAL);
                    break;
                }
                case BeginsWith: {
                    this.query.append(UgcFilterQueryWriter.LIKE);
                    break;
                }
                default: {
                    throw new RuntimeException("ComparisonType " + comparisonType.name() + " is not supported");
                }
            }
            this.query.append(' ');
            if (v == null) {
                this.query.append((String)null);
            } else {
                this.writeValue(this.query, value, ComparisonType.BeginsWith == valueConstraint.getComparison() ? "%" : "");
            }
            if (ComparisonType.NotEquals == valueConstraint.getComparison()) {
                this.query.append(')');
                this.query.append(')');
            }
        }

        private void appendSelector(StringBuffer sb, String name) {
            sb.append('c');
            sb.append('.');
            sb.append('[');
            sb.append(name);
            sb.append(']');
        }

        @Override
        public void visitConstraintGroup(ConstraintGroup constraintGroup) {
            if (constraintGroup.hasConstraints()) {
                this.writeOperator(constraintGroup);
                this.writeNegation(constraintGroup);
                Collection<Constraint> constraints = constraintGroup.getConstraints();
                if (constraints.size() > 1) {
                    this.query.append('(');
                }
                this.first = true;
                for (Constraint constraint : constraints) {
                    constraint.accept(this);
                }
                if (constraints.size() > 1) {
                    this.query.append(')');
                }
            }
        }

        public void visitRangeConstraint(RangeConstraint<?> rangeConstraint) {
            this.writeOperator(rangeConstraint);
            this.writeNegation(rangeConstraint);
            Object min = rangeConstraint.getMinValue();
            Object max = rangeConstraint.getMaxValue();
            String propertyName = rangeConstraint.getPropertyName();
            this.query.append('(');
            this.appendSelector(this.query, propertyName);
            this.query.append(' ');
            if (rangeConstraint.isInclusive()) {
                this.query.append(UgcFilterQueryWriter.GREATER_THAN_OR_EQUAL);
            } else {
                this.query.append('>');
            }
            this.query.append(' ');
            this.writeValue(this.query, min, "");
            this.query.append(' ');
            this.query.append(UgcFilterQueryWriter.AND);
            this.query.append(' ');
            this.appendSelector(this.query, propertyName);
            this.query.append(' ');
            if (rangeConstraint.isInclusive()) {
                this.query.append(UgcFilterQueryWriter.LESS_THAN_OR_EQUAL);
            } else {
                this.query.append('<');
            }
            this.query.append(' ');
            this.writeValue(this.query, max, "");
            this.query.append(')');
        }

        @Override
        public void visitFullTextConstraint(FullTextConstraint fullTextConstraint) {
            this.writeOperator(fullTextConstraint);
            this.writeNegation(fullTextConstraint);
            this.query.append(UgcFilterQueryWriter.CONTAINS);
            this.query.append('(');
            if (fullTextConstraint.definesPropertiesToInclude()) {
                boolean first = true;
                for (String fieldName : fullTextConstraint.getIncludedProperties()) {
                    if (first) {
                        first = false;
                    } else {
                        this.query.append(',');
                        this.query.append(' ');
                    }
                    this.appendSelector(this.query, fieldName);
                }
            } else {
                this.query.append('c');
                this.query.append('.');
                this.query.append('*');
            }
            this.query.append(',');
            this.query.append(' ');
            this.writeValue(this.query, fullTextConstraint.getExpression(), "");
            this.query.append(')');
        }

        private Object fetchVariable(String valueString) {
            String varName;
            if ('$' == valueString.charAt(0) && this.variableMap != null && this.variableMap.containsKey(varName = valueString.substring(1))) {
                return this.variableMap.get(varName);
            }
            return valueString;
        }

        protected void writeValue(StringBuffer query, Object value, String suffix) {
            String valueString = value.toString();
            Object varValue = this.fetchVariable(valueString);
            if (varValue != null) {
                if (varValue instanceof Integer || varValue instanceof Long) {
                    query.append(varValue);
                } else {
                    query.append('\'');
                    query.append(varValue + suffix);
                    query.append('\'');
                }
            } else if (value instanceof Integer || value instanceof Long) {
                query.append(valueString);
            } else {
                query.append('\'');
                query.append(valueString);
                query.append('\'');
            }
        }

        protected void writeNegation(Constraint constraint) {
            if (constraint.isNegated()) {
                this.query.append(UgcFilterQueryWriter.NOT);
                this.query.append(' ');
            }
        }

        protected void writeOperator(Constraint constraint) {
            if (this.first) {
                this.first = false;
            } else {
                this.query.append(' ');
                Operator operator = constraint.getOperator();
                switch (operator) {
                    case And: {
                        this.query.append(UgcFilterQueryWriter.AND);
                        break;
                    }
                    case Or: {
                        this.query.append(UgcFilterQueryWriter.OR);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Operator " + operator.name() + " is not supported");
                    }
                }
                this.query.append(' ');
            }
        }
    }
}

