/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugcbase.core;

import com.adobe.cq.social.srp.SocialResource;
import com.adobe.cq.social.srp.config.SRPConfigurationError;
import com.adobe.cq.social.srp.config.SRPConfigurationFactory;
import com.adobe.cq.social.srp.config.SocialResourceConfiguration;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.core.ConfigurationImpl;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.wcm.webservicesupport.Configuration;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.management.ServiceNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocialResourceUtils
implements BundleActivator {
    public static String GRAVATAR_PREFIX = "http://www.gravatar.com/avatar/";
    public static final String SRP_CONFIGURATION_ROOT = "/etc/socialconfig/srpc/";
    public static final String SRP_DEFAULT_CONFIG_PATH = "/etc/socialconfig/srpc/defaultconfiguration";
    private static final Logger LOG = LoggerFactory.getLogger(SocialResourceUtils.class);
    private static ServiceTracker tracker;

    private SocialResourceUtils() {
    }

    public static Boolean checkPermission(ResourceResolver resolver, String path, String action) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        try {
            Session userSession = resolver.adaptTo(Session.class);
            return userSession.hasPermission(path, action);
        }
        catch (RepositoryException e) {
            return SocialResourceUtils.checkPermission(resolver, StringUtils.substringBeforeLast((String)path, (String)"/"), action);
        }
    }

    @Deprecated
    public static Configuration getFirstCloudStorageConfig(ResourceResolver resolver) {
        SocialResourceConfiguration srConfig;
        ConfigurationImpl config;
        block7: {
            config = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("STATIC getDefaultStorageConfig called. Please use SocialUtils", new Throwable("getDefaultStorageConfig"));
            }
            Resource configResource = resolver.getResource(SRP_DEFAULT_CONFIG_PATH);
            srConfig = null;
            try {
                if (configResource == null) break block7;
                LOG.debug("config resource is: {}", (Object)configResource.getPath());
                try {
                    srConfig = SocialResourceUtils.getConfigFactory().createConfiguration(configResource);
                }
                catch (ServiceNotFoundException e) {
                    throw new SRPConfigurationError(e);
                }
            }
            catch (SRPConfigurationError e) {
                LOG.error("Could not build configuration: ", (Throwable)e);
            }
        }
        if (srConfig != null) {
            config = new ConfigurationImpl(srConfig);
        }
        if (srConfig != null) {
            LOG.debug("getFirstCloudStorageConfig asipath is: {} ", (Object)srConfig.getAsiPath());
        }
        return config;
    }

    public static UserProperties getUserProperties(ResourceResolver resolver, String userId) {
        UserProperties userProperties = null;
        UserPropertiesManager upm = resolver.adaptTo(UserPropertiesManager.class);
        if (null != upm && null != userId) {
            try {
                userProperties = upm.getUserProperties(userId, "profile");
            }
            catch (RepositoryException e) {
                LOG.warn("User cannot access the profile.", (Throwable)e);
            }
        }
        return userProperties;
    }

    public static String getAvatar(UserProperties userProperties, String absoluteDefaultAvatar, SocialUtils.AVATAR_SIZE size) {
        return SocialResourceUtils.buildAvatar(userProperties, absoluteDefaultAvatar, size.toString());
    }

    public static String getAvatar(UserProperties userProperties, String absoluteDefaultAvatar, String size) {
        return SocialResourceUtils.buildAvatar(userProperties, absoluteDefaultAvatar, size);
    }

    private static String buildAvatar(UserProperties userProperties, String absoluteDefaultAvatar, String size) {
        String avatar = "/etc/designs/default/images/social/avatar.png";
        int iSize = SocialUtils.AVATAR_SIZE.THIRTY_TWO.ordinal();
        try {
            iSize = Integer.parseInt(size);
        }
        catch (NumberFormatException e) {
            LOG.warn("Bad size passed in, defaulting size.", (Throwable)e);
        }
        if (userProperties != null) {
            try {
                Resource resource = userProperties.getResource("photos/primary/image");
                if (null != resource) {
                    avatar = resource.getPath() + ".prof.thumbnail." + Integer.toString(iSize) + ".png";
                } else {
                    String gravatar;
                    String primaryMail = userProperties.getProperty("email");
                    if (primaryMail != null && !"".equals(primaryMail) && (gravatar = SocialResourceUtils.getGravatar(primaryMail, absoluteDefaultAvatar)) != null) {
                        avatar = gravatar;
                    }
                }
            }
            catch (RepositoryException e) {
                LOG.error("getAvatar: error getting avatar: ", (Throwable)e);
            }
        }
        return avatar;
    }

    private static String getGravatar(String email, String absoluteDefaultAvatar) {
        if (StringUtils.isBlank((CharSequence)email) || StringUtils.isBlank((CharSequence)absoluteDefaultAvatar)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(GRAVATAR_PREFIX);
        sb.append(email);
        sb.append("?d=").append("mm");
        sb.append("&s=32");
        sb.append("&r=g");
        return sb.toString();
    }

    public static boolean isCloudUGC(String path) {
        return StringUtils.startsWith((CharSequence)path, (CharSequence)"/content/usergenerated/asi");
    }

    public static boolean isSocialResource(Resource res) {
        if (res instanceof SocialResource) {
            return true;
        }
        if (res instanceof ResourceWrapper) {
            return SocialResourceUtils.isSocialResource(((ResourceWrapper)res).getResource());
        }
        return false;
    }

    public static SocialResource getSocialResource(Resource res) {
        if (res == null) {
            return null;
        }
        if (res instanceof SocialResource) {
            return (SocialResource)res;
        }
        if (res instanceof ResourceWrapper) {
            return SocialResourceUtils.getSocialResource(((ResourceWrapper)res).getResource());
        }
        if (res instanceof NonExistingResource) {
            LOG.warn("Resource {} is a NonExistingResource, returning null", (Object)res);
            return null;
        }
        LOG.debug("Resource {} is unknown resource type, returning null", (Object)res);
        return null;
    }

    public static boolean causeByInvalidItemStateException(Exception e) {
        Throwable cause = e;
        do {
            if (!(cause instanceof InvalidItemStateException)) continue;
            return true;
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    private static SRPConfigurationFactory getConfigFactory() throws ServiceNotFoundException {
        Object factory = tracker.getService();
        if (factory != null && factory instanceof SRPConfigurationFactory) {
            return (SRPConfigurationFactory)factory;
        }
        throw new ServiceNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        Class<SocialResourceUtils> clazz = SocialResourceUtils.class;
        synchronized (SocialResourceUtils.class) {
            if (tracker == null) {
                tracker = new ServiceTracker(context, SRPConfigurationFactory.class.getName(), null);
                tracker.open();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(BundleContext context) throws Exception {
        Class<SocialResourceUtils> clazz = SocialResourceUtils.class;
        synchronized (SocialResourceUtils.class) {
            if (tracker != null) {
                tracker.close();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

