/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.api;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.community.CommunityAuthorizableCollection;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.cq.social.user.internal.CommunityAuthorizableManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommunityAuthorizableCollection
extends BaseSocialComponent
implements CommunityAuthorizableCollection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommunityAuthorizableCollection.class);
    private final CommunityContext context;
    private CommunityAuthorizableManager communityUserManager;
    Map<String, String[]> predicates = new HashMap<String, String[]>();
    private List<?> users;
    private final String type;
    private final String siteId;
    private final String groupId;
    private Boolean includeSubGroups = Boolean.FALSE;
    protected CollectionPagination pagination = CollectionPagination.DEFAULT_PAGINATION;
    protected CollectionSortedOrder sortOrder = CollectionSortedOrder.DEFAULT_ORDER;

    public AbstractCommunityAuthorizableCollection(Resource resource, ClientUtilities clientUtils, UserManager um, QueryRequestInfo queryRequestInfo) {
        super(resource, clientUtils);
        String includeSubGroupsParam;
        this.context = resource.adaptTo(CommunityContext.class);
        this.predicates = queryRequestInfo.getPredicates();
        ValueMap map = resource.getValueMap();
        boolean mapIncludeSubGroupsParam = map.get("includeSubGroups", Boolean.FALSE);
        SlingHttpServletRequest request = clientUtils.getRequest();
        if (request != null && StringUtils.isNotBlank((CharSequence)(includeSubGroupsParam = clientUtils.getRequest().getParameter("includeSubGroups")))) {
            this.includeSubGroups = Boolean.parseBoolean(includeSubGroupsParam);
        }
        this.includeSubGroups = this.includeSubGroups != false || mapIncludeSubGroupsParam;
        String groupIdTemp = clientUtils.getRequest().getParameter("groupId");
        if (StringUtils.isBlank((CharSequence)groupIdTemp) && null != map && null != map.get("groupId")) {
            groupIdTemp = (String)map.get("groupId");
        }
        this.groupId = groupIdTemp;
        this.initializeAuthorizableManager(this.context, clientUtils, resource.getResourceResolver(), um);
        String typeTemp = clientUtils.getRequest().getParameter("type");
        this.siteId = clientUtils.getRequest().getParameter("siteId");
        if (StringUtils.isBlank((CharSequence)typeTemp) && null != map && null != map.get("type")) {
            typeTemp = (String)map.get("type");
        }
        if (typeTemp != null && EnumUtils.isValidEnum(CommunityAuthorizableManager.Type.class, (String)typeTemp)) {
            LOG.error("Type was not specified correctly . Suggested options are users/groups/simpleusers for community users and groups and social users respectively. Please leave blank for both");
        }
        this.type = typeTemp;
        this.pagination = queryRequestInfo.getPagination();
        this.sortOrder = queryRequestInfo.getSortOrder();
    }

    protected CommunityAuthorizableManager getCommunityAuthorizableManager(CommunityContext context, ClientUtilities clientUtils, ResourceResolver resourceResolver, UserManager um) {
        return new CommunityAuthorizableManager(context, clientUtils, resourceResolver, this.getChildResourceType(), um);
    }

    @Override
    public int getTotalSize() {
        if (this.users == null) {
            this.initializeList();
        }
        return this.users.size() == 0 ? 0 : -1;
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.pagination = pagination;
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
        this.sortOrder = sortedOrder;
    }

    @Override
    public List<Object> getItems() {
        if (this.users == null) {
            this.initializeList();
        }
        return this.users;
    }

    private void initializeList() {
        this.users = this.getCommunityAuthorizables(this.pagination, this.sortOrder, this.predicates, this.type, this.siteId, this.groupId, this.includeSubGroups);
    }

    protected void initializeAuthorizableManager(CommunityContext context, ClientUtilities clientUtils, ResourceResolver resourceResolver, UserManager um) {
        this.communityUserManager = this.getCommunityAuthorizableManager(context, clientUtils, resourceResolver, um);
    }

    protected List<?> getCommunityAuthorizables(CollectionPagination pagination, CollectionSortedOrder sortOrder, Map<String, String[]> predicates, String type, String siteId, String groupId, boolean includeSubGroups) {
        if (!StringUtils.isEmpty((CharSequence)siteId)) {
            return this.communityUserManager.getCommunityUsers(pagination, sortOrder, predicates, type, siteId, groupId, includeSubGroups);
        }
        return this.communityUserManager.getCommunityUsers(pagination, sortOrder, predicates, type, groupId, includeSubGroups);
    }

    @Override
    public boolean isEditable() {
        ResourceResolver resolver = this.resource.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        try {
            String ACTION_ALL = "read,add_node,remove,set_property";
            return session.hasPermission("/content/sites/tenants" + this.context.getTenantId() + "/content.html", "read,add_node,remove,set_property");
        }
        catch (RepositoryException ex) {
            return false;
        }
    }

    protected abstract String getChildResourceType();
}

