/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.endpoints;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseQueryRequestInfo;
import com.adobe.cq.social.user.internal.HttpToPublisher;
import com.adobe.granite.security.user.UserPropertiesService;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, inherit=true)
public abstract class AbstractCommunitySimpleAuthorizableCollectionComponentFactory
extends AbstractSocialComponentFactory
implements SocialComponentFactory {
    @Reference
    private UserPropertiesService userPropertiesService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    @Reference
    protected HttpToPublisher httpPublish;
    @Reference
    protected SlingSettingsService settingsService;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommunitySimpleAuthorizableCollectionComponentFactory.class);
    public static String FROM_PUBLISHER = "fromPublisher";

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        throw new UnsupportedOperationException("getSocialComponent(Resource) is not supported.");
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        return this.getSocialComponent(resource, this.getClientUtilities(request), new BaseQueryRequestInfo(request, false));
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo requestInfo) {
        Map<String, String[]> predicates = requestInfo.getPredicates();
        boolean usePublish = predicates.get(FROM_PUBLISHER) != null ? StringUtils.equalsIgnoreCase((String)predicates.get(FROM_PUBLISHER)[0], (String)"true") : (resource != null && resource.adaptTo(ValueMap.class) != null ? StringUtils.equalsIgnoreCase((String)resource.adaptTo(ValueMap.class).get(FROM_PUBLISHER, "false"), (String)"true") : false);
        if (usePublish && this.isAuthorMode()) {
            if (this.httpPublish.isEnabled()) {
                return this.httpPublish.getFromPublisher(resource, requestInfo);
            }
            LOG.warn("User list operation is from Author because Tunnel service is no enabled.");
        }
        return this.getChildSocialComponent(resource, clientUtils, requestInfo);
    }

    protected abstract SocialComponent getChildSocialComponent(Resource var1, ClientUtilities var2, QueryRequestInfo var3);

    protected boolean isAuthorMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("author");
    }

    protected void bindUserPropertiesService(UserPropertiesService userPropertiesService) {
        this.userPropertiesService = userPropertiesService;
    }

    protected void unbindUserPropertiesService(UserPropertiesService userPropertiesService) {
        if (this.userPropertiesService == userPropertiesService) {
            this.userPropertiesService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindHttpPublish(HttpToPublisher httpToPublisher) {
        this.httpPublish = httpToPublisher;
    }

    protected void unbindHttpPublish(HttpToPublisher httpToPublisher) {
        if (this.httpPublish == httpToPublisher) {
            this.httpPublish = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }
}

