/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.endpoints;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.community.api.CommunityUserGroup;
import com.adobe.cq.social.console.utils.api.UserUtils;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.ClientUtilityFactory;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.community.CommunityUser;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.site.api.CommunitySite;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.user.endpoints.CommunityUserOperations;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.xss.XSSAPI;
import com.day.text.Text;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractCommunityUserOperationService<T extends OperationExtension, U extends Operation>
extends AbstractOperationService<T, U, CommunityUser>
implements CommunityUserOperations {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommunityUserOperationService.class);
    private static final Object SOCIAL_USER_MANAGER = "communities-user-admin";
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;
    @Reference
    private SlingRepository repository;
    @Reference
    private ResourceResolverFactory rrf;
    protected ComponentContext context;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private XSSAPI xss;
    @Reference
    private SocialUtils socialUtils;
    @Reference
    private ClientUtilityFactory clientUtilFactory;
    @Reference
    private UserUtils userUtils;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;

    @Override
    public SocialComponent getSocialComponentForUser(Resource user, SlingHttpServletRequest request) {
        return this.getSocialComponentForUser(user, this.getClientUtils(request));
    }

    public SocialComponent getSocialComponentForUser(Resource user, ClientUtilities clientUtils) {
        return clientUtils.getUser(user.getName(), user.getResourceResolver(), "social/console/components/hbs/users/user");
    }

    @Override
    public Resource create(SlingHttpServletRequest request) throws OperationException {
        Map<String, Object> requestParams = this.getRequestParams(request.getRequestParameterMap());
        return this.createUser(request.getResource(), requestParams, this.getClientUtils(request));
    }

    @Override
    public Resource createUser(Resource resource, Map<String, Object> requestParams, ClientUtilities clientUtils) throws OperationException {
        Session session = null;
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        CommunitySite site = resource.adaptTo(CommunitySite.class);
        String userId = (String)requestParams.get("email");
        String password = (String)requestParams.get("password");
        String fname = (String)requestParams.get("fname");
        String lname = (String)requestParams.get("lname");
        ResourceResolver resolver = null;
        try {
            resolver = this.getSocialUserManagerResolver();
            U createOperation = this.getCreateOperation();
            session = resolver.adaptTo(Session.class);
            this.performBeforeActions(createOperation, session, resource, requestParams);
            if (site.getConfiguration().getUserManagementConfiguration().allowCaptcha()) {
                this.validateCaptcha(requestParams);
            }
            UserManager userManager = AccessControlUtil.getUserManager(session);
            UserPropertiesManager upm = resolver.adaptTo(UserPropertiesManager.class);
            String userPath = this.userUtils.getUserPath(context, userId);
            User user = (User)userManager.getAuthorizable(userId);
            if (user != null) {
                throw new OperationException("User already existed " + userId, 409);
            }
            user = this.userUtils.getOrCreateCommunityUser(context, userId, password, userManager, upm);
            Group userGroup = this.userUtils.getOrCreateCommunityUserGroup(context, CommunityUserGroup.MEMBER, userManager);
            userGroup.addMember(user);
            Group siteUsers = this.userUtils.getOrCreateCommunitySiteUserGroup(context, CommunityUserGroup.MEMBER, userManager, session);
            siteUsers.addMember(user);
            if (!StringUtils.isEmpty((String)lname) || !StringUtils.isEmpty((String)fname)) {
                Resource profileResource = resolver.getResource(user.getPath() + "/profile");
                ModifiableValueMap profileProps = profileResource.adaptTo(ModifiableValueMap.class);
                if (!StringUtils.isEmpty((String)fname)) {
                    profileProps.put("givenName", fname);
                }
                if (!StringUtils.isEmpty((String)userId)) {
                    profileProps.put("email", userId);
                }
                if (!StringUtils.isEmpty((String)lname)) {
                    profileProps.put("familyName", lname);
                }
            }
            session.save();
            CommunityUser communityUser = (CommunityUser)this.getSocialComponentForUser(resolver.getResource(userPath), clientUtils);
            this.performAfterActions(createOperation, session, communityUser, requestParams);
            SyntheticResource syntheticResource = new SyntheticResource(resource.getResourceResolver(), user.getPath(), "social/console/components/hbs/users/user");
            return syntheticResource;
        }
        catch (RepositoryException e) {
            LOG.error("failed to create new user {}", (Object)userId, (Object)e);
            throw new OperationException("Failed to set mapping url", 500);
        }
        catch (LoginException e) {
            LOG.error("failed to create new user {}", (Object)userId, (Object)e);
            throw new OperationException("Failed to get social user manager service session", 500);
        }
        finally {
            if (resolver != null && resolver.isLive()) {
                resolver.close();
            }
        }
    }

    protected void validateCaptcha(Map<String, Object> requestParams) throws OperationException {
        String captchatry = (String)requestParams.get("captcha");
        String captchakey = (String)requestParams.get("captchakey");
        if (StringUtils.isNotBlank((String)captchakey) && StringUtils.isNotBlank((String)captchatry)) {
            String mins = "" + System.currentTimeMillis() / 60000L;
            String minsold = "" + (System.currentTimeMillis() / 60000L - 1L);
            String captchacurrent = Text.md5("" + captchakey + mins).substring(1, 6);
            String captchaold = Text.md5("" + captchakey + minsold).substring(1, 6);
            if (!captchatry.equals(captchacurrent) && !captchatry.equals(captchaold)) {
                throw new OperationException("Captcha Failure/TimeOut ", 412);
            }
        } else {
            throw new OperationException("Missing Captcha", 412);
        }
    }

    private ResourceResolver getSocialUserManagerResolver() throws LoginException {
        return this.serviceUserWrapper.getServiceResourceResolver(this.rrf, Collections.singletonMap("sling.service.subservice", SOCIAL_USER_MANAGER));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void delete(SlingHttpServletRequest request) throws OperationException {
        RequestParameterMap params = request.getRequestParameterMap();
        RequestParameter[] userIds = (RequestParameter[])params.get("user_id");
        ResourceResolver resolver = request.getResource().getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        CommunityContext context = request.getResource().adaptTo(CommunityContext.class);
        if (context == null) throw new OperationException("Undetermine community context from the request.", 400);
        String siteId = context.getSiteId();
        if (siteId == null) throw new OperationException("Undertermine site id from the request.", 400);
        if (!this.userUtils.hasAdminPermission(session, context) || userIds == null || userIds.length <= 0) return;
        for (int i = 0; i < userIds.length; ++i) {
            this.deleteUser(context, userIds[i].getString(), resolver);
        }
    }

    private Map<String, Object> getRequestParams(RequestParameterMap params) throws OperationException {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        for (String key : params.keySet()) {
            requestParams.put(key, params.getValue(key).getString());
        }
        String userId = params.getValue("email").getString();
        String password = params.getValue("password").getString();
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)password)) {
            throw new OperationException("Missing parameter from the request.", 400);
        }
        return requestParams;
    }

    @Override
    public void deleteUser(CommunityContext context, String userId, ResourceResolver resolver) throws OperationException {
        Session adminSession = null;
        try {
            Group siteAdmin;
            Group siteUsers;
            Group siteModerators;
            adminSession = this.serviceUserWrapper.loginService(this.repository, (String)SOCIAL_USER_MANAGER);
            UserManager userManager = AccessControlUtil.getUserManager(adminSession);
            User user = this.getTenantUser(context, userId, userManager);
            if (user == null) {
                LOG.error("failed to find user {}", (Object)userId);
                throw new OperationException("Failed to find user", 500);
            }
            Group tenantAdmins = this.userUtils.getOrCreateCommunityUserGroup(context, CommunityUserGroup.ADMINISTRATOR, userManager);
            if (tenantAdmins != null) {
                tenantAdmins.removeMember(user);
            }
            if ((siteModerators = this.userUtils.getOrCreateCommunitySiteUserGroup(context, CommunityUserGroup.MODERATOR, userManager, adminSession)) != null) {
                siteModerators.removeMember(user);
            }
            if ((siteUsers = this.userUtils.getOrCreateCommunitySiteUserGroup(context, CommunityUserGroup.MEMBER, userManager, adminSession)) != null) {
                siteUsers.removeMember(user);
            }
            if ((siteAdmin = this.userUtils.getOrCreateCommunitySiteUserGroup(context, CommunityUserGroup.GROUP_ADMIN, userManager, adminSession)) != null) {
                siteAdmin.removeMember(user);
            }
            adminSession.save();
            return;
        }
        catch (RepositoryException e) {
            LOG.error("failed to delete user {}", (Object)userId, (Object)e);
            throw new OperationException("Failed to delete user", 500);
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    protected ClientUtilities getClientUtils(SlingHttpServletRequest request) {
        return this.clientUtilFactory.getClientUtilities(this.xss, request, this.socialUtils);
    }

    private User getTenantUser(CommunityContext context, String userId, UserManager userManager) throws OperationException {
        try {
            return (User)userManager.getAuthorizable(userId);
        }
        catch (AccessDeniedException e) {
            LOG.error("Error getting user manager", (Throwable)e);
            throw new OperationException("Failed to create tenant admin", 500);
        }
        catch (UnsupportedRepositoryOperationException e) {
            LOG.error("Error getting user manager", (Throwable)e);
            throw new OperationException("Failed to create tenant admin", 500);
        }
        catch (RepositoryException e) {
            LOG.error("Error getting user manager", (Throwable)e);
            throw new OperationException("Failed to create tenant admin", 500);
        }
    }

    protected abstract U getCreateOperation();

    protected abstract U getDeleteOperation();

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindXss(XSSAPI xSSAPI) {
        this.xss = xSSAPI;
    }

    protected void unbindXss(XSSAPI xSSAPI) {
        if (this.xss == xSSAPI) {
            this.xss = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        this.clientUtilFactory = clientUtilityFactory;
    }

    protected void unbindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        if (this.clientUtilFactory == clientUtilityFactory) {
            this.clientUtilFactory = null;
        }
    }

    protected void bindUserUtils(UserUtils userUtils) {
        this.userUtils = userUtils;
    }

    protected void unbindUserUtils(UserUtils userUtils) {
        if (this.userUtils == userUtils) {
            this.userUtils = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }
}

