/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.internal.validator;

import com.adobe.cq.social.user.internal.TunnelValidator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityAdminTunnelValidator
implements TunnelValidator {
    private static final String COMMUNITY_ADMINS_GROUP = "community-administrators";
    private static final Logger LOG = LoggerFactory.getLogger(CommunityAdminTunnelValidator.class);

    @Override
    public boolean isValidUser(ResourceResolver resourceResolver) {
        try {
            Session session = resourceResolver.adaptTo(Session.class);
            String userId = session.getUserID();
            UserManager userManager = AccessControlUtil.getUserManager(session);
            Authorizable user = userManager.getAuthorizable(userId);
            Authorizable group = userManager.getAuthorizable(COMMUNITY_ADMINS_GROUP);
            if (user == null || group == null) {
                return false;
            }
            Group communityAdminsGroup = (Group)group;
            return communityAdminsGroup.isMember(user);
        }
        catch (RepositoryException e) {
            LOG.error("Unable to read repository", (Throwable)e);
            return false;
        }
    }
}

