/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.common;

import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.config.FormsPortalDraftsandSubmissionConfigService;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.service.DraftAFDataService;
import com.adobe.fd.fp.service.DraftMetadataService;
import com.adobe.fd.fp.service.SubmitDataService;
import com.adobe.fd.fp.service.SubmitMetadataService;
import com.adobe.fd.fp.service.SubmittedAFDataService;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.fd.fp.util.PropertyUtils;
import com.adobe.fd.fp.util.RepositoryUtils;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, metatype=true)
public abstract class FPSubmitHandler
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -7003172128513135273L;
    private final Logger log = LoggerFactory.getLogger(FPSubmitHandler.class);
    @Reference(referenceInterface=FormsPortalDraftsandSubmissionConfigService.class)
    protected FormsPortalDraftsandSubmissionConfigService draftsandSubmissionConfiguration;
    @Reference(referenceInterface=DraftAFDataService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected DraftAFDataService fpDraftAFDataService;
    @Reference(referenceInterface=SubmittedAFDataService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected SubmittedAFDataService fpSubmittedAFUserDataService;
    @Reference
    protected PortalUtilsComponent portalUtilsComponent;

    public JSONObject submitForm(SlingHttpServletRequest req, Map<String, Object> options, Node formNode) throws FormsPortalException {
        try {
            DraftMetadataService fpDraftMetadataService;
            JSONObject submissionInfoJSON;
            RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
            String name = null;
            String formPath = formNode.getPath();
            String formName = formNode.getName();
            String description = null;
            String formData = options.get("formData") != null ? options.get("formData").toString() : null;
            String userName = options.get("owner") != null ? options.get("owner").toString() : null;
            String formModel = "";
            String typeOfForm = options.containsKey("formType") && options.get("formType") != null ? options.get("formType").toString() : "af";
            String submitUrl = options.containsKey("submitUrl") && options.get("submitUrl") != null ? options.get("submitUrl").toString() : null;
            String profile = options.containsKey("profile") && options.get("profile") != null ? options.get("profile").toString() : null;
            String submissionInfo = options.containsKey("submissionInfo") && options.get("submissionInfo") != null ? options.get("submissionInfo").toString() : null;
            boolean hasDoRTemplate = false;
            boolean hasMetaTemplate = false;
            boolean hasXdpRef = false;
            String[] attachmentList = options.containsKey("attachmentList") && options.get("attachmentList") != null ? (String[])options.get("attachmentList") : null;
            String fpAllowedMetadata = options.containsKey("fpAllowedMetadata") && options.get("fpAllowedMetadata") != null ? options.get("fpAllowedMetadata").toString() : "";
            String draftID = null;
            SubmitDataService fpSubmitDataService = (SubmitDataService)PortalUtils.getService(SubmitDataService.class, this.portalUtilsComponent.getSDSFilter());
            SubmitMetadataService fpSubmitMetadataService = (SubmitMetadataService)PortalUtils.getService(SubmitMetadataService.class, this.portalUtilsComponent.getSMSFilter());
            HashMap<String, Object> metadataParams = new HashMap<String, Object>();
            if (req != null) {
                draftID = req.getParameter("draftID");
                for (Map.Entry param : req.getRequestParameterMap().entrySet()) {
                    if (!((RequestParameter[])param.getValue())[0].isFormField() || !JcrUtil.isValidName((String)param.getKey()) || !fpAllowedMetadata.contains((CharSequence)param.getKey())) continue;
                    metadataParams.put((String)param.getKey(), ((RequestParameter[])param.getValue())[0].toString());
                }
            }
            if (options != null && fpAllowedMetadata != null && !fpAllowedMetadata.trim().isEmpty()) {
                String[] fpAllowedMetadataArr;
                for (String metadata : fpAllowedMetadataArr = fpAllowedMetadata.split(",")) {
                    if (!options.containsKey(metadata)) continue;
                    metadataParams.put(metadata, options.get(metadata));
                }
            }
            if (submissionInfo != null && (submissionInfoJSON = new JSONObject(submissionInfo)).has("computedMetaInfo")) {
                JSONObject computedMetadata = (JSONObject)submissionInfoJSON.get("computedMetaInfo");
                Iterator<String> computedMetaKeys = computedMetadata.keys();
                while (computedMetaKeys.hasNext()) {
                    String computedMetaKey = computedMetaKeys.next();
                    metadataParams.put(computedMetaKey, computedMetadata.get(computedMetaKey));
                }
            }
            if (formPath.startsWith("/content/dam/formsanddocuments")) {
                Node metadataNode = repUtils.getMetadataNode(formNode, false);
                if (metadataNode.hasProperty("description")) {
                    description = (String)PropertyUtils.getPropertyValue(metadataNode.getProperty("description"));
                }
                if (metadataNode.hasProperty("formmodel")) {
                    formModel = (String)PropertyUtils.getPropertyValue(metadataNode.getProperty("formmodel"));
                }
                if (metadataNode.hasProperty("title") && !metadataNode.getProperty("title").getString().trim().isEmpty()) {
                    formName = (String)PropertyUtils.getPropertyValue(metadataNode.getProperty("title"));
                }
                hasDoRTemplate = metadataNode.hasProperty("dorTemplateRef");
                hasMetaTemplate = metadataNode.hasProperty("metaTemplateRef");
                hasXdpRef = metadataNode.hasProperty("xdpRef");
            } else {
                Node contentNode = repUtils.getContentNode(formNode, false);
                if (contentNode != null) {
                    if (contentNode.hasProperty("jcr:description")) {
                        description = (String)PropertyUtils.getPropertyValue(contentNode.getProperty("jcr:description"));
                    }
                    if (contentNode.hasProperty("jcr:title") && !contentNode.getProperty("jcr:title").getString().trim().isEmpty()) {
                        formName = (String)PropertyUtils.getPropertyValue(contentNode.getProperty("jcr:title"));
                    }
                }
            }
            if (draftID != null && !draftID.equalsIgnoreCase("") && (fpDraftMetadataService = (DraftMetadataService)PortalUtils.getService(DraftMetadataService.class, this.portalUtilsComponent.getDMSFilter())) != null && fpDraftMetadataService.getProperty(draftID, "name") != null) {
                name = fpDraftMetadataService.getProperty(draftID, "name")[0];
            }
            if (name == null) {
                name = formName;
            }
            if (name != null) {
                metadataParams.put("name", name);
            }
            boolean isDorAssociated = false;
            boolean bl = isDorAssociated = typeOfForm.equals("mf") || hasXdpRef || hasDoRTemplate || hasMetaTemplate;
            if (isDorAssociated) {
                metadataParams.put("sling:resourceType", "fd/fp/components/opensubmittedguide/xfaaf");
            } else {
                metadataParams.put("sling:resourceType", "fd/fp/components/opensubmittedguide/nonxfaaf");
                metadataParams.put("showDorClass", "__FP_display_none");
            }
            HashMap<String, Object> userdataParams = new HashMap<String, Object>();
            String userdataID = null;
            if ("af".equalsIgnoreCase(typeOfForm) && this.fpSubmittedAFUserDataService != null) {
                userdataParams.put("guideState", formData);
                userdataParams.put("guideName", formName);
                userdataParams.put("userdataID", userdataID);
                userdataID = this.fpSubmittedAFUserDataService.submitAFUserData(userdataParams);
            } else {
                userdataID = fpSubmitDataService.saveData(userdataID, formName, formData);
            }
            metadataParams.put("description", description);
            metadataParams.put("formName", formName != null ? formName : "");
            metadataParams.put("formPath", formPath != null ? formPath : "");
            metadataParams.put("formType", typeOfForm != null ? typeOfForm : "");
            metadataParams.put("nodeType", "fp:submittedForm");
            metadataParams.put("owner", userName);
            metadataParams.put("status", "submitted");
            metadataParams.put("userdataID", userdataID);
            metadataParams.put("renderPath", "/content/forms/portal/render");
            metadataParams.put("formmodel", formModel);
            metadataParams.put("attachmentList", attachmentList);
            Date lastModified = new Date();
            metadataParams.put("jcr:lastModified", String.valueOf(lastModified.getTime()));
            if ("mf".equals(typeOfForm)) {
                metadataParams.put("xdpRef", formPath);
                metadataParams.put("submitUrl", submitUrl);
                metadataParams.put("profile", profile);
            }
            JSONObject submittedJSON = fpSubmitMetadataService.submitMetadata(metadataParams);
            return submittedJSON;
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
    }

    protected void bindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        this.draftsandSubmissionConfiguration = formsPortalDraftsandSubmissionConfigService;
    }

    protected void unbindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        if (this.draftsandSubmissionConfiguration == formsPortalDraftsandSubmissionConfigService) {
            this.draftsandSubmissionConfiguration = null;
        }
    }

    protected void bindFpDraftAFDataService(DraftAFDataService draftAFDataService) {
        this.fpDraftAFDataService = draftAFDataService;
    }

    protected void unbindFpDraftAFDataService(DraftAFDataService draftAFDataService) {
        if (this.fpDraftAFDataService == draftAFDataService) {
            this.fpDraftAFDataService = null;
        }
    }

    protected void bindFpSubmittedAFUserDataService(SubmittedAFDataService submittedAFDataService) {
        this.fpSubmittedAFUserDataService = submittedAFDataService;
    }

    protected void unbindFpSubmittedAFUserDataService(SubmittedAFDataService submittedAFDataService) {
        if (this.fpSubmittedAFUserDataService == submittedAFDataService) {
            this.fpSubmittedAFUserDataService = null;
        }
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }
}

