/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.external;

import com.adobe.aemds.guide.service.external.GuideSubmitPostProcessor;
import com.adobe.fd.fp.common.FPSubmitHandler;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.service.DraftAndSubmissionUtilService;
import com.adobe.fd.fp.service.SubmitDataService;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.fd.fp.util.RepositoryUtils;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, immediate=true, label="GuideSubmitPostProcessorImpl")
@Service(value={GuideSubmitPostProcessor.class})
public class GuideSubmitPostProcessorImpl
extends FPSubmitHandler
implements GuideSubmitPostProcessor {
    private static final long serialVersionUID = -8181619717457685054L;
    private final Logger log = LoggerFactory.getLogger(GuideSubmitPostProcessorImpl.class);
    @Reference(referenceInterface=ResourceResolverHelper.class)
    private ResourceResolverHelper resourceResolverHelper;
    @Reference(referenceInterface=DraftAndSubmissionUtilService.class)
    private DraftAndSubmissionUtilService dsUtil;

    @Override
    public void handlePostProcess(String dataXML, List<FileAttachmentWrapper> attachments, Map<String, String> options) {
        block8: {
            try {
                String formPath;
                SubmitDataService fpSubmitDataService = (SubmitDataService)PortalUtils.getService(SubmitDataService.class, this.portalUtilsComponent.getSDSFilter());
                String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
                Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
                RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
                String draftID = options.get("draftID");
                String afContainerPath = options.get("guideContainerPath");
                String isPortalSubmitEnabled = options.get("enablePortalSubmit");
                String submissionInfo = options.get("afSubmissionInfo");
                try {
                    if (draftID != null && !draftID.trim().isEmpty()) {
                        this.dsUtil.deleteDraft(draftID);
                    }
                }
                catch (Exception e) {
                    this.log.error("Draft is either deleted already or an error occured while deleting it", (Throwable)e);
                }
                String parentCQPage = repUtils.findParentCQPage(afContainerPath, currentSession);
                String string = formPath = parentCQPage != null ? parentCQPage : afContainerPath;
                if (formPath != null && formPath.startsWith("/content/forms/af")) {
                    formPath = "/content/dam/formsanddocuments" + formPath.substring("/content/forms/af".length());
                }
                if (!"true".equalsIgnoreCase(isPortalSubmitEnabled)) break block8;
                if (currentSession.nodeExists(formPath)) {
                    Node formNode = currentSession.getNode(formPath);
                    HashMap<String, Object> submissionOptions = new HashMap<String, Object>();
                    submissionOptions.put("formData", dataXML != null ? dataXML : "");
                    submissionOptions.put("formType", "af");
                    submissionOptions.put("owner", userName);
                    submissionOptions.put("submissionInfo", submissionInfo);
                    ArrayList<String> attachmentKeyArray = new ArrayList<String>();
                    for (FileAttachmentWrapper attachment : attachments) {
                        String attachmentID = fpSubmitDataService.saveAttachment(IOUtils.toByteArray((InputStream)attachment.getInputStream()));
                        String attachmentKey = attachment.getFileName();
                        submissionOptions.put(attachmentKey, attachmentID);
                        submissionOptions.put(attachmentKey + "%2F" + "contentType", attachment.getContentType());
                        attachmentKeyArray.add(attachmentKey);
                    }
                    String[] attachmentKeys = new String[attachmentKeyArray.size()];
                    submissionOptions.put("attachmentList", attachmentKeyArray.toArray(attachmentKeys));
                    String attachmentKeyArrayToStr = StringUtils.join(attachmentKeyArray, (String)",");
                    String attachmentKeyContentTypeStr = attachmentKeyArray != null && attachmentKeyArray.size() > 0 ? StringUtils.join(attachmentKeyArray, (String)"%2FcontentType,") + "%2F" + "contentType" : "";
                    submissionOptions.put("fpAllowedMetadata", attachmentKeyArrayToStr + "," + attachmentKeyContentTypeStr + "," + "attachmentList");
                    super.submitForm(null, submissionOptions, formNode);
                    break block8;
                }
                throw new FormsPortalException("ALC_FMP_001_024");
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindDsUtil(DraftAndSubmissionUtilService draftAndSubmissionUtilService) {
        this.dsUtil = draftAndSubmissionUtilService;
    }

    protected void unbindDsUtil(DraftAndSubmissionUtilService draftAndSubmissionUtilService) {
        if (this.dsUtil == draftAndSubmissionUtilService) {
            this.dsUtil = null;
        }
    }
}

