/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.service.impl;

import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.service.DraftAFDataService;
import com.adobe.fd.fp.service.DraftAndSubmissionUtilService;
import com.adobe.fd.fp.service.DraftDataService;
import com.adobe.fd.fp.service.DraftMetadataService;
import com.adobe.fd.fp.util.PortalUtils;
import java.util.HashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;

@Component
@Service(value={DraftAndSubmissionUtilService.class})
public class DraftAndSubmissionUtilServiceImpl
implements DraftAndSubmissionUtilService {
    @Reference
    protected PortalUtilsComponent portalUtilsComponent;
    @Reference(referenceInterface=DraftAFDataService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected DraftAFDataService fpDraftAFDataService;

    @Override
    public boolean deleteAttachment(String draftID, String attachmentKey) throws FormsPortalException {
        try {
            DraftDataService fpDraftDataService = (DraftDataService)PortalUtils.getService(DraftDataService.class, this.portalUtilsComponent.getDDSFilter());
            DraftMetadataService fpDraftMetadataService = (DraftMetadataService)PortalUtils.getService(DraftMetadataService.class, this.portalUtilsComponent.getDMSFilter());
            String attachmentID = fpDraftMetadataService.getProperty(draftID, attachmentKey)[0];
            boolean isDataDeleted = fpDraftDataService.deleteAttachment(attachmentID);
            HashMap<String, Object> metadataMap = new HashMap<String, Object>();
            if (!isDataDeleted) {
                throw new FormsPortalException("Error occured while deleting attachment data");
            }
            fpDraftMetadataService.deleteProperty(draftID, attachmentKey);
            fpDraftMetadataService.deleteProperty(draftID, attachmentKey + "%2F" + "contentType");
            fpDraftMetadataService.deleteProperty(draftID, attachmentKey + "%2F" + "lastModified");
            String[] attachmentListArray = fpDraftMetadataService.getProperty(draftID, "attachmentList");
            attachmentListArray = PortalUtilsComponent.removeFromArray(attachmentListArray, attachmentKey);
            metadataMap.put("attachmentList", attachmentListArray);
            metadataMap.put("draftID", draftID);
            fpDraftMetadataService.saveMetadata(metadataMap);
            return isDataDeleted;
        }
        catch (Exception e) {
            throw new FormsPortalException(e.getMessage(), e);
        }
    }

    @Override
    public boolean deleteDraft(String draftID) throws Exception {
        DraftMetadataService fpDraftMetadataService = (DraftMetadataService)PortalUtils.getService(DraftMetadataService.class, this.portalUtilsComponent.getDMSFilter());
        DraftDataService fpDraftDataService = (DraftDataService)PortalUtils.getService(DraftDataService.class, this.portalUtilsComponent.getDDSFilter());
        try {
            if (draftID != null && !draftID.isEmpty()) {
                String typeOfForm = fpDraftMetadataService.getProperty(draftID, "formType")[0];
                if (typeOfForm == null) {
                    typeOfForm = "af";
                }
                String draftDataID = fpDraftMetadataService.getProperty(draftID, "userdataID")[0];
                boolean dataDeleted = false;
                if (draftDataID == null || draftDataID.isEmpty()) {
                    dataDeleted = true;
                }
                if (!dataDeleted) {
                    dataDeleted = typeOfForm.equalsIgnoreCase("af") && this.fpDraftAFDataService != null ? this.fpDraftAFDataService.deleteAFDraftUserData(draftDataID).booleanValue() : fpDraftDataService.deleteData(draftDataID);
                }
                if (dataDeleted && draftID != null) {
                    String[] attachmentArray;
                    for (String attachmentKey : attachmentArray = fpDraftMetadataService.getProperty(draftID, "attachmentList")) {
                        if (attachmentKey == null || attachmentKey.isEmpty()) continue;
                        String attachmentID = fpDraftMetadataService.getProperty(draftID, attachmentKey)[0];
                        if (typeOfForm.equalsIgnoreCase("af") && this.fpDraftAFDataService != null) {
                            this.fpDraftAFDataService.deleteAttachment(attachmentID);
                            continue;
                        }
                        fpDraftDataService.deleteAttachment(attachmentID);
                    }
                    fpDraftMetadataService.deleteMetadata(draftID);
                }
                return dataDeleted;
            }
            throw new FormsPortalException("Draft ID passed is empty or null");
        }
        catch (Exception e) {
            throw new FormsPortalException("Error occured while deleting drafts", e);
        }
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }

    protected void bindFpDraftAFDataService(DraftAFDataService draftAFDataService) {
        this.fpDraftAFDataService = draftAFDataService;
    }

    protected void unbindFpDraftAFDataService(DraftAFDataService draftAFDataService) {
        if (this.fpDraftAFDataService == draftAFDataService) {
            this.fpDraftAFDataService = null;
        }
    }
}

