/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.service.impl;

import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.config.FormsPortalDraftsandSubmissionConfigService;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.model.DraftMetadata;
import com.adobe.fd.fp.service.DraftMetadataService;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.fd.fp.util.PropertyUtils;
import com.adobe.fd.fp.util.RepositoryUtils;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.Replicator;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;

@Component(metatype=true, immediate=true, label="FormsPortalDraftMetadataImpl")
@Service(value={DraftMetadataService.class})
@org.apache.felix.scr.annotations.Property(name="aem.formsportal.impl.prop", value={"com.adobe.fd.fp.service.impl.DraftMetadataServiceImpl"})
public class DraftMetadataServiceImpl
implements DraftMetadataService {
    @Reference(referenceInterface=ResourceResolverFactory.class)
    private ResourceResolverFactory resolverFactory;
    @Reference(referenceInterface=ResourceResolverHelper.class)
    private ResourceResolverHelper resourceResolverHelper;
    @Reference(referenceInterface=FormsPortalDraftsandSubmissionConfigService.class)
    private FormsPortalDraftsandSubmissionConfigService draftsandSubmissionConfiguration;
    @Reference(referenceInterface=Replicator.class)
    private Replicator replicator;
    @Reference(referenceInterface=SlingSettingsService.class)
    private SlingSettingsService slingSettingService;
    @Reference(referenceInterface=SlingRepository.class)
    private SlingRepository slingRepository;
    @Reference
    protected PortalUtilsComponent portalUtilsComponent;

    @Override
    public String saveMetadata(Map<String, Object> draftMetaPropMap) throws FormsPortalException {
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
        Session sysUserSession = null;
        try {
            String typeOfForm;
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            String draftID = (String)draftMetaPropMap.get("draftID");
            if (draftID == null || draftID.trim().isEmpty()) {
                throw new FormsPortalException("ALC_FMP_001_010");
            }
            Node userNode = null;
            Node currentDraftMetadataNode = null;
            Node currentDraftNode = null;
            Node draftsRootNode = null;
            userNode = repUtils.getUserNode(userName, false, sysUserSession);
            if (userNode != null && userNode.hasNode("drafts/metadata/" + draftID)) {
                currentDraftMetadataNode = userNode.getNode("drafts/metadata/" + draftID);
            }
            if (currentDraftMetadataNode == null) {
                userNode = repUtils.getUserNode(userName, true, sysUserSession);
                draftsRootNode = repUtils.getChildNode(userNode, "drafts", "sling:OrderedFolder", true);
                currentDraftNode = repUtils.getChildNode(draftsRootNode, "metadata", "sling:OrderedFolder", true);
                currentDraftMetadataNode = repUtils.getChildNode(currentDraftNode, draftID, "{http://www.jcp.org/jcr/nt/1.0}unstructured", true);
            }
            for (Map.Entry<String, Object> prop : draftMetaPropMap.entrySet()) {
                Object propValue = prop.getValue();
                String key = prop.getKey();
                if (propValue instanceof String) {
                    currentDraftMetadataNode.setProperty(key, prop.getValue().toString());
                    continue;
                }
                if (propValue instanceof String[]) {
                    String[] propValArr = (String[])propValue;
                    currentDraftMetadataNode.setProperty(key, propValArr);
                    continue;
                }
                if (propValue instanceof Integer) {
                    Integer propValInt = (Integer)propValue;
                    currentDraftMetadataNode.setProperty(key, (long)propValInt.intValue());
                    continue;
                }
                if (propValue instanceof Double) {
                    Double propValDbl = (Double)propValue;
                    currentDraftMetadataNode.setProperty(key, propValDbl.doubleValue());
                    continue;
                }
                if (propValue instanceof Date) {
                    Date propValDate = (Date)propValue;
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(propValDate);
                    currentDraftMetadataNode.setProperty(key, cal);
                    continue;
                }
                if (!(propValue instanceof Boolean)) continue;
                Boolean propValBool = (Boolean)propValue;
                currentDraftMetadataNode.setProperty(key, propValBool.booleanValue());
            }
            String string = typeOfForm = draftMetaPropMap.containsKey("formType") ? (String)draftMetaPropMap.get("formType") : null;
            if ("af".equalsIgnoreCase(typeOfForm)) {
                currentDraftMetadataNode.setProperty("sling:resourceType", "fd/fp/components/guidereload");
            } else if ("mf".equalsIgnoreCase(typeOfForm)) {
                currentDraftMetadataNode.setProperty("sling:resourceType", "fd/fp/components/formreload");
            }
            this.updateLastModified(currentDraftMetadataNode);
            sysUserSession.save();
            if (this.slingSettingService.getRunModes().contains("publish")) {
                PortalUtils.reverseReplicate(sysUserSession, currentDraftMetadataNode.getParent().getPath().toString(), ReplicationActionType.ACTIVATE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
            }
            String string2 = draftID;
            return string2;
        }
        catch (Exception e) {
            throw new FormsPortalException(e.getMessage(), e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
    }

    @Override
    public boolean deleteMetadata(String draftID) throws FormsPortalException {
        boolean status;
        block10: {
            status = false;
            if (draftID == null || draftID.trim().isEmpty()) {
                throw new FormsPortalException("ALC_FMP_001_016");
            }
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            Session sysUserSession = null;
            boolean isAnonymous = this.portalUtilsComponent.isLoginAnonymous();
            try {
                String userName;
                if (isAnonymous) break block10;
                sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
                RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
                Node userNode = repUtils.getUserNode(userName = this.resourceResolverHelper.getResourceResolver().getUserID(), false, currentSession);
                if (userNode != null && userNode.hasNode("drafts/metadata/" + draftID)) {
                    Node draftMetadataNode = userNode.getNode("drafts/metadata/" + draftID);
                    if (currentSession != null) {
                        if (this.slingSettingService.getRunModes().contains("publish")) {
                            PortalUtils.reverseReplicate(sysUserSession, draftMetadataNode.getPath(), ReplicationActionType.DELETE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
                        }
                        currentSession.getNode(draftMetadataNode.getPath()).remove();
                        currentSession.save();
                        status = true;
                        break block10;
                    }
                    throw new FormsPortalException("ALC_FMP_001_017");
                }
                throw new FormsPortalException("ALC_FMP_001_011");
            }
            catch (Exception e) {
                throw new FormsPortalException(e);
            }
            finally {
                if (sysUserSession != null) {
                    sysUserSession.logout();
                }
            }
        }
        return status;
    }

    @Override
    public JSONArray getDrafts(String cutPoints) throws FormsPortalException {
        ArrayList<DraftMetadata> draftsList = new ArrayList<DraftMetadata>();
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
        Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
        JSONArray draftsResult = new JSONArray();
        try {
            Node draftsRootnode;
            Session serviceUserSession;
            Node userNode = repUtils.getUserNode(userName, false, currentSession);
            if (userNode != null && !userName.equals("anonymous")) {
                Node draftsRootnode2 = repUtils.getChildNode(userNode, "drafts", "sling:OrderedFolder", false);
                if (draftsRootnode2 != null && draftsRootnode2.hasNode("metadata")) {
                    Node draftsMetaDataRootNode = repUtils.getChildNode(draftsRootnode2, "metadata", "sling:OrderedFolder", false);
                    draftsList.addAll(this.readDrafts(draftsMetaDataRootNode, cutPoints));
                }
            } else if (userName.equals("anonymous") && (userNode = repUtils.getUserNode(userName, false, serviceUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository))) != null && (draftsRootnode = repUtils.getChildNode(userNode, "drafts", "sling:OrderedFolder", false)) != null && draftsRootnode.hasNode("metadata")) {
                Node draftsMetaDataRootNode = repUtils.getChildNode(draftsRootnode, "metadata", "sling:OrderedFolder", false);
                draftsList.addAll(this.readDrafts(draftsMetaDataRootNode, cutPoints));
            }
            Collections.sort(draftsList);
            for (DraftMetadata draft : draftsList) {
                JSONObject draftsJson = draft.getJSONObject();
                draftsResult.put(draftsJson);
            }
        }
        catch (ItemExistsException e) {
            throw new FormsPortalException(e);
        }
        catch (PathNotFoundException e) {
            throw new FormsPortalException(e);
        }
        catch (NoSuchNodeTypeException e) {
            throw new FormsPortalException(e);
        }
        catch (LockException e) {
            throw new FormsPortalException(e);
        }
        catch (VersionException e) {
            throw new FormsPortalException(e);
        }
        catch (ConstraintViolationException e) {
            throw new FormsPortalException(e);
        }
        catch (RepositoryException e) {
            throw new FormsPortalException(e);
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
        return draftsResult;
    }

    private List<DraftMetadata> readDrafts(Node draftsMetaDataRootNode, String cutPoints) throws ValueFormatException, RepositoryException, Exception {
        ArrayList<DraftMetadata> draftsList = new ArrayList<DraftMetadata>();
        NodeIterator itr = draftsMetaDataRootNode.getNodes();
        while (itr.hasNext()) {
            Node draftNode = itr.nextNode();
            DraftMetadata draft = new DraftMetadata();
            String userDataId = null;
            if (draftNode.hasProperty("userdataID")) {
                userDataId = (String)PropertyUtils.getPropertyValue(draftNode.getProperty("userdataID"));
            }
            if (userDataId == null || userDataId.isEmpty()) continue;
            if (draftNode.hasProperty("guideName")) {
                draft.setName((String)PropertyUtils.getPropertyValue(draftNode.getProperty("guideName")));
            } else if (draftNode.hasProperty("formName")) {
                draft.setName((String)PropertyUtils.getPropertyValue(draftNode.getProperty("formName")));
            }
            if (draftNode.hasProperty("owner")) {
                draft.setOwner((String)PropertyUtils.getPropertyValue(draftNode.getProperty("owner")));
            }
            Object lastModifiedObj = PropertyUtils.getPropertyValue(draftNode.getProperty("jcr:lastModified"));
            Date lastModifiedDate = null;
            if (lastModifiedObj instanceof Date) {
                lastModifiedDate = (Date)lastModifiedObj;
            } else if (lastModifiedObj instanceof String) {
                lastModifiedDate = new Date(Long.valueOf((String)lastModifiedObj));
            } else if (lastModifiedObj instanceof Long) {
                lastModifiedDate = new Date((Long)lastModifiedObj);
            }
            draft.setLastModified(lastModifiedDate);
            if (draftNode.hasProperty("description")) {
                draft.setDescription((String)PropertyUtils.getPropertyValue(draftNode.getProperty("description")));
            }
            if (!draftNode.hasProperty("draftID")) continue;
            draft.setDraftID((String)PropertyUtils.getPropertyValue(draftNode.getProperty("draftID")));
            List<String> cutPointsList = Arrays.asList(cutPoints.split(","));
            for (String cutPoint : cutPointsList) {
                if (draftNode.hasProperty(cutPoint)) {
                    draft.setCustomProperty(cutPoint, String.valueOf(PropertyUtils.getPropertyValue(draftNode.getProperty(cutPoint))));
                    continue;
                }
                if (cutPoint.equals("name")) {
                    draft.setCustomProperty("name", draft.getName());
                    continue;
                }
                draft.setCustomProperty(cutPoint, "");
            }
            String draftNodePath = draftNode.getPath();
            Object[] draftNodeSplit = draftNodePath.split("/");
            if (draftNodeSplit != null) {
                draftNodeSplit[4] = URLEncoder.encode((String)draftNodeSplit[4], "UTF-8");
            }
            draftNodePath = StringUtils.join((Object[])draftNodeSplit, (String)"/");
            draft.setPath(draftNodePath);
            draftsList.add(draft);
        }
        return draftsList;
    }

    private void updateLastModified(Node node) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        Calendar lastModified = Calendar.getInstance();
        node.setProperty("jcr:lastModified", lastModified);
    }

    @Override
    public String[] getProperty(String draftID, String propertyName) throws FormsPortalException {
        try {
            Property prop;
            Node draftMetadataNode;
            RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
            Node userNode = repUtils.getUserNode(userName, false, currentSession);
            String draftNodeRelativePath = "drafts/metadata/" + draftID;
            if (userNode != null && userNode.hasNode(draftNodeRelativePath) && (draftMetadataNode = userNode.getNode(draftNodeRelativePath)) != null && draftMetadataNode.hasProperty(propertyName) && (prop = draftMetadataNode.getProperty(propertyName)) != null) {
                if (!prop.isMultiple()) {
                    String propValue = draftMetadataNode.getProperty(propertyName).getString();
                    return new String[]{propValue};
                }
                Value[] propValueList = draftMetadataNode.getProperty(propertyName).getValues();
                ArrayList<String> attachmentStringList = new ArrayList<String>();
                for (Value propVals : propValueList) {
                    String propValStr = propVals.getString();
                    attachmentStringList.add(propValStr);
                }
                return attachmentStringList.toArray(new String[0]);
            }
            return new String[]{""};
        }
        catch (Exception e) {
            throw new FormsPortalException("Error occured while getting value of " + propertyName + "at draftID = " + draftID, e);
        }
    }

    @Override
    public boolean deleteProperty(String draftID, String propertyName) throws FormsPortalException {
        boolean isAnonymous = this.portalUtilsComponent.isLoginAnonymous();
        Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
        try {
            Node draftMetadataNode;
            Session sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
            String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
            if (isAnonymous) {
                currentSession = sysUserSession;
            }
            Node userNode = repUtils.getUserNode(userName, false, currentSession);
            String draftNodeRelativePath = "drafts/metadata/" + draftID;
            if (userNode != null && userNode.hasNode(draftNodeRelativePath) && (draftMetadataNode = userNode.getNode(draftNodeRelativePath)) != null && draftMetadataNode.hasProperty(propertyName)) {
                Property prop = draftMetadataNode.getProperty(propertyName);
                prop.setValue((String[])null);
                currentSession.save();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new FormsPortalException("Error occured while deleting value of " + propertyName + "at draftID = " + draftID, e);
        }
        finally {
            if (isAnonymous) {
                currentSession.logout();
            }
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        this.draftsandSubmissionConfiguration = formsPortalDraftsandSubmissionConfigService;
    }

    protected void unbindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        if (this.draftsandSubmissionConfiguration == formsPortalDraftsandSubmissionConfigService) {
            this.draftsandSubmissionConfiguration = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindSlingSettingService(SlingSettingsService slingSettingsService) {
        this.slingSettingService = slingSettingsService;
    }

    protected void unbindSlingSettingService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingService == slingSettingsService) {
            this.slingSettingService = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }
}

