/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.service.impl;

import com.adobe.fd.fp.common.FileAttachmentWrapper;
import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.service.DraftDataService;
import com.adobe.fd.fp.service.DraftMetadataService;
import com.adobe.fd.fp.service.DraftSubmissionManagementService;
import com.adobe.fd.fp.service.SubmitDataService;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.fd.fp.util.Record;
import com.adobe.fd.fp.util.RetrievalOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={DraftSubmissionManagementService.class})
public class DraftSubmissionManagementServiceImpl
implements DraftSubmissionManagementService {
    @Reference(referenceInterface=PortalUtilsComponent.class)
    private PortalUtilsComponent portalUtilsComponent;
    private final Logger logger = LoggerFactory.getLogger(DraftSubmissionManagementServiceImpl.class);

    @Override
    public Record getDraftInfo(String id, RetrievalOptions retrievalOptions) {
        if (retrievalOptions == null || StringUtils.isEmpty((CharSequence)id)) {
            this.logger.error("Draft ID absent or retrieval options missing for draft");
            return null;
        }
        boolean fetchDataXml = retrievalOptions.isFetchDataXml();
        boolean fetchAttachmentList = retrievalOptions.isFetchAttachmentList();
        Record record = new Record();
        if (fetchDataXml) {
            record.setDataXML(this.getUserData(id));
        }
        if (fetchAttachmentList) {
            record.setFileAttachmentWrapperList(this.getFileAttachmentWrapper(id, this.getAttachmentList(id)));
        }
        return record;
    }

    private DraftDataService getDraftService() {
        try {
            return (DraftDataService)PortalUtils.getService(DraftDataService.class, this.portalUtilsComponent.getDDSFilter());
        }
        catch (Exception e) {
            this.logger.error("Cannnot get Draft Data Service", (Throwable)e);
            return null;
        }
    }

    private DraftMetadataService getDraftMetaService() {
        try {
            return (DraftMetadataService)PortalUtils.getService(DraftMetadataService.class, this.portalUtilsComponent.getDMSFilter());
        }
        catch (Exception e) {
            this.logger.error("Cannnot get Draft Data Service", (Throwable)e);
            return null;
        }
    }

    private SubmitDataService getSubmitDataService() {
        try {
            return (SubmitDataService)PortalUtils.getService(SubmitDataService.class, this.portalUtilsComponent.getSDSFilter());
        }
        catch (Exception e) {
            this.logger.error("Cannnot get Draft Data Service", (Throwable)e);
            return null;
        }
    }

    private DraftDataService getDraftDataService() {
        try {
            return (DraftDataService)PortalUtils.getService(DraftDataService.class, this.portalUtilsComponent.getDDSFilter());
        }
        catch (Exception e) {
            this.logger.error("Cannnot get Draft Data Service", (Throwable)e);
            return null;
        }
    }

    private String[] getAttachmentList(String draftID) {
        try {
            DraftMetadataService draftMetadataService = this.getDraftMetaService();
            if (draftMetadataService != null) {
                return draftMetadataService.getProperty(draftID, "attachmentList");
            }
        }
        catch (Exception e) {
            this.logger.error("Cannnot get attachment list Service", (Throwable)e);
        }
        return null;
    }

    private List<FileAttachmentWrapper> getFileAttachmentWrapper(String id, String[] attachmentList) {
        ArrayList<FileAttachmentWrapper> fileAttachmentWrapperList = new ArrayList<FileAttachmentWrapper>();
        try {
            DraftMetadataService draftMetadataService = this.getDraftMetaService();
            DraftDataService draftDataService = this.getDraftService();
            if (draftDataService == null || draftMetadataService == null) {
                this.logger.warn("Could not fetch data or meta data service ");
                return fileAttachmentWrapperList;
            }
            for (String attachmentKey : attachmentList) {
                String attachmentID = draftMetadataService.getProperty(id, attachmentKey)[0];
                String contentType = draftMetadataService.getProperty(id, attachmentKey + "%2F" + "contentType")[0];
                byte[] attachmentData = draftDataService.getAttachment(attachmentID);
                FileAttachmentWrapper fileAttachmentWrapper = new FileAttachmentWrapper(attachmentKey, contentType, attachmentData);
                fileAttachmentWrapperList.add(fileAttachmentWrapper);
            }
        }
        catch (Exception e) {
            this.logger.error("Could not get fetch File attachments", (Throwable)e);
        }
        return fileAttachmentWrapperList;
    }

    private byte[] getUserData(String id) {
        DraftDataService draftDataService = this.getDraftDataService();
        DraftMetadataService draftMetadataService = this.getDraftMetaService();
        if (draftDataService == null) {
            this.logger.error("Could not get data service");
            return null;
        }
        if (draftMetadataService == null) {
            this.logger.error("Could not get meta data service");
            return null;
        }
        try {
            return draftDataService.getData(id);
        }
        catch (Exception e) {
            this.logger.error("Error in getting data for " + id, (Throwable)e);
            return null;
        }
    }

    @Override
    public Record getSubmitInfo(String id, RetrievalOptions retrievalOptions) {
        return null;
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }
}

