/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.service.impl;

import com.adobe.fd.fp.service.FPIntegrationService;
import com.adobe.fd.fp.service.FPIntegrationServiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="FP Integration Service", description="Provides Integration Scripts for Forms Portal runtime", immediate=true)
@Service(value={FPIntegrationService.class})
public class FPIntegrationServiceImpl
implements FPIntegrationService {
    private Logger logger = LoggerFactory.getLogger(FPIntegrationServiceImpl.class);
    @Reference(name="fpIntegtationScriptProvider", referenceInterface=FPIntegrationServiceProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private Map<Comparable<Object>, FPIntegrationServiceProvider> providers = new ConcurrentSkipListMap(Collections.reverseOrder());

    private Collection<FPIntegrationServiceProvider> getProviders() {
        return this.providers.values();
    }

    @Override
    public List<String> getScriptPaths(String providerValue) {
        HashSet<String> paths = new HashSet<String>();
        for (FPIntegrationServiceProvider provider : this.getProviders()) {
            List<String> currentPaths = provider.getFPIntegrationScriptPaths(providerValue);
            if (currentPaths == null || currentPaths.isEmpty()) continue;
            paths.addAll(currentPaths);
        }
        return new ArrayList<String>(paths);
    }

    protected void bindFPIntegrationServiceProvider(FPIntegrationServiceProvider provider, Map<String, Object> config) {
        this.providers.put(ServiceUtil.getComparableForServiceRanking(config), provider);
    }

    protected void unbindFPIntegrationServiceProvider(FPIntegrationServiceProvider provider, Map<String, Object> config) {
        this.providers.remove(ServiceUtil.getComparableForServiceRanking(config));
    }
}

