/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.service.impl;

import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.config.FormsPortalDraftsandSubmissionConfigService;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.service.SubmitDataService;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.fd.fp.util.PropertyUtils;
import com.adobe.fd.fp.util.RepositoryUtils;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.Replicator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="FPSubmittedAFUserDataServiceImpl")
@Service(value={SubmitDataService.class})
@Property(name="aem.formsportal.impl.prop", value={"com.adobe.fd.fp.service.impl.SubmitDataServiceImpl"})
public class SubmitDataServiceImpl
implements SubmitDataService {
    private final Logger logger = LoggerFactory.getLogger(SubmitDataServiceImpl.class);
    @Reference(referenceInterface=ResourceResolverFactory.class)
    ResourceResolverFactory resolverFactory;
    @Reference(referenceInterface=ResourceResolverHelper.class)
    ResourceResolverHelper resourceResolverHelper;
    @Reference(referenceInterface=FormsPortalDraftsandSubmissionConfigService.class)
    FormsPortalDraftsandSubmissionConfigService draftsandSubmissionConfiguration;
    @Reference(referenceInterface=Replicator.class)
    private Replicator replicator;
    @Reference(referenceInterface=SlingSettingsService.class)
    SlingSettingsService slingSettingService;
    @Reference(referenceInterface=SlingRepository.class)
    private SlingRepository slingRepository;
    @Reference
    private PortalUtilsComponent portalUtilsComponent;

    private void updateLastModified(Node node) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Calendar lastModified = Calendar.getInstance();
        node.setProperty("jcr:lastModified", lastModified);
    }

    @Override
    public String saveData(String userDataID, String formName, String formData) throws FormsPortalException {
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
        boolean isAnonymous = false;
        Session sysUserSession = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            Node userNode = repUtils.getUserNode(userName, true, sysUserSession);
            if (formName == null || formData == null || formName.trim().isEmpty() || formData.trim().isEmpty()) {
                throw new FormsPortalException("ALC_FMP_001_014");
            }
            Node submitRootNode = null;
            Node currentSubmitNode = null;
            Node currentSubmitUserdataNode = null;
            if (userDataID == null || userDataID.trim().isEmpty()) {
                userDataID = PortalUtils.getUniqueId();
                submitRootNode = repUtils.getChildNode(userNode, "submit", "sling:OrderedFolder", true);
                currentSubmitNode = repUtils.getChildNode(submitRootNode, "data", "sling:OrderedFolder", true);
                currentSubmitUserdataNode = repUtils.getChildNode(currentSubmitNode, userDataID, "{http://www.jcp.org/jcr/nt/1.0}unstructured", true);
            } else {
                currentSubmitUserdataNode = sysUserSession.getNode(userDataID);
            }
            PropertyUtils.setBinaryValue(currentSubmitUserdataNode, "jcr:data", formData, sysUserSession.getValueFactory());
            this.updateLastModified(currentSubmitUserdataNode);
            sysUserSession.save();
            if (this.slingSettingService.getRunModes().contains("publish")) {
                PortalUtils.reverseReplicate(sysUserSession, currentSubmitUserdataNode.getParent().getPath().toString(), ReplicationActionType.ACTIVATE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
            }
            if (isAnonymous) {
                String string = "\"" + currentSubmitUserdataNode.getPath() + ".html" + "\"";
                return string;
            }
            String string = currentSubmitUserdataNode.getPath().toString();
            return string;
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
    }

    @Override
    public byte[] getData(String userDataID) throws FormsPortalException {
        Session sysUserSession = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            Node dataNode = sysUserSession.getNode(userDataID);
            if (dataNode != null) {
                InputStream is = null;
                if (dataNode.hasProperty("jcr:data")) {
                    is = dataNode.getProperty("jcr:data").getBinary().getStream();
                } else if (dataNode.hasNode("jcr:content")) {
                    Node jcrDataNode = dataNode.getNode("jcr:content");
                    is = jcrDataNode.getProperty("jcr:data").getBinary().getStream();
                } else {
                    throw new FormsPortalException("ALC_FMP_001_021");
                }
                BufferedInputStream bis = new BufferedInputStream(is);
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                int result = bis.read();
                while (result != -1) {
                    byte b = (byte)result;
                    buf.write(b);
                    result = bis.read();
                }
                byte[] byArray = buf.toByteArray();
                return byArray;
            }
            try {
                throw new FormsPortalException("ALC_FMP_001_021");
            }
            catch (Exception e) {
                throw new FormsPortalException(e.getMessage(), e);
            }
        }
        finally {
            sysUserSession.logout();
        }
    }

    @Override
    public boolean deleteData(String userDataID) throws FormsPortalException {
        boolean status;
        block9: {
            status = false;
            boolean isAnonymous = this.portalUtilsComponent.isLoginAnonymous();
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            Session sysUserSession = null;
            if (userDataID == null || userDataID.trim().isEmpty()) {
                throw new FormsPortalException("ALC_FMP_001_016");
            }
            try {
                String userName;
                if (isAnonymous) break block9;
                sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
                RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
                Node userNode = repUtils.getUserNode(userName = this.resourceResolverHelper.getResourceResolver().getUserID(), false, currentSession);
                if (userNode != null && currentSession.nodeExists(userDataID)) {
                    if (this.slingSettingService.getRunModes().contains("publish")) {
                        PortalUtils.reverseReplicate(sysUserSession, userDataID, ReplicationActionType.DELETE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
                    }
                    currentSession.getNode(userDataID).remove();
                    currentSession.save();
                    status = true;
                    break block9;
                }
                throw new FormsPortalException("ALC_FMP_001_013");
            }
            catch (Exception e) {
                throw new FormsPortalException(e);
            }
            finally {
                if (sysUserSession != null) {
                    sysUserSession.logout();
                }
            }
        }
        return status;
    }

    @Override
    public String saveAttachment(byte[] attachmentBytes) throws FormsPortalException {
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
        Session sysUserSession = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            Node userNode = null;
            userNode = repUtils.getUserNode(userName, true, sysUserSession);
            Node submitFolder = repUtils.getChildNode(userNode, "submit", "sling:OrderedFolder", true);
            Node attachmentRootFolder = repUtils.getChildNode(submitFolder, "attachments", "sling:OrderedFolder", true);
            String currentAttachmentNodeName = PortalUtils.getUniqueId();
            Node currentAttachmentNode = attachmentRootFolder.addNode(currentAttachmentNodeName, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
            PropertyUtils.setBinaryValue(currentAttachmentNode, "jcr:data", attachmentBytes, sysUserSession.getValueFactory());
            String attachmentNodePath = currentAttachmentNode.getPath().toString();
            sysUserSession.save();
            if (this.slingSettingService.getRunModes().contains("publish")) {
                PortalUtils.reverseReplicate(sysUserSession, currentAttachmentNode.getPath().toString(), ReplicationActionType.ACTIVATE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
            }
            String string = attachmentNodePath;
            return string;
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
    }

    @Override
    public boolean deleteAttachment(String attachmentID) throws FormsPortalException {
        boolean status = false;
        boolean isAnonymous = this.portalUtilsComponent.isLoginAnonymous();
        Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
        Session sysUserSession = null;
        if (attachmentID == null || attachmentID.trim().isEmpty()) {
            this.logger.warn("Invalid attachment ID");
        } else {
            try {
                if (!isAnonymous) {
                    String userName;
                    sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
                    RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
                    Node userNode = repUtils.getUserNode(userName = this.resourceResolverHelper.getResourceResolver().getUserID(), false, currentSession);
                    if (userNode != null && currentSession != null && currentSession.nodeExists(attachmentID)) {
                        if (this.slingSettingService.getRunModes().contains("publish")) {
                            PortalUtils.reverseReplicate(sysUserSession, attachmentID, ReplicationActionType.DELETE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
                        }
                        currentSession.getNode(attachmentID).remove();
                        currentSession.save();
                        status = true;
                    } else {
                        this.logger.warn("Attachment does not exist");
                    }
                }
            }
            catch (Exception e) {
                throw new FormsPortalException(e);
            }
            finally {
                if (sysUserSession != null) {
                    sysUserSession.logout();
                }
            }
        }
        return status;
    }

    @Override
    public byte[] getAttachment(String attachmentID) throws FormsPortalException {
        Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
        try {
            Node dataNode = currentSession.getNode(attachmentID);
            if (dataNode != null) {
                InputStream is = null;
                if (dataNode.hasProperty("jcr:data")) {
                    is = dataNode.getProperty("jcr:data").getBinary().getStream();
                } else if (dataNode.hasNode("jcr:content")) {
                    Node jcrDataNode = dataNode.getNode("jcr:content");
                    is = jcrDataNode.getProperty("jcr:data").getBinary().getStream();
                } else {
                    throw new FormsPortalException("ALC_FMP_001_021");
                }
                BufferedInputStream bis = new BufferedInputStream(is);
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                int result = bis.read();
                while (result != -1) {
                    byte b = (byte)result;
                    buf.write(b);
                    result = bis.read();
                }
                return buf.toByteArray();
            }
            throw new FormsPortalException("ALC_FMP_001_021");
        }
        catch (ItemExistsException e) {
            throw new FormsPortalException(e);
        }
        catch (PathNotFoundException e) {
            throw new FormsPortalException(e);
        }
        catch (NoSuchNodeTypeException e) {
            throw new FormsPortalException(e);
        }
        catch (LockException e) {
            throw new FormsPortalException(e);
        }
        catch (VersionException e) {
            throw new FormsPortalException(e);
        }
        catch (ConstraintViolationException e) {
            throw new FormsPortalException(e);
        }
        catch (RepositoryException e) {
            throw new FormsPortalException(e);
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        this.draftsandSubmissionConfiguration = formsPortalDraftsandSubmissionConfigService;
    }

    protected void unbindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        if (this.draftsandSubmissionConfiguration == formsPortalDraftsandSubmissionConfigService) {
            this.draftsandSubmissionConfiguration = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindSlingSettingService(SlingSettingsService slingSettingsService) {
        this.slingSettingService = slingSettingsService;
    }

    protected void unbindSlingSettingService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingService == slingSettingsService) {
            this.slingSettingService = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }
}

