/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.service.impl;

import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.config.FormsPortalDraftsandSubmissionConfigService;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.model.SubmittedMetadata;
import com.adobe.fd.fp.service.SubmitMetadataService;
import com.adobe.fd.fp.util.FormsPortalConstants;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.fd.fp.util.PropertyUtils;
import com.adobe.fd.fp.util.RepositoryUtils;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.Replicator;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.facets.Bucket;
import com.day.cq.search.facets.Facet;
import com.day.cq.search.result.SearchResult;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="FPSubmitMetadataServiceImpl")
@Service(value={SubmitMetadataService.class})
@org.apache.felix.scr.annotations.Property(name="aem.formsportal.impl.prop", value={"com.adobe.fd.fp.service.impl.SubmitMetadataServiceImpl"})
public class SubmitMetadataServiceImpl
implements SubmitMetadataService {
    @Reference(referenceInterface=ResourceResolverHelper.class)
    ResourceResolverHelper resourceResolverHelper;
    @Reference(referenceInterface=FormsPortalDraftsandSubmissionConfigService.class)
    FormsPortalDraftsandSubmissionConfigService draftsandSubmissionConfiguration;
    @Reference(referenceInterface=ResourceResolverFactory.class)
    ResourceResolverFactory resolverFactory;
    @Reference(referenceInterface=Replicator.class)
    private Replicator replicator;
    @Reference(referenceInterface=SlingSettingsService.class)
    SlingSettingsService slingSettingService;
    @Reference(referenceInterface=SlingRepository.class)
    private SlingRepository slingRepository;
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private PortalUtilsComponent portalUtilsComponent;
    private final Logger log = LoggerFactory.getLogger(SubmitMetadataServiceImpl.class);

    @Override
    public boolean deleteMetadata(String id) throws FormsPortalException {
        boolean status;
        block11: {
            status = false;
            boolean isAnonymous = this.portalUtilsComponent.isLoginAnonymous();
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            Session sysUserSession = null;
            if (id == null || id.trim().isEmpty()) {
                throw new FormsPortalException("ALC_FMP_001_016");
            }
            try {
                String userName;
                if (isAnonymous) break block11;
                sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
                RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
                Node userNode = repUtils.getUserNode(userName = this.resourceResolverHelper.getResourceResolver().getUserID(), false, currentSession);
                if (userNode != null && userNode.hasNode("submit/metadata/" + id)) {
                    Node submitMetadataNode = userNode.getNode("submit/metadata/" + id);
                    if (submitMetadataNode.hasProperty("submitID")) {
                        if (currentSession != null) {
                            if (this.slingSettingService.getRunModes().contains("publish")) {
                                PortalUtils.reverseReplicate(sysUserSession, submitMetadataNode.getPath(), ReplicationActionType.DELETE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
                            }
                            currentSession.getNode(submitMetadataNode.getPath()).remove();
                            currentSession.save();
                            status = true;
                            break block11;
                        }
                        throw new FormsPortalException("ALC_FMP_001_017");
                    }
                    throw new FormsPortalException("ALC_FMP_001_019");
                }
                throw new FormsPortalException("ALC_FMP_001_020");
            }
            catch (Exception e) {
                throw new FormsPortalException(e);
            }
            finally {
                if (sysUserSession != null) {
                    sysUserSession.logout();
                }
            }
        }
        return status;
    }

    @Override
    public JSONObject submitMetadata(Map<String, Object> submittedMetaPropMap) throws FormsPortalException {
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
        boolean isOwner = false;
        Session sysUserSession = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            String submitID = (String)submittedMetaPropMap.get("submitID");
            Node userNode = null;
            Node submitRootNode = null;
            Node currentSubmitNode = null;
            Node currentSubmitMetadataNode = null;
            boolean isUserAllowed = false;
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            if (submitID == null || submitID.trim().isEmpty()) {
                submitID = PortalUtils.getUniqueId();
                userNode = repUtils.getUserNode(userName, true, sysUserSession);
                submitRootNode = repUtils.getChildNode(userNode, "submit", "sling:OrderedFolder", true);
                currentSubmitNode = repUtils.getChildNode(submitRootNode, "metadata", "sling:OrderedFolder", true);
                currentSubmitMetadataNode = repUtils.getChildNode(currentSubmitNode, submitID, "{http://www.jcp.org/jcr/nt/1.0}unstructured", true);
                isUserAllowed = true;
            } else {
                currentSubmitMetadataNode = this.portalUtilsComponent.getMetadataNodeFromSubmitID(submitID, sysUserSession);
                String formPath = currentSubmitMetadataNode.hasProperty("formPath") ? currentSubmitMetadataNode.getProperty("formPath").getString() : null;
                isUserAllowed = this.portalUtilsComponent.isReviewer(currentSession, formPath);
                isOwner = this.portalUtilsComponent.isOwner(currentSession, submitID);
                if (isOwner && !isUserAllowed) {
                    HashSet<String> allowedKeys = new HashSet<String>(Arrays.asList(FormsPortalConstants.STR_UPDATION_ALLOWED_PROPERTIES));
                    submittedMetaPropMap.keySet().retainAll(allowedKeys);
                }
            }
            if (isUserAllowed || isOwner) {
                for (Map.Entry<String, Object> prop : submittedMetaPropMap.entrySet()) {
                    Object propValue = prop.getValue();
                    String key = prop.getKey();
                    if (propValue instanceof String) {
                        currentSubmitMetadataNode.setProperty(key, prop.getValue().toString());
                        continue;
                    }
                    if (propValue instanceof String[]) {
                        String[] propValArr = (String[])propValue;
                        currentSubmitMetadataNode.setProperty(key, propValArr);
                        continue;
                    }
                    if (propValue instanceof Integer) {
                        Integer propValInt = (Integer)propValue;
                        currentSubmitMetadataNode.setProperty(key, (long)propValInt.intValue());
                        continue;
                    }
                    if (propValue instanceof Double) {
                        Double propValDbl = (Double)propValue;
                        currentSubmitMetadataNode.setProperty(key, propValDbl.doubleValue());
                        continue;
                    }
                    if (propValue instanceof Date) {
                        Date propValDate = (Date)propValue;
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(propValDate);
                        currentSubmitMetadataNode.setProperty(key, cal);
                        continue;
                    }
                    if (!(propValue instanceof Boolean)) continue;
                    Boolean propValBool = (Boolean)propValue;
                    currentSubmitMetadataNode.setProperty(key, propValBool.booleanValue());
                }
                currentSubmitMetadataNode.setProperty("submitID", submitID);
                this.updateLastModified(currentSubmitMetadataNode);
                sysUserSession.save();
                if (this.slingSettingService.getRunModes().contains("publish")) {
                    PortalUtils.reverseReplicate(sysUserSession, currentSubmitMetadataNode.getParent().getPath().toString(), ReplicationActionType.ACTIVATE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
                }
                SubmittedMetadata submittedGuide = new SubmittedMetadata();
                submittedGuide.setName((String)PropertyUtils.getPropertyValue(currentSubmitMetadataNode.getProperty("formName")));
                submittedGuide.setOwner((String)PropertyUtils.getPropertyValue(currentSubmitMetadataNode.getProperty("owner")));
                Object lastModified = PropertyUtils.getPropertyValue(currentSubmitMetadataNode.getProperty("jcr:lastModified"));
                if (lastModified instanceof Date) {
                    submittedGuide.setLastModified((Date)lastModified);
                } else if (lastModified instanceof Long) {
                    submittedGuide.setLastModified(new Date((Long)lastModified));
                }
                submittedGuide.setPath(currentSubmitMetadataNode.getPath() + ".html");
                submittedGuide.setSubmitID(String.valueOf(PropertyUtils.getPropertyValue(currentSubmitMetadataNode.getProperty("submitID"))));
                if (currentSubmitMetadataNode.hasProperty("description")) {
                    submittedGuide.setDescription((String)PropertyUtils.getPropertyValue(currentSubmitMetadataNode.getProperty("description")));
                }
                if (currentSubmitMetadataNode.hasProperty("status")) {
                    submittedGuide.setStatus((String)PropertyUtils.getPropertyValue(currentSubmitMetadataNode.getProperty("status")));
                }
                JSONObject jSONObject = submittedGuide.getJSONObject();
                return jSONObject;
            }
        }
        catch (Exception e) {
            throw new FormsPortalException(e.getMessage(), e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
        return new JSONObject();
    }

    private void updateLastModified(Node node) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Calendar lastModified = Calendar.getInstance();
        node.setProperty("jcr:lastModified", lastModified);
    }

    @Override
    public JSONArray getSubmissions(String cutPoints) throws FormsPortalException {
        ArrayList<SubmittedMetadata> submittedList = new ArrayList<SubmittedMetadata>();
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
        Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
        JSONArray submissionsArray = new JSONArray();
        try {
            Node submitRootnode;
            Node userNode = repUtils.getUserNode(userName, false, currentSession);
            if (userNode != null && !userName.equals("anonymous") && (submitRootnode = repUtils.getChildNode(userNode, "submit", "sling:OrderedFolder", false)) != null && submitRootnode.hasNode("metadata")) {
                Node submitMetaDataRootNode = repUtils.getChildNode(submitRootnode, "metadata", "sling:OrderedFolder", false);
                submittedList.addAll(this.readSubmission(submitMetaDataRootNode, cutPoints));
                Collections.sort(submittedList);
                JSONObject formJson = null;
                for (SubmittedMetadata submittedForm : submittedList) {
                    formJson = submittedForm.getJSONObject();
                    submissionsArray.put(formJson);
                }
            }
        }
        catch (ItemExistsException e) {
            throw new FormsPortalException(e);
        }
        catch (PathNotFoundException e) {
            throw new FormsPortalException(e);
        }
        catch (NoSuchNodeTypeException e) {
            throw new FormsPortalException(e);
        }
        catch (LockException e) {
            throw new FormsPortalException(e);
        }
        catch (VersionException e) {
            throw new FormsPortalException(e);
        }
        catch (ConstraintViolationException e) {
            throw new FormsPortalException(e);
        }
        catch (RepositoryException e) {
            throw new FormsPortalException(e);
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
        return submissionsArray;
    }

    private List<SubmittedMetadata> readSubmission(Node guideNode, String cutPoints) throws ValueFormatException, PathNotFoundException, RepositoryException, Exception {
        ArrayList<SubmittedMetadata> submissionsList = new ArrayList<SubmittedMetadata>();
        NodeIterator itr = guideNode.getNodes();
        while (itr.hasNext()) {
            Node submittedMetadataNode = itr.nextNode();
            if (submittedMetadataNode.hasProperty("markedForDeletion") && ((String)PropertyUtils.getPropertyValue(submittedMetadataNode.getProperty("markedForDeletion"))).equals("true")) continue;
            SubmittedMetadata submission = new SubmittedMetadata();
            if (submittedMetadataNode.hasProperty("formName")) {
                submission.setName((String)PropertyUtils.getPropertyValue(submittedMetadataNode.getProperty("formName")));
            } else if (submittedMetadataNode.hasProperty("guideName")) {
                submission.setName((String)PropertyUtils.getPropertyValue(submittedMetadataNode.getProperty("guideName")));
            }
            if (submittedMetadataNode.hasProperty("owner")) {
                submission.setOwner((String)PropertyUtils.getPropertyValue(submittedMetadataNode.getProperty("owner")));
            }
            Object lastModifiedObj = PropertyUtils.getPropertyValue(submittedMetadataNode.getProperty("jcr:lastModified"));
            Date lastModifiedDate = null;
            if (lastModifiedObj instanceof Date) {
                lastModifiedDate = (Date)lastModifiedObj;
            } else if (lastModifiedObj instanceof String) {
                lastModifiedDate = new Date(Long.valueOf((String)lastModifiedObj));
            } else if (lastModifiedObj instanceof Long) {
                lastModifiedDate = new Date((Long)lastModifiedObj);
            }
            submission.setLastModified(lastModifiedDate);
            if (submittedMetadataNode.hasProperty("description")) {
                submission.setDescription((String)PropertyUtils.getPropertyValue(submittedMetadataNode.getProperty("description")));
            }
            if (submittedMetadataNode.hasProperty("submitID")) {
                submission.setSubmitID((String)PropertyUtils.getPropertyValue(submittedMetadataNode.getProperty("submitID")));
            }
            if (submittedMetadataNode.hasProperty("status")) {
                submission.setStatus((String)PropertyUtils.getPropertyValue(submittedMetadataNode.getProperty("status")));
            }
            List<String> cutPointsList = Arrays.asList(cutPoints.split(","));
            for (String cutPoint : cutPointsList) {
                String rt;
                if (submittedMetadataNode.hasProperty(cutPoint)) {
                    submission.setCustomProperty(cutPoint, String.valueOf(PropertyUtils.getPropertyValue(submittedMetadataNode.getProperty(cutPoint))));
                } else if (cutPoint.equals("name")) {
                    submission.setCustomProperty("name", submission.getName());
                } else {
                    submission.setCustomProperty(cutPoint, "");
                }
                if (!cutPoint.equalsIgnoreCase("showDorClass") || (rt = submittedMetadataNode.getProperty("sling:resourceType").getString()).equalsIgnoreCase("fd/fp/components/opensubmittedguide/xfaaf")) continue;
                submission.setCustomProperty(cutPoint, "__FP_display_none");
            }
            String submissionNodePath = submittedMetadataNode.getPath();
            Object[] submitNodeSplit = submissionNodePath.split("/");
            if (submitNodeSplit != null) {
                submitNodeSplit[4] = URLEncoder.encode((String)submitNodeSplit[4], "UTF-8");
            }
            submissionNodePath = StringUtils.join((Object[])submitNodeSplit, (String)"/");
            submission.setPath(submissionNodePath);
            submissionsList.add(submission);
        }
        return submissionsList;
    }

    @Override
    public String[] getProperty(String submitID, String propertyName) throws FormsPortalException {
        Session sysUserSession = null;
        try {
            Property prop;
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            Node submitMetadataNode = this.portalUtilsComponent.getMetadataNodeFromSubmitID(submitID, currentSession);
            boolean isAllowedUsingCurrentContext = false;
            boolean isReviewer = false;
            if (submitMetadataNode == null) {
                submitMetadataNode = this.portalUtilsComponent.getMetadataNodeFromSubmitID(submitID, sysUserSession);
                String formPath = submitMetadataNode.hasProperty("formPath") ? submitMetadataNode.getProperty("formPath").getString() : null;
                isReviewer = this.portalUtilsComponent.isReviewer(currentSession, formPath);
            } else {
                isAllowedUsingCurrentContext = true;
            }
            if (submitMetadataNode != null && submitMetadataNode.hasProperty(propertyName) && (isAllowedUsingCurrentContext || isReviewer) && (prop = submitMetadataNode.getProperty(propertyName)) != null) {
                if (!prop.isMultiple()) {
                    String propValue = submitMetadataNode.getProperty(propertyName).getString();
                    String[] stringArray = new String[]{propValue};
                    return stringArray;
                }
                Value[] propValueList = submitMetadataNode.getProperty(propertyName).getValues();
                ArrayList<String> attachmentStringList = new ArrayList<String>();
                for (Value propVals : propValueList) {
                    String propValStr = propVals.getString();
                    attachmentStringList.add(propValStr);
                }
                String[] stringArray = attachmentStringList.toArray(new String[0]);
                return stringArray;
            }
            String[] stringArray = new String[]{""};
            return stringArray;
        }
        catch (Exception e) {
            throw new FormsPortalException("Error occured while getting value of " + propertyName + "at submitID = " + submitID, e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
    }

    @Override
    public boolean deleteProperty(String submitID, String propertyName) throws FormsPortalException {
        boolean isAnonymous = this.portalUtilsComponent.isLoginAnonymous();
        Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
        try {
            Node submitMetadataNode;
            RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
            Session sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
            if (isAnonymous) {
                currentSession = sysUserSession;
            }
            Node userNode = repUtils.getUserNode(userName, false, currentSession);
            String submitNodeRelativePath = "submit/metadata/" + submitID;
            if (userNode != null && userNode.hasNode(submitNodeRelativePath) && (submitMetadataNode = userNode.getNode(submitNodeRelativePath)) != null && submitMetadataNode.hasProperty(propertyName)) {
                Property prop = submitMetadataNode.getProperty(propertyName);
                prop.setValue((String[])null);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new FormsPortalException("Error occured while deleting value of " + propertyName + "at submitID = " + submitID, e);
        }
        finally {
            if (isAnonymous) {
                currentSession.logout();
            }
        }
    }

    @Override
    public JSONObject getSubmissionsOfAllUsers(String formPath, String cutPoints, Map<String, String> searchOptions) throws FormsPortalException {
        Session sysUserSession = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            String orderby = "@jcr:lastModified";
            String sort = "desc";
            String limit = "30";
            String offset = "0";
            String searchValue = "";
            cutPoints = cutPoints != null ? cutPoints : "formName,formPath,submitID,formType,jcr:lastModified,owner";
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            if (formPath != null && !formPath.trim().isEmpty() && this.portalUtilsComponent.isReviewer(currentSession, formPath)) {
                if (searchOptions != null) {
                    orderby = searchOptions.get("orderby") != null ? "@" + searchOptions.get("orderby") : orderby;
                    sort = searchOptions.get("sort") != null ? searchOptions.get("sort") : sort;
                    limit = searchOptions.get("limit") != null ? searchOptions.get("limit") : limit;
                    offset = searchOptions.get("offset") != null ? searchOptions.get("offset") : offset;
                    searchValue = searchOptions.get("search") != null ? searchOptions.get("search") : searchValue;
                }
                HashMap<String, String> queryMap = new HashMap<String, String>();
                queryMap.put("path", "/content/forms/fp");
                queryMap.put("type", "nt:unstructured");
                queryMap.put("0_group.0_property", "formPath");
                queryMap.put("0_group.0_property.value", formPath);
                queryMap.put("0_group.1_property", "nodeType");
                queryMap.put("0_group.1_property.value", "fp:submittedForm");
                List<String> queryCutPointsList = Arrays.asList(cutPoints.split(","));
                int counter = 0;
                for (String cutPoint : queryCutPointsList) {
                    queryMap.put("1_group." + counter + "_fulltext", "*" + searchValue + "*");
                    queryMap.put("1_group." + counter + "_fulltext.relPath", "@" + cutPoint);
                    ++counter;
                }
                queryMap.put("1_group.p.or", "true");
                queryMap.put("p.limit", limit);
                queryMap.put("p.offset", offset);
                queryMap.put("orderby", orderby);
                queryMap.put("orderby.sort", sort);
                PredicateGroup predicates = PredicateGroup.create(queryMap);
                Query query = this.queryBuilder.createQuery(predicates, sysUserSession);
                SearchResult result = query.getResult();
                JSONObject resultObj = new JSONObject();
                resultObj.put("total", result.getTotalMatches());
                JSONArray respArr = new JSONArray();
                Iterator<Node> it = result.getNodes();
                while (it.hasNext()) {
                    Node currentNode = it.next();
                    JSONObject currentSubmission = new JSONObject();
                    List<String> cutPointsList = Arrays.asList(cutPoints.split(","));
                    for (String cutPoint : cutPointsList) {
                        if (currentNode.hasProperty(cutPoint)) {
                            currentSubmission.put(cutPoint, currentNode.getProperty(cutPoint).getString());
                            continue;
                        }
                        currentSubmission.put(cutPoint, "");
                    }
                    currentSubmission.put("submitID", currentNode.getProperty("submitID").getString());
                    respArr.put(currentSubmission);
                }
                resultObj.put("items", respArr);
                JSONObject jSONObject = resultObj;
                return jSONObject;
            }
        }
        catch (Exception e) {
            throw new FormsPortalException(e.getMessage(), e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
        return new JSONObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONArray getFormsForSubmissionReview() throws FormsPortalException {
        Session sysUserSession = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("path", "/content/forms/fp");
            queryMap.put("type", "nt:unstructured");
            queryMap.put("0_property", "formPath");
            queryMap.put("1_property", "nodeType");
            queryMap.put("1_property.value", "fp:submittedForm");
            PredicateGroup predicates = PredicateGroup.create(queryMap);
            Query query = this.queryBuilder.createQuery(predicates, sysUserSession);
            SearchResult result = query.getResult();
            Map<String, Facet> Facets2 = result.getFacets();
            Facet requiredFacet = Facets2.get("0_property");
            JSONArray respArr = new JSONArray();
            if (requiredFacet.getContainsHit()) {
                Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
                for (Bucket bucket : requiredFacet.getBuckets()) {
                    JSONObject currentForm = new JSONObject();
                    String formPath = bucket.getValue();
                    if (formPath == null || !this.portalUtilsComponent.isReviewer(currentSession, formPath)) continue;
                    currentForm.put("formPath", formPath);
                    if (sysUserSession.nodeExists(formPath)) {
                        Node formNode = sysUserSession.getNode(formPath);
                        Node metadataNode = formNode.getNode("jcr:content/metadata");
                        String formName = metadataNode != null ? metadataNode.getProperty("title").getString() : formNode.getName();
                        currentForm.put("formName", formName);
                    }
                    respArr.put(currentForm);
                }
            }
            JSONArray jSONArray = respArr;
            return jSONArray;
        }
        catch (Exception e) {
            this.log.error("Error occured while getting list of forms whose submissions are present", (Throwable)e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
        return null;
    }

    @Override
    public String addComment(String submitID, String commentContent, String owner) throws FormsPortalException {
        Session sysUserSession = null;
        try {
            String formPath;
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
            String userName = owner != null ? owner : currentSession.getUserID();
            Node submitMetadataNode = this.portalUtilsComponent.getMetadataNodeFromSubmitID(submitID, sysUserSession);
            String string = formPath = submitMetadataNode.getProperty("formPath") != null ? submitMetadataNode.getProperty("formPath").getString() : null;
            if (formPath != null && !formPath.trim().isEmpty() && this.portalUtilsComponent.isReviewer(currentSession, formPath)) {
                Node commentsRootNode = repUtils.getChildNode(submitMetadataNode, "comment", "nt:unstructured", true);
                String newNodeName = PortalUtils.getUniqueId();
                Node commentNode = commentsRootNode.addNode(newNodeName);
                commentNode.setProperty("nodeType", "fp:comment");
                commentNode.setProperty("comment", commentContent);
                commentNode.setProperty("owner", userName);
                this.updateLastModified(commentNode);
                sysUserSession.save();
                String string2 = newNodeName;
                return string2;
            }
        }
        catch (Exception e) {
            throw new FormsPortalException(e.getMessage(), e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
        return "";
    }

    @Override
    public JSONArray getAllComments(String submitID) throws FormsPortalException {
        Session sysUserSession = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            Node submitMetadataNode = this.portalUtilsComponent.getMetadataNodeFromSubmitID(submitID, sysUserSession);
            String formPath = null;
            if (submitMetadataNode != null) {
                formPath = submitMetadataNode.hasProperty("formPath") ? submitMetadataNode.getProperty("formPath").getString() : null;
            }
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            if (formPath != null && this.portalUtilsComponent.isReviewer(currentSession, formPath)) {
                String path = submitMetadataNode.getPath();
                HashMap<String, String> queryMap = new HashMap<String, String>();
                queryMap.put("path", path);
                queryMap.put("type", "nt:unstructured");
                queryMap.put("0_property", "nodeType");
                queryMap.put("0_property.value", "fp:comment");
                PredicateGroup predicates = PredicateGroup.create(queryMap);
                Query query = this.queryBuilder.createQuery(predicates, sysUserSession);
                SearchResult result = query.getResult();
                JSONArray respArr = new JSONArray();
                Iterator<Node> it = result.getNodes();
                while (it.hasNext()) {
                    Node commentNode = it.next();
                    JSONObject commentObj = new JSONObject();
                    commentObj.put("owner", commentNode.getProperty("owner").getString());
                    commentObj.put("comment", commentNode.getProperty("comment").getString());
                    Object lastModifiedObj = PropertyUtils.getPropertyValue(commentNode.getProperty("jcr:lastModified"));
                    Date lastModifiedDate = null;
                    if (lastModifiedObj instanceof Date) {
                        lastModifiedDate = (Date)lastModifiedObj;
                    } else if (lastModifiedObj instanceof String) {
                        lastModifiedDate = new Date(Long.valueOf((String)lastModifiedObj));
                    } else if (lastModifiedObj instanceof Long) {
                        lastModifiedDate = new Date((Long)lastModifiedObj);
                    }
                    commentObj.put("time", lastModifiedDate.getTime());
                    respArr.put(commentObj);
                }
                JSONArray jSONArray = respArr;
                return jSONArray;
            }
        }
        catch (Exception e) {
            throw new FormsPortalException(e.getMessage(), e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
        return new JSONArray();
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        this.draftsandSubmissionConfiguration = formsPortalDraftsandSubmissionConfigService;
    }

    protected void unbindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        if (this.draftsandSubmissionConfiguration == formsPortalDraftsandSubmissionConfigService) {
            this.draftsandSubmissionConfiguration = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindSlingSettingService(SlingSettingsService slingSettingsService) {
        this.slingSettingService = slingSettingsService;
    }

    protected void unbindSlingSettingService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingService == slingSettingsService) {
            this.slingSettingService = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }
}

