/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.util;

import com.adobe.fd.fp.model.DraftMetadata;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.fd.fp.util.PropertyUtils;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormsPortalCleanUpTask
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(FormsPortalCleanUpTask.class);
    private Session serviceSession;
    private SlingRepository slingRepository;

    public FormsPortalCleanUpTask(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.serviceSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            if (this.serviceSession != null) {
                JSONArray drafts = this.getAllDrafts("userdataID");
                for (int i = 0; i < drafts.length(); ++i) {
                    JSONObject draftJSON = drafts.getJSONObject(i);
                    String userDataId = null;
                    if (draftJSON.has("userdataID")) {
                        userDataId = draftJSON.getString("userdataID");
                    }
                    if (userDataId != null && !userDataId.isEmpty() || !draftJSON.has("path")) continue;
                    String draftNodePath = draftJSON.getString("path");
                    Node draftNode = JcrUtils.getNodeIfExists(draftNodePath = URLDecoder.decode(draftNodePath, "UTF-8"), this.serviceSession);
                    if (draftNode != null && draftNode.hasProperty("attachmentList")) {
                        Value[] propValueList;
                        for (Value propVals : propValueList = draftNode.getProperty("attachmentList").getValues()) {
                            String propValStr = propVals.getString();
                            String attachmentId = draftNode.getProperty(propValStr).getString();
                            Node attachmentNode = JcrUtils.getNodeIfExists(attachmentId, this.serviceSession);
                            if (attachmentNode == null) continue;
                            attachmentNode.remove();
                        }
                    }
                    this.serviceSession.getNode(draftNodePath).remove();
                }
                this.serviceSession.save();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.serviceSession != null && this.serviceSession.isLive()) {
                this.serviceSession.logout();
            }
        }
    }

    public JSONArray getAllDrafts(String cutPoints) {
        JSONArray draftsResult = new JSONArray();
        try {
            ArrayList<DraftMetadata> draftsList = new ArrayList<DraftMetadata>();
            Node root = this.serviceSession.getNode("/content/forms/fp");
            NodeIterator children = root.getNodes();
            while (children.hasNext()) {
                String draftMetadataNodePath = ((Node)children.next()).getPath() + "/drafts/metadata";
                Node draftsMetaDataRootNode = JcrUtils.getNodeIfExists(draftMetadataNodePath, this.serviceSession);
                if (draftsMetaDataRootNode == null) continue;
                draftsList.addAll(this.readDrafts(draftsMetaDataRootNode, cutPoints));
            }
            for (DraftMetadata draft : draftsList) {
                JSONObject draftsJson = draft.getJSONObject();
                draftsResult.put(draftsJson);
            }
            return draftsResult;
        }
        catch (Exception e) {
            this.log.error("error occured while getting all drafts", (Throwable)e);
            return draftsResult;
        }
    }

    private List<DraftMetadata> readDrafts(Node draftsMetaDataRootNode, String cutPoints) throws ValueFormatException, RepositoryException, Exception {
        ArrayList<DraftMetadata> draftsList = new ArrayList<DraftMetadata>();
        NodeIterator itr = draftsMetaDataRootNode.getNodes();
        while (itr.hasNext()) {
            Node draftNode = itr.nextNode();
            DraftMetadata draft = new DraftMetadata();
            if (draftNode.hasProperty("guideName")) {
                draft.setName((String)PropertyUtils.getPropertyValue(draftNode.getProperty("guideName")));
            } else if (draftNode.hasProperty("formName")) {
                draft.setName((String)PropertyUtils.getPropertyValue(draftNode.getProperty("formName")));
            }
            if (draftNode.hasProperty("owner")) {
                draft.setOwner((String)PropertyUtils.getPropertyValue(draftNode.getProperty("owner")));
            }
            Object lastModifiedObj = PropertyUtils.getPropertyValue(draftNode.getProperty("jcr:lastModified"));
            Date lastModifiedDate = null;
            if (lastModifiedObj instanceof Date) {
                lastModifiedDate = (Date)lastModifiedObj;
            } else if (lastModifiedObj instanceof String) {
                lastModifiedDate = new Date(Long.valueOf((String)lastModifiedObj));
            } else if (lastModifiedObj instanceof Long) {
                lastModifiedDate = new Date((Long)lastModifiedObj);
            }
            draft.setLastModified(lastModifiedDate);
            if (draftNode.hasProperty("description")) {
                draft.setDescription((String)PropertyUtils.getPropertyValue(draftNode.getProperty("description")));
            }
            if (!draftNode.hasProperty("draftID")) continue;
            draft.setDraftID((String)PropertyUtils.getPropertyValue(draftNode.getProperty("draftID")));
            List<String> cutPointsList = Arrays.asList(cutPoints.split(","));
            for (String cutPoint : cutPointsList) {
                if (draftNode.hasProperty(cutPoint)) {
                    draft.setCustomProperty(cutPoint, String.valueOf(PropertyUtils.getPropertyValue(draftNode.getProperty(cutPoint))));
                    continue;
                }
                if (cutPoint.equals("name")) {
                    draft.setCustomProperty("name", draft.getName());
                    continue;
                }
                draft.setCustomProperty(cutPoint, "");
            }
            String draftNodePath = draftNode.getPath();
            Object[] draftNodeSplit = draftNodePath.split("/");
            if (draftNodeSplit != null) {
                draftNodeSplit[4] = URLEncoder.encode((String)draftNodeSplit[4], "UTF-8");
            }
            draftNodePath = StringUtils.join((Object[])draftNodeSplit, (String)"/");
            draft.setPath(draftNodePath);
            draftsList.add(draft);
        }
        return draftsList;
    }
}

