/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.util;

import com.adobe.fd.fp.exception.FormsPortalException;
import com.day.cq.replication.AgentIdFilter;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.codec.binary.Base32;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalUtils {
    private static BundleContext bundleContext;
    private static final Logger log;

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public static Session getFnDServiceUserSession(SlingRepository repository) throws LoginException, RepositoryException {
        Session session = repository.loginService(null, null);
        return session;
    }

    public static void reverseReplicate(Session session, String path, ReplicationActionType replAction, Replicator replicator, String[] outBoxIDs) throws FormsPortalException, LoginException, ReplicationException {
        try {
            ReplicationOptions rop = new ReplicationOptions();
            AgentIdFilter filter = new AgentIdFilter(outBoxIDs);
            rop.setFilter(filter);
            replicator.replicate(session, replAction, path, rop);
        }
        catch (ReplicationException e) {
            throw new FormsPortalException(e);
        }
    }

    public static Object getService(Class<?> c, String filter) throws Exception {
        Object result = null;
        BundleContext bc = PortalUtils.getBundleContext();
        if (c.equals(BundleContext.class)) {
            result = bc;
        } else {
            ServiceReference[] ref = bc.getServiceReferences(c.getName(), filter);
            if (ref != null) {
                result = bc.getService(ref[0]);
            } else {
                ServiceReference serviceRef = bc.getServiceReference(c.getName());
                if (serviceRef != null) {
                    result = bc.getService(serviceRef);
                }
            }
        }
        return result;
    }

    public static String getRequestParamValue(SlingHttpServletRequest req, String param) {
        String paramValue = null;
        if (req.getParameter(param) != null) {
            paramValue = req.getParameter(param);
        } else if (req.getAttribute(param) != null) {
            paramValue = req.getAttribute(param).toString();
        }
        return paramValue;
    }

    public static String createUrlFromParams(String url, Map<String, String> params) {
        try {
            boolean firsParameterAdded = url.indexOf("?") != -1;
            for (Map.Entry<String, String> param : params.entrySet()) {
                String paramValue = param.getValue();
                String key = param.getKey();
                if (paramValue == null) continue;
                if (!firsParameterAdded) {
                    url = url + "?" + URLEncoder.encode(key, "utf-8") + "=" + URLEncoder.encode(paramValue, "utf-8");
                    firsParameterAdded = true;
                    continue;
                }
                url = url + "&" + URLEncoder.encode(key, "utf-8") + "=" + URLEncoder.encode(paramValue, "utf-8");
            }
        }
        catch (Exception e) {
            log.error("Error occured while creating url with parameters provided", (Throwable)e);
        }
        return url;
    }

    public static String getUniqueId() throws FormsPortalException {
        String id = String.valueOf(System.nanoTime());
        try {
            Base32 base32codec = new Base32();
            SecureRandom securerandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] idBytes = new byte[16];
            securerandom.nextBytes(idBytes);
            id = base32codec.encodeAsString(idBytes).replaceAll("=", "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new FormsPortalException(e.getMessage(), e);
        }
        return id;
    }

    static {
        log = LoggerFactory.getLogger(PortalUtils.class);
    }
}

