/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.utils;

import com.adobe.granite.activitystreams.ActivityStream;
import com.adobe.granite.activitystreams.ActivityStreamFilter;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericStreamFilter
implements ActivityStreamFilter {
    private static final Logger log = LoggerFactory.getLogger(GenericStreamFilter.class);
    private MODE mode = MODE.R;

    public boolean includes(ActivityStream stream) {
        if (this.mode == MODE.R) {
            return true;
        }
        Resource r = stream.getContainerResource();
        ResourceResolver resolver = r == null ? null : r.getResourceResolver();
        Session s = resolver == null ? null : resolver.adaptTo(Session.class);
        boolean writable = false;
        if (s != null) {
            try {
                writable = s.hasPermission(stream.getId() + "/__dummy_node__", "add_node");
            }
            catch (RepositoryException e) {
                log.error("Error while evaluating acl on {}", (Object)stream.getId(), (Object)e);
            }
        }
        if (this.mode == MODE.RO) {
            return !writable;
        }
        return writable;
    }

    public MODE getMode() {
        return this.mode;
    }

    public GenericStreamFilter setMode(MODE mode) {
        this.mode = mode;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MODE {
        R,
        RW,
        RO;

    }
}

