/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.configuration;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;

public class IdpConfiguration {
    private String idpPostUrl;
    private String idpLogoutPostUrl;
    private String idpCertAlias;

    public void setIdpCertAlias(String idpCertAlias) {
        this.idpCertAlias = idpCertAlias;
    }

    public String getIdpCertAlias() {
        return this.idpCertAlias;
    }

    public void setIdpPostUrl(String idpPostUrl) {
        this.idpPostUrl = idpPostUrl;
    }

    public void setIdpLogoutPostUrl(String idpLogoutPostUrl) {
        this.idpLogoutPostUrl = idpLogoutPostUrl;
    }

    public String getIdpPostUrl() {
        return this.idpPostUrl;
    }

    public Certificate getCertificate(KeyStore trustStore) {
        if (trustStore != null) {
            try {
                return trustStore.getCertificate(this.idpCertAlias);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Could not retrieve IdP certificate from TrustStore.", e);
            }
        }
        throw new RuntimeException("Could not access TrustStore to receive IdP certificate.");
    }

    public String getIdpLogoutPostUrl() {
        return this.idpLogoutPostUrl;
    }
}

