/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.configuration;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;

public class SpConfiguration {
    private String entityId;
    private boolean useEncryption;
    private String spPrivateKeyAlias;
    private char[] keyStorePassword;
    private int clockTolerance;

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Key getDecryptionKey(KeyStore keyStore) {
        if (keyStore != null) {
            try {
                return keyStore.getKey(this.spPrivateKeyAlias, this.keyStorePassword);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Could not retrieve SP's private key from KeyStore.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not retrieve SP's private key from KeyStore.", e);
            }
            catch (UnrecoverableKeyException e) {
                throw new RuntimeException("Could not retrieve SP's private key from KeyStore.", e);
            }
        }
        throw new RuntimeException("Could not access KeyStore to receive SP's private key.");
    }

    public boolean getUseEncryption() {
        return this.useEncryption;
    }

    public void setUseEncryption(boolean useEncryption) {
        this.useEncryption = useEncryption;
    }

    public void setSpPrivateKeyAlias(String spPrivateKeyAlias) {
        this.spPrivateKeyAlias = spPrivateKeyAlias;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword.toCharArray();
    }

    public int getClockTolerance() {
        return this.clockTolerance;
    }

    public void setClockTolerance(int clockTolerance) {
        this.clockTolerance = clockTolerance;
    }
}

