/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.util;

import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import javax.crypto.SecretKey;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RetrievalMethodEncryptedKeyResolver
extends KeyResolverSpi {
    private static Logger log = LoggerFactory.getLogger(RetrievalMethodEncryptedKeyResolver.class);
    private static final String ATTR_RETRIEVAL_METHOD = "ds:RetrievalMethod";
    private static final String TYPE_ENCRYPTED_KEY = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    private static final String NS_PREFIX_XENC = "xenc";
    private static final String NS_URI_XENC = "http://www.w3.org/2001/04/xmlenc#";
    private final String algorithm;
    private Key decryptionKey;

    public RetrievalMethodEncryptedKeyResolver(String algorithm, Key decryptionKey) {
        this.algorithm = algorithm;
        this.decryptionKey = decryptionKey;
    }

    public boolean engineCanResolve(Element element, String baseURI, StorageResolver storage) {
        return ATTR_RETRIEVAL_METHOD.equals(element.getLocalName()) && TYPE_ENCRYPTED_KEY.equals(element.getAttributeNS(null, "Type"));
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        log.debug("Lookup and resolve secret key: ", (Object)element, (Object)baseURI);
        String refURI = element.getAttributeNS(null, "URI");
        if (refURI != null && !refURI.isEmpty()) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){
                HashMap<String, String> namespaceMap = new HashMap<String, String>(){
                    {
                        this.put(RetrievalMethodEncryptedKeyResolver.NS_PREFIX_XENC, RetrievalMethodEncryptedKeyResolver.NS_URI_XENC);
                    }
                };
                HashMap<String, String> prefixMap = new HashMap<String, String>(){
                    {
                        this.put(RetrievalMethodEncryptedKeyResolver.NS_URI_XENC, RetrievalMethodEncryptedKeyResolver.NS_PREFIX_XENC);
                    }
                };

                @Override
                public String getNamespaceURI(String prefix) {
                    return this.namespaceMap.get(prefix);
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return this.prefixMap.get(namespaceURI);
                }

                public Iterator getPrefixes(String namespaceURI) {
                    return null;
                }
            });
            try {
                Element result = (Element)xpath.evaluate("//xenc:EncryptedKey[@Id='" + refURI.substring(1) + "']", element.getOwnerDocument(), XPathConstants.NODE);
                XMLCipher cipher = XMLCipher.getInstance();
                cipher.init(4, this.decryptionKey);
                EncryptedKey ek = cipher.loadEncryptedKey(result);
                SecretKey secretKey = (SecretKey)cipher.decryptKey(ek, this.algorithm);
                log.debug("Got secret key: " + secretKey);
                return secretKey;
            }
            catch (XPathExpressionException e) {
                log.error("Error retrieving secret key: ", (Throwable)e);
            }
            catch (XMLEncryptionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

