/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.util;

import com.adobe.granite.auth.saml.model.Assertion;
import com.adobe.granite.auth.saml.model.Attribute;
import com.adobe.granite.auth.saml.model.AuthnStatement;
import com.adobe.granite.auth.saml.model.Issuer;
import com.adobe.granite.auth.saml.model.LogoutRequest;
import com.adobe.granite.auth.saml.model.Message;
import com.adobe.granite.auth.saml.model.NameId;
import com.adobe.granite.auth.saml.model.Response;
import com.adobe.granite.auth.saml.model.Status;
import com.adobe.granite.auth.saml.model.Subject;
import com.adobe.granite.auth.saml.util.RetrievalMethodEncryptedKeyResolver;
import com.adobe.granite.auth.saml.util.SamlReaderException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.Key;
import java.security.Provider;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Locale;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SamlReader {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Message read(InputStream inputStream, Key decryptionKey, Key verificationKey, boolean isSamlRequest) throws SamlReaderException, IOException {
        try {
            DocumentBuilderFactory builderFactory = this.createBuilderFactory();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.parse(inputStream);
            Message msg = null;
            if (!isSamlRequest) {
                if (decryptionKey != null) {
                    doc = this.decryptResponse(doc, decryptionKey);
                }
                if ((msg = this.parse(doc, verificationKey)) == null) {
                    throw new SamlReaderException("Unable to parse document from stream.", new Exception());
                }
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                StringWriter sw = new StringWriter();
                transformer.transform(new DOMSource(doc), new StreamResult(sw));
                msg.setRawMessage(sw.toString());
            } else {
                msg = this.parseRequest(doc, verificationKey);
                if (msg == null) {
                    throw new SamlReaderException("Unable to parse document from stream.", new Exception());
                }
            }
            return msg;
        }
        catch (ParserConfigurationException e) {
            throw new SamlReaderException("Unable to create document builder factory", e);
        }
        catch (SAXException e) {
            throw new SamlReaderException("Unable to parse document from stream", e);
        }
        catch (TransformerConfigurationException e) {
            throw new SamlReaderException("Unable to parse document from stream", e);
        }
        catch (TransformerException e) {
            throw new SamlReaderException("Unable to parse document from stream", e);
        }
    }

    public Message read(InputStream inputStream, Key decryptionKey, Key verificationKey) throws SamlReaderException, IOException {
        return this.read(inputStream, decryptionKey, verificationKey, false);
    }

    private DocumentBuilderFactory createBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setExpandEntityReferences(false);
        dbf.setFeature("http://xml.org/sax/features/validation", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return dbf;
    }

    protected Response parse(Document document, Key verificationKey) {
        Element issuerElement;
        Element responseElement = this.getChildElement(document, "Response");
        if (responseElement == null) {
            this.log.error("Unable to read Response element from document.");
            return null;
        }
        responseElement.setIdAttribute("ID", true);
        Response response = new Response();
        response.setId(responseElement.getAttribute("ID"));
        response.setVersion(responseElement.getAttribute("Version"));
        response.setIssueInstant(this.getDateAttr(responseElement, "IssueInstant"));
        Element statusElement = this.getChildElement(responseElement, "Status");
        if (null != statusElement) {
            response.setStatus(this.parseStatus(statusElement));
        }
        if (null != (issuerElement = this.getChildElement(responseElement, "Issuer"))) {
            response.setIssuer(this.parseIssuer(issuerElement));
        }
        response.setInResponseTo(responseElement.getAttribute("InResponseTo"));
        response.setDestination(responseElement.getAttribute("Destination"));
        NodeList nodeList = responseElement.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element nameIdElement;
            Element assertionElement = (Element)nodeList.item(i);
            Assertion assertion = this.parseAssertion(assertionElement);
            Element subjectElement = this.getChildElement(assertionElement, "Subject");
            if (null != subjectElement && null != (nameIdElement = this.getChildElement(subjectElement, "NameID"))) {
                response.setNameId(nameIdElement.getTextContent());
                if (nameIdElement.hasAttribute("Format")) {
                    response.setNameIdFormat(nameIdElement.getAttribute("Format"));
                }
                if (nameIdElement.hasAttribute("NameQualifier")) {
                    response.setNameQualifier(nameIdElement.getAttribute("NameQualifier"));
                }
                if (nameIdElement.hasAttribute("SPNameQualifier")) {
                    response.setSpNameQualifier(nameIdElement.getAttribute("SPNameQualifier"));
                }
            }
            assertion.setSignatureValid(this.verifySignatures(responseElement, (Element)nodeList.item(i), verificationKey));
            response.addAssertion(assertion);
        }
        return response;
    }

    private LogoutRequest parseRequest(Document document, Key verificationKey) {
        Element nameIdElement;
        Element issuerElement;
        Element requestElement = this.getChildElement(document, "LogoutRequest");
        if (requestElement == null) {
            this.log.error("Could not find LogoutRequest element in document");
            return null;
        }
        LogoutRequest logoutRequest = new LogoutRequest();
        if (requestElement.hasAttribute("ID")) {
            logoutRequest.setId(requestElement.getAttribute("ID"));
        }
        if (requestElement.hasAttribute("IssueInstant")) {
            logoutRequest.setIssueInstant(this.getDateAttr(requestElement, "IssueInstant"));
        }
        if (requestElement.hasAttribute("Destination")) {
            logoutRequest.setDestination(requestElement.getAttribute("Destination"));
        }
        if ((issuerElement = this.getChildElement(requestElement, "Issuer")) != null) {
            logoutRequest.setIssuer(this.parseIssuer(issuerElement));
        }
        if ((nameIdElement = this.getChildElement(requestElement, "NameID")) != null) {
            if (nameIdElement.hasAttribute("NameFormat")) {
                logoutRequest.setNameIdFormat(nameIdElement.getAttribute("NameFormat"));
            }
            logoutRequest.setNameId(nameIdElement.getTextContent());
        }
        LinkedList<Element> sessionIndexElements = this.getChildElements(requestElement, "SessionIndex");
        for (Element sessionIndexElement : sessionIndexElements) {
            logoutRequest.addSessionIndex(sessionIndexElement.getTextContent());
        }
        logoutRequest.setSignatureValid(this.verifySignatures(requestElement, requestElement, verificationKey));
        return logoutRequest;
    }

    private boolean verifySignatures(Element parentElement, Element signedElement, Key publicKey) {
        if (publicKey != null) {
            NodeList signatureNodes = signedElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (signatureNodes.getLength() == 0) {
                this.log.warn("Received SAML message without signature element.");
                return false;
            }
            for (int j = 0; j < signatureNodes.getLength(); ++j) {
                try {
                    DOMValidateContext valContext = new DOMValidateContext(publicKey, signatureNodes.item(j));
                    valContext.setIdAttributeNS(signedElement, null, "ID");
                    valContext.setIdAttributeNS(parentElement, null, "ID");
                    String providerName = System.getProperty("jsr105Provider", "org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI");
                    XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
                    XMLSignature signature = sigFactory.unmarshalXMLSignature(valContext);
                    if (signature.validate(valContext)) continue;
                    return false;
                }
                catch (MarshalException e) {
                    this.log.error("Could not unmarshal XML signature.", (Throwable)e);
                    return false;
                }
                catch (XMLSignatureException e) {
                    this.log.error("Failed validating signature.", (Throwable)e);
                    return false;
                }
                catch (ClassNotFoundException e) {
                    this.log.error("Failed obtaining the signature provider: ", (Throwable)e);
                    return false;
                }
                catch (InstantiationException e) {
                    this.log.error("Failed obtaining the signature provider: ", (Throwable)e);
                    return false;
                }
                catch (IllegalAccessException e) {
                    this.log.error("Failed obtaining the signature provider: ", (Throwable)e);
                    return false;
                }
            }
        } else {
            this.log.warn("Could not verify signatures. Public key of IdP not provided.");
            return false;
        }
        return true;
    }

    protected Document decryptResponse(Document document, Key decryptionKey) {
        NodeList encryptedAssertions = document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
        if (0 >= encryptedAssertions.getLength()) {
            throw new RuntimeException("No EncryptedAssertion element was found");
        }
        for (int i = 0; i < encryptedAssertions.getLength(); ++i) {
            this.decryptAssertion((Element)encryptedAssertions.item(i), decryptionKey);
        }
        return document;
    }

    protected void decryptAssertion(Element encryptedAssertion, Key decryptionKey) {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            Element encryptedDataNode = (Element)encryptedAssertion.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
            Element algorithmNode = (Element)encryptedDataNode.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            String algorithm = algorithmNode.getAttributeNS(null, "Algorithm");
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            XMLCipher xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(2, null);
            xmlCipher.setKEK(decryptionKey);
            xmlCipher.registerInternalKeyResolver((KeyResolverSpi)new RetrievalMethodEncryptedKeyResolver(algorithm, decryptionKey));
            byte[] decryptedAssertion = xmlCipher.decryptToByteArray(encryptedDataNode);
            Document doc = builder.parse(new ByteArrayInputStream(decryptedAssertion));
            Node decryptedNode = encryptedAssertion.getOwnerDocument().importNode(doc.getDocumentElement(), true);
            Element parentElement = (Element)encryptedAssertion.getParentNode();
            parentElement.removeChild(encryptedAssertion);
            parentElement.appendChild(decryptedNode);
        }
        catch (XMLEncryptionException e) {
            throw new RuntimeException("Error decrypting response", e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error decrypting response", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error decrypting response", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error decrypting response", e);
        }
    }

    protected Issuer parseIssuer(Element issuerElement) {
        String value = issuerElement.getTextContent();
        if (null == value) {
            return null;
        }
        return new Issuer(value.trim());
    }

    protected Assertion parseAssertion(Element assertionElement) {
        Element audienceRestrictionElement;
        Element conditionsElement;
        Element attributeStatement;
        Assertion assertion = new Assertion();
        Element subjectElement = this.getChildElement(assertionElement, "Subject");
        if (null != subjectElement) {
            Subject subject = new Subject();
            Element nameIdElement = this.getChildElement(subjectElement, "NameID");
            if (nameIdElement != null) {
                NameId nameId = new NameId();
                nameId.setValue(nameIdElement.getTextContent());
                nameId.setFormat(nameIdElement.getAttribute("Format"));
                subject.setNameId(nameId);
            }
            assertion.setSubject(subject);
        }
        if (null != (attributeStatement = this.getChildElement(assertionElement, "AttributeStatement"))) {
            NodeList nodeList = attributeStatement.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Attribute");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                assertion.addAttribute(this.parseAttribute((Element)nodeList.item(i)));
            }
        }
        if ((conditionsElement = this.getChildElement(assertionElement, "Conditions")).hasAttribute("NotBefore")) {
            assertion.setNotBefore(this.getDateAttr(conditionsElement, "NotBefore"));
        }
        if (conditionsElement.hasAttribute("NotOnOrAfter")) {
            assertion.setNotOnOrAfter(this.getDateAttr(conditionsElement, "NotOnOrAfter"));
        }
        if (null != (audienceRestrictionElement = this.getChildElement(conditionsElement, "AudienceRestriction"))) {
            NodeList nodeList = audienceRestrictionElement.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Audience");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                assertion.addAudienceRestriction(nodeList.item(i).getTextContent());
            }
        }
        LinkedList<Element> authnStatementElements = this.getChildElements(assertionElement, "AuthnStatement");
        for (Element authnStatementElement : authnStatementElements) {
            AuthnStatement authnStatement = new AuthnStatement();
            if (authnStatementElement.hasAttribute("AuthnInstant")) {
                authnStatement.setAuthnInstant(this.getDateAttr(authnStatementElement, "AuthnInstant"));
            }
            if (authnStatementElement.hasAttribute("SessionNotOnOrAfter")) {
                authnStatement.setSessionNotOnOrAfter(this.getDateAttr(authnStatementElement, "SessionNotOnOrAfter"));
            }
            if (authnStatementElement.hasAttribute("SessionIndex")) {
                authnStatement.setSessionIndex(authnStatementElement.getAttribute("SessionIndex"));
            }
            assertion.addAuthnStatement(authnStatement);
        }
        return assertion;
    }

    protected Attribute parseAttribute(Element attributeElement) {
        Attribute attribute = new Attribute();
        attribute.setName(attributeElement.getAttribute("Name"));
        attribute.setNameFormat(attributeElement.getAttribute("NameFormat"));
        NodeList valueElements = attributeElement.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        for (int i = 0; i < valueElements.getLength(); ++i) {
            Element valueElement = (Element)valueElements.item(i);
            attribute.addAttributeValue(valueElement.getTextContent().trim());
        }
        return attribute;
    }

    protected Status parseStatus(Element statusElement) {
        Status status = new Status();
        Element statusCodeElement = this.getChildElement(statusElement, "StatusCode");
        if (null != statusCodeElement) {
            status.setStatusCode(statusCodeElement.getAttribute("Value"));
            return status;
        }
        return null;
    }

    protected Calendar getDateAttr(Element element, String attrName) {
        String value = element.getAttribute(attrName);
        if (null != value && !"".equals(value)) {
            Calendar calendar = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.forOffsetHours((int)0)).parseDateTime(value).toCalendar(Locale.getDefault());
            return calendar;
        }
        return null;
    }

    protected Element getChildElement(Node node, String name) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (1 != child.getNodeType() || !child.getLocalName().equals(name)) continue;
            return (Element)child;
        }
        return null;
    }

    protected LinkedList<Element> getChildElements(Node node, String name) {
        NodeList nodeList = node.getChildNodes();
        LinkedList<Element> childElements = new LinkedList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (1 != child.getNodeType() || !child.getLocalName().equals(name)) continue;
            childElements.add((Element)child);
        }
        return childElements;
    }

    static {
        Init.init();
    }
}

