/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.cloudsettings;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudSettingsUtil {
    public static final String MIXIN_CLOUDSETTINGS_CONFIG_TYPE = "granite:CloudsettingsConfigType";
    public static final String PROP_ALLOWED_CHILD_TYPES = "allowedChildTypes";
    public static final String PROP_ALLOWED_PARENT_TYPES = "allowedParentTypes";
    public static final String PROP_UNIQUE_NAME = "uniqueName";

    public static String getPersonDisplayName(ResourceResolver resolver, String userId) {
        String displayName = null;
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            try {
                InternetAddress[] addresses = InternetAddress.parse((String)userId);
                if (addresses.length > 0) {
                    userId = addresses[0].getAddress();
                    displayName = addresses[0].getPersonal();
                }
            }
            catch (AddressException e) {
                // empty catch block
            }
            try {
                String profileDisplayName;
                UserPropertiesManager upm = resolver.adaptTo(UserPropertiesManager.class);
                UserProperties profile = upm.getUserProperties(userId, "profile");
                if (profile != null && !StringUtils.isEmpty((CharSequence)(profileDisplayName = profile.getDisplayName()))) {
                    displayName = profileDisplayName;
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty(displayName)) {
            displayName = userId;
        }
        return displayName;
    }

    public static Iterator<Resource> getAllCloudSettingsConfigTypes(ResourceResolver resolver) {
        Iterator<Resource> searchIt = resolver.findResources("SELECT * FROM [granite:CloudsettingsConfigType]", "JCR-SQL2");
        return searchIt == null ? Collections.emptyList().iterator() : searchIt;
    }

    public static Iterator<Resource> getCloudSettingsConfigTypes(ResourceResolver resolver, Resource parentResource) {
        FilterIterator resultIt = null;
        CloudSettingsConfigTypeFilter predicate = new CloudSettingsConfigTypeFilter(parentResource);
        Iterator<Resource> searchIt = resolver.findResources("SELECT * FROM [granite:CloudsettingsConfigType]", "JCR-SQL2");
        if (searchIt != null && searchIt.hasNext()) {
            resultIt = new FilterIterator(searchIt, (Predicate)predicate);
        }
        return resultIt == null ? Collections.emptyList().iterator() : resultIt;
    }

    private static class CloudSettingsConfigTypeFilter
    implements Predicate {
        private Resource parentResource;

        public CloudSettingsConfigTypeFilter(Resource parentResource) {
            this.parentResource = parentResource;
        }

        public boolean evaluate(Object object) {
            if (object instanceof Resource) {
                Object allowedParentType;
                Resource configType = (Resource)object;
                if (configType.getParent() == null) {
                    return false;
                }
                if (!configType.getPath().startsWith("/apps") && !configType.getPath().startsWith("/libs")) {
                    return false;
                }
                ValueMap configTypeVm = ResourceUtil.getValueMap(configType);
                String uniqueName = (String)((Object)configTypeVm.get(CloudSettingsUtil.PROP_UNIQUE_NAME, String.class));
                if (StringUtils.isNotEmpty((CharSequence)uniqueName) && this.parentResource.getChild(uniqueName) != null) {
                    return false;
                }
                ResourceResolver resourceResolver = this.parentResource.getResourceResolver();
                Object[] allowedParentTypes = configTypeVm.get(CloudSettingsUtil.PROP_ALLOWED_PARENT_TYPES, new String[0]);
                boolean isParentAllowed = ArrayUtils.isEmpty((Object[])allowedParentTypes);
                Object[] arr$ = allowedParentTypes;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(isParentAllowed = resourceResolver.isResourceType(this.parentResource, (String)(allowedParentType = arr$[i$]))); ++i$) {
                }
                String parentResType = this.parentResource.getResourceType();
                Resource parentResTypeResource = resourceResolver.getResource(parentResType);
                ValueMap parentTypeVm = ResourceUtil.getValueMap(parentResTypeResource);
                Object[] allowedChildTypes = parentTypeVm.get(CloudSettingsUtil.PROP_ALLOWED_CHILD_TYPES, new String[0]);
                boolean isChildAllowed = ArrayUtils.isEmpty((Object[])allowedChildTypes);
                for (Object allowedChildType : allowedChildTypes) {
                    SyntheticResource configTypeRes = new SyntheticResource(resourceResolver, "testRes", configType.getPath());
                    isChildAllowed = resourceResolver.isResourceType(configTypeRes, (String)allowedChildType);
                    if (isChildAllowed) break;
                }
                return isParentAllowed && isChildAllowed;
            }
            return false;
        }
    }
}

