/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.contexthub.api;

import com.adobe.granite.contexthub.impl.ClientLib;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mode {
    private boolean enabled;
    private String name;
    private String resourceType;
    private ValueMap properties;
    private Resource resource;
    private String path;
    private Set<String> runModes;

    public Mode(Resource resource) {
        this.resource = resource;
        this.path = resource.getPath();
        this.properties = ResourceUtil.getValueMap(resource);
        String[] runModesProperty = (String[])this.properties.get("runModes", String[].class);
        this.enabled = this.properties.get("enabled", true);
        this.name = (String)((Object)this.properties.get("modeType", String.class));
        this.resourceType = resource.getResourceType();
        this.runModes = new TreeSet<String>();
        if (runModesProperty != null) {
            this.runModes.addAll(Arrays.asList(runModesProperty));
        }
    }

    public Set<String> getRunModes() {
        return this.runModes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getCategories() {
        ArrayList<String> clientLibs = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)this.getName())) {
            clientLibs.add(ClientLib.buildClientlibName((String[])new String[]{"mode", this.getName()}));
            clientLibs.add(ClientLib.buildClientlibName((String[])new String[]{"mode", this.getName(), "override"}));
        }
        return clientLibs;
    }
}

