/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.contexthub.api;

import com.adobe.granite.contexthub.impl.ClientLib;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store {
    private boolean enabled;
    private String name = "";
    private String path;
    private String resourceType;
    private ValueMap properties;
    private Set<String> runModes;

    public Store(Resource resource) {
        if (resource != null) {
            this.properties = ResourceUtil.getValueMap(resource);
            ValueMap properties = this.getProperties();
            String[] runModesProperty = (String[])properties.get("runModes", String[].class);
            this.enabled = properties.get("enabled", false);
            this.name = (String)((Object)properties.get("storeType", String.class));
            this.path = resource.getPath();
            this.resourceType = resource.getResourceType();
            this.runModes = new TreeSet<String>();
            if (runModesProperty != null) {
                this.runModes.addAll(Arrays.asList(runModesProperty));
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> getRunModes() {
        return this.runModes;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(ValueMap properties) {
        this.properties = properties;
    }

    public List<String> getCategories() {
        ArrayList<String> clientLibs = new ArrayList<String>();
        clientLibs.add(ClientLib.buildClientlibName((String[])new String[]{"store", this.getName()}));
        clientLibs.add(ClientLib.buildClientlibName((String[])new String[]{"store", this.getName(), "override"}));
        return clientLibs;
    }

    public String toString() {
        return String.format("'%s' (path=%s, resourceType=%s)", this.getName(), this.getPath(), this.getResourceType());
    }
}

