/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.maintenance;

import com.adobe.granite.maintenance.MaintenanceTaskInfo;
import com.adobe.granite.maintenance.impl.MaintenanceWindowImpl;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.api.resource.Resource;
import org.quartz.CronExpression;

public abstract class MaintenanceUtil {
    public static boolean isValidTimeInterval(String startTime, String endTime) {
        int[] start = MaintenanceUtil.parseTime(startTime);
        int[] end = MaintenanceUtil.parseTime(endTime);
        return start != null && end != null;
    }

    public static int[] parseTime(String value) throws IllegalArgumentException {
        int pos;
        if (value != null && value.trim().length() > 0 && (pos = value.indexOf(":")) != -1) {
            try {
                int hour = Integer.valueOf(value.substring(0, pos));
                int minute = Integer.valueOf(value.substring(pos + 1));
                if (hour >= 0 && hour <= 23 && minute >= 0 && minute <= 59) {
                    return new int[]{hour, minute};
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getCronExpression(int[] timeDef) {
        if (timeDef != null) {
            return "0 " + String.valueOf(timeDef[0]) + " " + String.valueOf(timeDef[1]) + " * * ?";
        }
        return null;
    }

    public static String getCronExpression(String time) {
        return MaintenanceUtil.getCronExpression(MaintenanceUtil.parseTime(time));
    }

    public static Calendar getNextExecutionTime(String startTime, String endTime) {
        String startCron = MaintenanceUtil.getCronExpression(MaintenanceUtil.parseTime(startTime));
        String endCron = MaintenanceUtil.getCronExpression(MaintenanceUtil.parseTime(endTime));
        if (startCron == null || endCron == null) {
            return null;
        }
        try {
            Date now = new Date();
            CronExpression startExpr = new CronExpression(startCron);
            CronExpression endExpr = new CronExpression(endCron);
            Date nextStart = startExpr.getNextValidTimeAfter(now);
            Date nextEnd = endExpr.getNextValidTimeAfter(now);
            if (nextEnd.getTime() < nextStart.getTime()) {
                return null;
            }
            Calendar nextExecution = Calendar.getInstance();
            nextExecution.setTime(nextStart);
            return nextExecution;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Calendar getNextExecutionTime(MaintenanceTaskInfo.TaskSchedule schedule, String startTime) {
        String startCron = MaintenanceUtil.getCronExpression(MaintenanceUtil.parseTime(startTime));
        if (startCron == null) {
            return null;
        }
        try {
            Date now = new Date();
            CronExpression startExpr = new CronExpression(startCron);
            Date nextStart = startExpr.getNextValidTimeAfter(now);
            Calendar nextExecution = Calendar.getInstance();
            nextExecution.setTime(nextStart);
            switch (schedule) {
                case WEEKLY: {
                    int weekDay = nextExecution.get(7);
                    if (weekDay <= 1) break;
                    nextExecution.add(7, 8 - weekDay);
                    break;
                }
                case BIWEEKLY: {
                    int week;
                    int weekDay2 = nextExecution.get(7);
                    if (weekDay2 > 1) {
                        nextExecution.add(7, 8 - weekDay2);
                    }
                    if ((week = nextExecution.getActualMaximum(3)) % 2 != 0) break;
                    nextExecution.add(4, 1);
                    break;
                }
                case MONTHLY: {
                    int dayOfMonth = nextExecution.get(5);
                    while (dayOfMonth != 1) {
                        nextExecution.add(5, 1);
                        dayOfMonth = nextExecution.get(5);
                    }
                    break;
                }
            }
            return nextExecution;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Calendar getNextWindowExecutionTime(Resource windowResource) {
        try {
            Date now = new Date();
            MaintenanceWindowImpl window = new MaintenanceWindowImpl(windowResource);
            CronExpression startExpr = new CronExpression(window.getStartCronExpression());
            CronExpression endExpr = new CronExpression(window.getEndCronExpression());
            Date nextStart = startExpr.getNextValidTimeAfter(now);
            Date nextEnd = endExpr.getNextValidTimeAfter(nextStart);
            if (nextEnd.before(nextStart)) {
                return null;
            }
            Calendar nextExecution = Calendar.getInstance();
            nextExecution.setTime(nextStart);
            return nextExecution;
        }
        catch (ParseException pe) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }
}

