/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.rest.converter.siren;

import com.adobe.granite.rest.converter.ResourceConverterContext;
import com.adobe.granite.rest.converter.ResourceConverterException;
import com.adobe.granite.rest.converter.siren.AbstractSirenConverter;
import com.adobe.granite.rest.filter.Filter;
import com.adobe.granite.rest.filter.impl.FilteredIterator;
import com.adobe.granite.rest.utils.Resources;
import com.adobe.reef.siren.Entity;
import com.adobe.reef.siren.Link;
import com.adobe.reef.siren.builder.BuilderException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractPageableSirenConverter
extends AbstractSirenConverter {
    public AbstractPageableSirenConverter(Resource resource) {
        super(resource);
    }

    @Override
    protected List<Link> getLinks(ResourceConverterContext context) throws BuilderException, ResourceConverterException {
        List<Link> links = super.getLinks(context);
        Resource parent = this.resource.getParent();
        if (parent != null) {
            links.add(this.getLink("parent", this.buildURL(context, parent.getPath(), ".json"), null));
        }
        return links;
    }

    protected abstract Entity getEntity(ResourceConverterContext var1, Resource var2) throws ResourceConverterException;

    @Override
    protected List<Entity> getEntities(ResourceConverterContext context, Iterator<Resource> children) throws BuilderException {
        LinkedList<Entity> entities = new LinkedList<Entity>();
        int offset = context.getOffset();
        int limit = context.getLimit();
        this.log.debug("offset = " + offset + ", limit = " + limit);
        int i = 0;
        int n = 0;
        Filter<Resource> filter = context.getFilter();
        if (filter != null) {
            children = new FilteredIterator(children, filter);
        }
        FilteredIterator it = children;
        while (it.hasNext()) {
            Resource childResource = (Resource)it.next();
            if (i >= offset) {
                if (n >= limit) break;
                try {
                    Entity entity = this.getEntity(context, childResource);
                    if (entity != null) {
                        entities.add(entity);
                        ++n;
                    }
                }
                catch (ResourceConverterException e) {
                    this.log.error("A conversion error occurred for resource " + childResource, (Throwable)e);
                }
            }
            ++i;
        }
        return entities;
    }

    @Override
    protected Map<String, Object> getProperties(ResourceConverterContext context, boolean isChild) {
        Map<String, Object> props = super.getProperties(context, isChild);
        if (!isChild) {
            JSONObject pagingInfo = new JSONObject();
            try {
                pagingInfo.put("limit", context.getLimit());
                pagingInfo.put("offset", context.getOffset());
                pagingInfo.put("total", Resources.getSize(this.listChildren().iterator(), context.getFilter()));
                props.put("srn:paging", pagingInfo);
            }
            catch (JSONException e) {
                this.log.error("Could not add paging info to properties", (Throwable)e);
            }
        }
        return props;
    }
}

